/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.TestHFile;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestMobStoreScanner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobStoreScanner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qf1 = Bytes.toBytes((String)"qualifier1");
    private static final byte[] qf2 = Bytes.toBytes((String)"qualifier2");
    protected final byte[] qf3 = Bytes.toBytes((String)"qualifier3");
    private static Table table;
    private static Admin admin;
    private static HColumnDescriptor hcd;
    private static HTableDescriptor desc;
    private static long defaultThreshold;
    private FileSystem fs;
    private Configuration conf;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.keyvalue.maxsize", 0x6400000);
        TEST_UTIL.getConfiguration().setInt(HRegion.HBASE_MAX_CELL_SIZE_KEY, 0x6400000);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void setUp(long threshold, TableName tn) throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
        desc = new HTableDescriptor(tn);
        hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(threshold);
        hcd.setMaxVersions(4);
        desc.addFamily(hcd);
        admin = TEST_UTIL.getAdmin();
        admin.createTable((TableDescriptor)desc);
        table = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration()).getTable(tn);
    }

    private static byte[] generateMobValue(int size) {
        byte[] mobVal = new byte[size];
        Bytes.random((byte[])mobVal);
        return mobVal;
    }

    public void setScan(Scan scan, boolean reversed, boolean mobScanRaw) {
        scan.setReversed(reversed);
        scan.setMaxVersions(4);
        if (mobScanRaw) {
            scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        }
    }

    @Test
    public void testMobStoreScanner() throws Exception {
        this.testGetFromFiles(false);
        this.testGetFromMemStore(false);
        this.testGetReferences(false);
        this.testMobThreshold(false);
        this.testGetFromArchive(false);
    }

    @Test
    public void testReversedMobStoreScanner() throws Exception {
        this.testGetFromFiles(true);
        this.testGetFromMemStore(true);
        this.testGetReferences(true);
        this.testMobThreshold(true);
        this.testGetFromArchive(true);
    }

    @Test
    public void testGetMassive() throws Exception {
        this.setUp(defaultThreshold, TableName.valueOf((String)this.name.getMethodName()));
        byte[] bigValue = new byte[0x1900000];
        Put put = new Put(row1);
        Bytes.random((byte[])bigValue);
        put.addColumn(family, qf1, bigValue);
        table.put(put);
        put = new Put(row1);
        Bytes.random((byte[])bigValue);
        put.addColumn(family, qf2, bigValue);
        table.put(put);
        put = new Put(row1);
        Bytes.random((byte[])bigValue);
        put.addColumn(family, this.qf3, bigValue);
        table.put(put);
        Get g = new Get(row1);
        table.get(g);
    }

    @Test
    public void testReadPt() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.setUp(0L, tableName);
        long ts = EnvironmentEdgeManager.currentTime();
        byte[] value1 = Bytes.toBytes((String)"value1");
        Put put1 = new Put(row1);
        put1.addColumn(family, qf1, ts, value1);
        table.put(put1);
        Put put2 = new Put(row2);
        byte[] value2 = Bytes.toBytes((String)"value2");
        put2.addColumn(family, qf1, ts, value2);
        table.put(put2);
        Scan scan = new Scan();
        scan.setCaching(1);
        ResultScanner rs = table.getScanner(scan);
        Result result = rs.next();
        Put put3 = new Put(row1);
        byte[] value3 = Bytes.toBytes((String)"value3");
        put3.addColumn(family, qf1, ts, value3);
        table.put(put3);
        Put put4 = new Put(row2);
        byte[] value4 = Bytes.toBytes((String)"value4");
        put4.addColumn(family, qf1, ts, value4);
        table.put(put4);
        Cell cell = result.getColumnLatestCell(family, qf1);
        Assert.assertArrayEquals((byte[])value1, (byte[])CellUtil.cloneValue((Cell)cell));
        admin.flush(tableName);
        result = rs.next();
        cell = result.getColumnLatestCell(family, qf1);
        Assert.assertArrayEquals((byte[])value2, (byte[])CellUtil.cloneValue((Cell)cell));
    }

    @Test
    public void testReadFromCorruptMobFilesWithReadEmptyValueOnMobCellMiss() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.setUp(0L, tableName);
        this.createRecordAndCorruptMobFile(tableName, row1, family, qf1, Bytes.toBytes((String)"value1"));
        Get get = new Get(row1);
        get.setAttribute("empty.value.on.mobcell.miss", Bytes.toBytes((boolean)true));
        Result result = table.get(get);
        Cell cell = result.getColumnLatestCell(family, qf1);
        Assert.assertEquals((long)0L, (long)cell.getValueLength());
    }

    @Test
    public void testReadFromCorruptMobFiles() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.setUp(0L, tableName);
        this.createRecordAndCorruptMobFile(tableName, row1, family, qf1, Bytes.toBytes((String)"value1"));
        Get get = new Get(row1);
        IOException ioe = null;
        try {
            table.get(get);
        }
        catch (IOException e) {
            ioe = e;
        }
        Assert.assertNotNull((Object)ioe);
        Assert.assertEquals((Object)CorruptHFileException.class.getName(), (Object)ioe.getClass().getName());
    }

    private void createRecordAndCorruptMobFile(TableName tn, byte[] row, byte[] family, byte[] qf, byte[] value) throws IOException {
        Put put1 = new Put(row);
        put1.addColumn(family, qf, value);
        table.put(put1);
        admin.flush(tn);
        Path mobFile = this.getFlushedMobFile(this.conf, this.fs, tn, Bytes.toString((byte[])family));
        Assert.assertNotNull((Object)mobFile);
        Path corruptFile = new Path(mobFile.getParent(), "dummy");
        TestHFile.truncateFile(this.fs, mobFile, corruptFile);
        this.fs.delete(mobFile, true);
        this.fs.rename(corruptFile, mobFile);
    }

    private Path getFlushedMobFile(Configuration conf, FileSystem fs, TableName table, String family) throws IOException {
        FileStatus[] hfFss;
        Path famDir = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)table, (String)family);
        for (FileStatus hfs : hfFss = fs.listStatus(famDir)) {
            if (hfs.isDirectory()) continue;
            return hfs.getPath();
        }
        return null;
    }

    private void testGetFromFiles(boolean reversed) throws Exception {
        TableName tn = TableName.valueOf((String)("testGetFromFiles" + reversed));
        this.testGet(tn, reversed, true);
    }

    private void testGetFromMemStore(boolean reversed) throws Exception {
        TableName tn = TableName.valueOf((String)("testGetFromMemStore" + reversed));
        this.testGet(tn, reversed, false);
    }

    private void testGet(TableName tableName, boolean reversed, boolean doFlush) throws Exception {
        this.setUp(defaultThreshold, tableName);
        long ts1 = EnvironmentEdgeManager.currentTime();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.addColumn(family, qf1, ts3, value);
        put1.addColumn(family, qf2, ts2, value);
        put1.addColumn(family, this.qf3, ts1, value);
        table.put(put1);
        if (doFlush) {
            admin.flush(tableName);
        }
        Scan scan = new Scan();
        this.setScan(scan, reversed, false);
        MobTestUtil.assertCellsValue(table, scan, value, 3);
    }

    private void testGetReferences(boolean reversed) throws Exception {
        TableName tn = TableName.valueOf((String)("testGetReferences" + reversed));
        this.setUp(defaultThreshold, tn);
        long ts1 = EnvironmentEdgeManager.currentTime();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.addColumn(family, qf1, ts3, value);
        put1.addColumn(family, qf2, ts2, value);
        put1.addColumn(family, this.qf3, ts1, value);
        table.put(put1);
        admin.flush(tn);
        Scan scan = new Scan();
        this.setScan(scan, reversed, true);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                TestMobStoreScanner.assertIsMobReference(cell, row1, family, value, tn);
                ++count;
            }
        }
        results.close();
        Assert.assertEquals((long)3L, (long)count);
    }

    private void testMobThreshold(boolean reversed) throws Exception {
        TableName tn = TableName.valueOf((String)("testMobThreshold" + reversed));
        this.setUp(defaultThreshold, tn);
        byte[] valueLess = TestMobStoreScanner.generateMobValue((int)defaultThreshold - 1);
        byte[] valueEqual = TestMobStoreScanner.generateMobValue((int)defaultThreshold);
        byte[] valueGreater = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        long ts1 = EnvironmentEdgeManager.currentTime();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        Put put1 = new Put(row1);
        put1.addColumn(family, qf1, ts3, valueLess);
        put1.addColumn(family, qf2, ts2, valueEqual);
        put1.addColumn(family, this.qf3, ts1, valueGreater);
        table.put(put1);
        admin.flush(tn);
        Scan scan = new Scan();
        this.setScan(scan, reversed, true);
        Cell cellLess = null;
        Cell cellEqual = null;
        Cell cellGreater = null;
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                String qf = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                if (qf.equals(Bytes.toString((byte[])qf1))) {
                    cellLess = cell;
                }
                if (qf.equals(Bytes.toString((byte[])qf2))) {
                    cellEqual = cell;
                }
                if (qf.equals(Bytes.toString((byte[])this.qf3))) {
                    cellGreater = cell;
                }
                ++count;
            }
        }
        Assert.assertEquals((long)3L, (long)count);
        TestMobStoreScanner.assertNotMobReference(cellLess, row1, family, valueLess);
        TestMobStoreScanner.assertNotMobReference(cellEqual, row1, family, valueEqual);
        TestMobStoreScanner.assertIsMobReference(cellGreater, row1, family, valueGreater, tn);
        results.close();
    }

    private void testGetFromArchive(boolean reversed) throws Exception {
        TableName tn = TableName.valueOf((String)("testGetFromArchive" + reversed));
        this.setUp(defaultThreshold, tn);
        long ts1 = EnvironmentEdgeManager.currentTime();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.addColumn(family, qf1, ts3, value);
        put1.addColumn(family, qf2, ts2, value);
        put1.addColumn(family, this.qf3, ts1, value);
        table.put(put1);
        admin.flush(tn);
        Path mobFamilyPath = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)hcd.getNameAsString());
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        FileStatus[] files = fs.listStatus(mobFamilyPath);
        Path rootDir = CommonFSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration());
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)tn);
        RegionInfo regionInfo = MobUtils.getMobRegionInfo((TableName)tn);
        Path storeArchiveDir = HFileArchiveUtil.getStoreArchivePath((Configuration)TEST_UTIL.getConfiguration(), (RegionInfo)regionInfo, (Path)tableDir, (byte[])family);
        fs.mkdirs(storeArchiveDir);
        int fileCount = 0;
        for (FileStatus file : files) {
            ++fileCount;
            Path filePath = file.getPath();
            Path src = new Path(mobFamilyPath, filePath.getName());
            Path dst = new Path(storeArchiveDir, filePath.getName());
            fs.rename(src, dst);
        }
        FileStatus[] files1 = fs.listStatus(mobFamilyPath);
        Assert.assertEquals((long)0L, (long)files1.length);
        FileStatus[] files2 = fs.listStatus(storeArchiveDir);
        Assert.assertEquals((long)fileCount, (long)files2.length);
        Scan scan = new Scan();
        this.setScan(scan, reversed, false);
        MobTestUtil.assertCellsValue(table, scan, value, 3);
    }

    private static void assertNotMobReference(Cell cell, byte[] row, byte[] family, byte[] value) throws IOException {
        Assert.assertArrayEquals((byte[])row, (byte[])CellUtil.cloneRow((Cell)cell));
        Assert.assertArrayEquals((byte[])family, (byte[])CellUtil.cloneFamily((Cell)cell));
        Assert.assertArrayEquals((byte[])value, (byte[])CellUtil.cloneValue((Cell)cell));
    }

    private static void assertIsMobReference(Cell cell, byte[] row, byte[] family, byte[] value, TableName tn) throws IOException {
        Assert.assertArrayEquals((byte[])row, (byte[])CellUtil.cloneRow((Cell)cell));
        Assert.assertArrayEquals((byte[])family, (byte[])CellUtil.cloneFamily((Cell)cell));
        Assert.assertFalse((boolean)Bytes.equals((byte[])value, (byte[])CellUtil.cloneValue((Cell)cell)));
        byte[] referenceValue = CellUtil.cloneValue((Cell)cell);
        String fileName = MobUtils.getMobFileName((Cell)cell);
        int valLen = Bytes.toInt((byte[])referenceValue, (int)0, (int)4);
        Assert.assertEquals((long)value.length, (long)valLen);
        Path mobFamilyPath = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)hcd.getNameAsString());
        Path targetPath = new Path(mobFamilyPath, fileName);
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Assert.assertTrue((boolean)fs.exists(targetPath));
    }

    static {
        defaultThreshold = 10L;
    }
}

