/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="See HBASE-27243")
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestQuotaThrottle {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaThrottle.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestQuotaThrottle.class);
    private static final int REFRESH_TIME = 1800000;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final TableName[] TABLE_NAMES = new TableName[]{TableName.valueOf((String)"TestQuotaAdmin0"), TableName.valueOf((String)"TestQuotaAdmin1"), TableName.valueOf((String)"TestQuotaAdmin2")};
    private static Table[] tables;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 1800000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        QuotaCache.TEST_FORCE_REFRESH = true;
        tables = new Table[TABLE_NAMES.length];
        for (int i = 0; i < TABLE_NAMES.length; ++i) {
            TestQuotaThrottle.tables[i] = TEST_UTIL.createTable(TABLE_NAMES[i], FAMILY);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        EnvironmentEdgeManager.reset();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i] == null) continue;
            tables[i].close();
            TEST_UTIL.deleteTable(TABLE_NAMES[i]);
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        ThrottleQuotaTestUtil.clearQuotaCache(TEST_UTIL);
    }

    @Test
    public void testUserGlobalThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doGets(60, tables));
    }

    @Test
    public void testUserGlobalReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(100, tables));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(100, tables));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doGets(60, tables));
    }

    @Test
    public void testUserTableThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doPuts(30, FAMILY, QUALIFIER, tables[1]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doGets(60, tables));
    }

    @Test
    public void testUserTableReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doGets(60, tables[0]));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables[1]));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doGets(60, tables[1]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(60, tables[0]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doPuts(30, FAMILY, QUALIFIER, tables[1]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doGets(30, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doGets(60, tables));
    }

    @Test
    public void testUserNamespaceThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)"default", (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (String)"default"));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doGets(60, tables));
    }

    @Test
    public void testUserNamespaceReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)"default", (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(60, tables[0]));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables[0]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)"default", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(60, tables[0]));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (String)"default"));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doPuts(60, FAMILY, QUALIFIER, tables));
        Assert.assertEquals((long)60L, (long)ThrottleQuotaTestUtil.doGets(60, tables));
    }

    @Test
    public void testTableGlobalThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doPuts(30, FAMILY, QUALIFIER, tables[1]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
        Assert.assertEquals((long)80L, (long)ThrottleQuotaTestUtil.doGets(80, tables[0], tables[1]));
    }

    @Test
    public void testTableGlobalReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(100, tables[0]));
        Assert.assertEquals((long)100L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doPuts(30, FAMILY, QUALIFIER, tables[1]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doGets(30, tables[1]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(100, tables[0]));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doPuts(30, FAMILY, QUALIFIER, tables[1]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doGets(30, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
        Assert.assertEquals((long)80L, (long)ThrottleQuotaTestUtil.doGets(80, tables[0], tables[1]));
    }

    @Test
    public void testNamespaceGlobalThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)"default"));
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
        Assert.assertEquals((long)40L, (long)ThrottleQuotaTestUtil.doPuts(40, FAMILY, QUALIFIER, tables[0]));
    }

    @Test
    public void testNamespaceGlobalReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)100L, (long)ThrottleQuotaTestUtil.doGets(100, tables[0]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(100, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)"default"));
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
        Assert.assertEquals((long)40L, (long)ThrottleQuotaTestUtil.doPuts(40, FAMILY, QUALIFIER, tables[0]));
    }

    @Test
    public void testUserAndTableThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)12L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[1], TABLE_NAMES[2]);
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[1], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)8L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[1]);
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)3L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)12L, (long)ThrottleQuotaTestUtil.doGets(100, tables[2]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)8L, (long)ThrottleQuotaTestUtil.doGets(100, tables[1]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)3L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (TableName)TABLE_NAMES[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0], TABLE_NAMES[1]);
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[1]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[1]);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)40L, (long)ThrottleQuotaTestUtil.doGets(40, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)40L, (long)ThrottleQuotaTestUtil.doGets(40, tables[0]));
    }

    @Test
    public void testUserGlobalBypassThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)13L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, false, TABLE_NAMES[1]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)7L, (long)ThrottleQuotaTestUtil.doGets(100, tables[1]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[2], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[2]);
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doGets(30, tables[0]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doGets(30, tables[1]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (TableName)TABLE_NAMES[2]));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES[2]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(100, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)7L, (long)ThrottleQuotaTestUtil.doGets(100, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)"default"));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, true, TABLE_NAMES[1]);
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doGets(30, tables[0]));
        Assert.assertEquals((long)30L, (long)ThrottleQuotaTestUtil.doGets(30, tables[1]));
    }

    @Test
    public void testTableWriteCapacityUnitThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.WRITE_CAPACITY_UNIT, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(20, 10, FAMILY, QUALIFIER, tables[0]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)3L, (long)ThrottleQuotaTestUtil.doPuts(20, 1025, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
    }

    @Test
    public void testTableReadCapacityUnitThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.READ_CAPACITY_UNIT, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)20L, (long)ThrottleQuotaTestUtil.doPuts(20, 10, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(20, tables[0]));
        Assert.assertEquals((long)20L, (long)ThrottleQuotaTestUtil.doPuts(20, 2015, FAMILY, QUALIFIER, tables[0]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)3L, (long)ThrottleQuotaTestUtil.doGets(20, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
    }

    @Test
    public void testTableExistsGetThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)100L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Table table = TEST_UTIL.getConnection().getTable(TABLE_NAMES[0]);
        table.exists(new Get(Bytes.toBytes((String)"abc")));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
    }

    @Test
    public void testRegionServerThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.WRITE_NUMBER, (long)5L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)"all", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)7L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, false);
        Assert.assertEquals((long)5L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, false);
        Assert.assertEquals((long)5L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)"all", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, false);
        Assert.assertEquals((long)4L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, false);
        Assert.assertEquals((long)4L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleRegionServer((String)"all"));
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, true);
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, true);
    }

    @Test
    public void testExceedThrottleQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.WRITE_NUMBER, (long)5L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)"all", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)20L, (TimeUnit)TimeUnit.SECONDS));
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)"all", (ThrottleType)ThrottleType.READ_NUMBER, (long)10L, (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, false);
        admin.exceedThrottleQuotaSwitch(true);
        ThrottleQuotaTestUtil.triggerExceedThrottleQuotaCacheRefresh(TEST_UTIL, true);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)10L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)20L, (long)ThrottleQuotaTestUtil.doPuts(25, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)"all", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)2L, (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, false);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)2L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)"all", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)20L, (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, false);
        admin.exceedThrottleQuotaSwitch(false);
        ThrottleQuotaTestUtil.triggerExceedThrottleQuotaCacheRefresh(TEST_UTIL, false);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)5L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        admin.exceedThrottleQuotaSwitch(true);
        ThrottleQuotaTestUtil.triggerExceedThrottleQuotaCacheRefresh(TEST_UTIL, true);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.unthrottleRegionServer((String)"all"));
        ThrottleQuotaTestUtil.triggerRegionServerCacheRefresh(TEST_UTIL, true);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        Assert.assertEquals((long)5L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        admin.exceedThrottleQuotaSwitch(false);
        ThrottleQuotaTestUtil.triggerExceedThrottleQuotaCacheRefresh(TEST_UTIL, false);
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
    }

    @Test
    public void testSetAndGetAllThrottleTypes() throws Exception {
        for (ThrottleType throttleType : ThrottleType.values()) {
            this.canSetAndGetUserThrottle(throttleType);
        }
    }

    private void canSetAndGetUserThrottle(ThrottleType throttleType) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        QuotaSettings setQuota = QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)throttleType, (long)123L, (TimeUnit)TimeUnit.SECONDS);
        admin.setQuota(setQuota);
        boolean found = false;
        List quotaSettings = admin.getQuota(new QuotaFilter().setUserFilter(userName));
        for (QuotaSettings settings : quotaSettings) {
            ThrottleSettings throttle;
            if (!(settings instanceof ThrottleSettings) || !userName.equals((throttle = (ThrottleSettings)settings).getUserName()) || throttle.getThrottleType() != throttleType || throttle.getSoftLimit() != 123L || throttle.getTimeUnit() != TimeUnit.SECONDS) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)("Expected to find " + throttleType.name() + " quota for user " + userName), (boolean)found);
        admin.setQuota(QuotaSettingsFactory.unthrottleUserByThrottleType((String)userName, (ThrottleType)throttleType));
    }
}

