/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestQuotaUserOverride {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaUserOverride.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final int NUM_SERVERS = 1;
    private static final String CUSTOM_OVERRIDE_KEY = "foo";
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestQuotaUserOverride");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 1000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 0);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 500);
        TEST_UTIL.getConfiguration().set("hbase.quota.user.override.key", CUSTOM_OVERRIDE_KEY);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        QuotaCache.TEST_FORCE_REFRESH = true;
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        EnvironmentEdgeManager.reset();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testUserGlobalThrottleWithCustomOverride() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userOverrideWithQuota = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userOverrideWithQuota, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        Table tableWithThrottle = TEST_UTIL.getConnection().getTableBuilder(TABLE_NAME, null).setRequestAttribute(CUSTOM_OVERRIDE_KEY, Bytes.toBytes((String)userOverrideWithQuota)).build();
        Table tableWithoutThrottle = TEST_UTIL.getConnection().getTableBuilder(TABLE_NAME, null).setRequestAttribute(CUSTOM_OVERRIDE_KEY, Bytes.toBytes((String)"anotherUser")).build();
        ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tableWithThrottle);
        ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tableWithoutThrottle);
        Assert.assertTrue((10 > ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tableWithThrottle) ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tableWithoutThrottle));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userOverrideWithQuota));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
        Assert.assertEquals((long)10L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tableWithThrottle));
        Assert.assertEquals((long)10L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tableWithoutThrottle));
    }
}

