/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionServerTracker
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerTracker.class);
    private boolean active;
    private volatile Set<ServerName> regionServers = Collections.emptySet();
    private final MasterServices server;
    private final ExecutorService executor;

    public RegionServerTracker(ZKWatcher watcher, MasterServices server) {
        super(watcher);
        this.server = server;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RegionServerTracker-%d").build());
        watcher.registerListener((ZKListener)this);
        this.refresh();
    }

    private HBaseProtos.RegionServerInfo getServerInfo(ServerName serverName) throws KeeperException, IOException {
        byte[] data;
        String nodePath = this.watcher.getZNodePaths().getRsPath(serverName);
        try {
            data = ZKUtil.getData((ZKWatcher)this.watcher, (String)nodePath);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        if (data == null) {
            LOG.warn("Server node {} does not exist, already dead?", (Object)serverName);
            return null;
        }
        if (data.length == 0 || !ProtobufUtil.isPBMagicPrefix((byte[])data)) {
            LOG.warn("Invalid data for region server node {} on zookeeper, data length = {}", (Object)serverName, (Object)data.length);
            return null;
        }
        HBaseProtos.RegionServerInfo.Builder builder = HBaseProtos.RegionServerInfo.newBuilder();
        int magicLen = ProtobufUtil.lengthOfPBMagic();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)magicLen, (int)(data.length - magicLen));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(Set<ServerName> deadServersFromPE, Set<ServerName> liveServersBeforeRestart, Set<ServerName> splittingServersFromWALDir) throws KeeperException, IOException {
        LOG.info("Upgrading RegionServerTracker to active master mode; {} have existingServerCrashProcedures, {} possibly 'live' servers, and {} 'splitting'.", new Object[]{deadServersFromPE.size(), liveServersBeforeRestart.size(), splittingServersFromWALDir.size()});
        splittingServersFromWALDir.stream().filter(s -> !deadServersFromPE.contains(s)).forEach(s -> LOG.error("{} has no matching ServerCrashProcedure", s));
        liveServersBeforeRestart.forEach(sn -> this.server.getAssignmentManager().getRegionStates().createServer((ServerName)sn));
        ServerManager serverManager = this.server.getServerManager();
        RegionServerTracker regionServerTracker = this;
        synchronized (regionServerTracker) {
            Set<ServerName> liveServers = this.regionServers;
            for (ServerName serverName : liveServers) {
                HBaseProtos.RegionServerInfo info = this.getServerInfo(serverName);
                ServerMetrics serverMetrics = info != null ? ServerMetricsBuilder.of((ServerName)serverName, (int)VersionInfoUtil.getVersionNumber(info.getVersionInfo()), (String)info.getVersionInfo().getVersion()) : ServerMetricsBuilder.of((ServerName)serverName);
                serverManager.checkAndRecordNewServer(serverName, serverMetrics);
            }
            serverManager.findDeadServersAndProcess(deadServersFromPE, liveServersBeforeRestart);
            this.active = true;
        }
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    public Set<ServerName> getRegionServers() {
        return this.regionServers;
    }

    private void processAsActiveMaster(Set<ServerName> newServers) {
        Set<ServerName> oldServers = this.regionServers;
        ServerManager serverManager = this.server.getServerManager();
        for (ServerName crashedServer : Sets.difference(oldServers, newServers)) {
            LOG.info("RegionServer ephemeral node deleted, processing expiration [{}]", (Object)crashedServer);
            serverManager.expireServer(crashedServer);
        }
        boolean newServerAdded = false;
        for (ServerName sn : newServers) {
            if (oldServers.contains(sn)) continue;
            newServerAdded = true;
            LOG.info("RegionServer ephemeral node created, adding [" + sn + "]");
        }
        if (newServerAdded && this.server.isInitialized()) {
            this.server.checkIfShouldMoveSystemRegionAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refresh() {
        Span span = TraceUtil.createSpan((String)"RegionServerTracker.refresh");
        try (Scope ignored = span.makeCurrent();){
            Set newServers;
            List names;
            try {
                names = ZKUtil.listChildrenAndWatchForNewChildren((ZKWatcher)this.watcher, (String)this.watcher.getZNodePaths().rsZNode);
            }
            catch (KeeperException e) {
                this.server.abort("Unexpected zk exception getting RS nodes", e);
                if (ignored != null) {
                    if (var4_3 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            var4_3.addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
                span.end();
                return;
            }
            Set set = newServers = CollectionUtils.isEmpty((Collection)names) ? Collections.emptySet() : names.stream().map(ServerName::parseServerName).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
            if (this.active) {
                this.processAsActiveMaster(newServers);
            }
            this.regionServers = newServers;
            span.setStatus(StatusCode.OK);
        }
        finally {
            span.end();
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.getZNodePaths().rsZNode) && !this.server.isAborted() && !this.server.isStopped()) {
            this.executor.execute(this::refresh);
        }
    }
}

