/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ClientMetaTableAccessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.DelegatingRpcScheduler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaTableAccessor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaTableAccessor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaTableAccessor.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static Connection connection;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(3);
        Configuration c = new Configuration(UTIL.getConfiguration());
        c.setLong("hbase.client.pause", 1000L);
        c.setInt("hbase.client.retries.number", 10);
        connection = ConnectionFactory.createConnection((Configuration)c);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        connection.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testIsMetaWhenAllHealthy() throws InterruptedException {
        HMaster m = UTIL.getMiniHBaseCluster().getMaster();
        Assert.assertTrue((boolean)m.waitForMetaOnline());
    }

    @Test
    public void testIsMetaWhenMetaGoesOffline() throws InterruptedException {
        HMaster m = UTIL.getMiniHBaseCluster().getMaster();
        int index = UTIL.getMiniHBaseCluster().getServerWithMeta();
        HRegionServer rsWithMeta = UTIL.getMiniHBaseCluster().getRegionServer(index);
        rsWithMeta.abort("TESTING");
        Assert.assertTrue((boolean)m.waitForMetaOnline());
    }

    @Test
    public void testRetrying() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        LOG.info("Started " + tableName);
        Table t = UTIL.createMultiRegionTable(tableName, HConstants.CATALOG_FAMILY);
        int regionCount = -1;
        try (RegionLocator r = UTIL.getConnection().getRegionLocator(tableName);){
            regionCount = r.getStartKeys().length;
        }
        final List<RegionInfo> regions = TestMetaTableAccessor.testGettingTableRegions(connection, tableName, regionCount);
        MetaTask reader = new MetaTask(connection, "reader"){

            @Override
            void metaTask() throws Throwable {
                TestMetaTableAccessor.testGetRegion(this.connection, (RegionInfo)regions.get(0));
                LOG.info("Read " + ((RegionInfo)regions.get(0)).getEncodedName());
            }
        };
        MetaTask writer = new MetaTask(connection, "writer"){

            @Override
            void metaTask() throws IOException {
                MetaTableAccessor.addRegionsToMeta((Connection)this.connection, Collections.singletonList(regions.get(0)), (int)1);
                LOG.info("Wrote " + ((RegionInfo)regions.get(0)).getEncodedName());
            }
        };
        reader.start();
        writer.start();
        long timeOut = 180000L;
        long startTime = EnvironmentEdgeManager.currentTime();
        try {
            Assert.assertTrue((boolean)reader.isProgressing());
            Assert.assertTrue((boolean)writer.isProgressing());
            for (int i = 0; i < 2; ++i) {
                LOG.info("Restart=" + i);
                UTIL.ensureSomeRegionServersAvailable(2);
                int index = -1;
                while ((index = UTIL.getMiniHBaseCluster().getServerWithMeta()) == -1 && startTime + 180000L < EnvironmentEdgeManager.currentTime()) {
                }
                if (index == -1) continue;
                UTIL.getMiniHBaseCluster().abortRegionServer(index);
                UTIL.getMiniHBaseCluster().waitOnRegionServer(index);
            }
            Assert.assertTrue((String)("reader: " + reader.toString()), (boolean)reader.isProgressing());
            Assert.assertTrue((String)("writer: " + writer.toString()), (boolean)writer.isProgressing());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.stop = true;
            writer.stop = true;
            reader.join();
            writer.join();
            t.close();
        }
        long exeTime = EnvironmentEdgeManager.currentTime() - startTime;
        Assert.assertTrue((String)("Timeout: test took " + exeTime / 1000L + " sec"), (exeTime < 180000L ? 1 : 0) != 0);
    }

    @Test
    public void testGetRegion() throws IOException, InterruptedException {
        String name = this.name.getMethodName();
        LOG.info("Started " + name);
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])Bytes.toBytes((String)"nonexistent-region"));
        Assert.assertNull((Object)pair);
        LOG.info("Finished " + name);
    }

    @Test
    public void testScanMetaForTable() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        LOG.info("Started " + tableName);
        UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        TableName greaterName = TableName.valueOf((String)"testScanMetaForTablf");
        UTIL.createTable(greaterName, HConstants.CATALOG_FAMILY);
        Assert.assertEquals((long)1L, (long)MetaTableAccessor.getTableRegions((Connection)connection, (TableName)tableName).size());
        Assert.assertEquals((long)1L, (long)MetaTableAccessor.getTableRegions((Connection)connection, (TableName)greaterName).size());
    }

    private static List<RegionInfo> testGettingTableRegions(Connection connection, TableName name, int regionCount) throws IOException, InterruptedException {
        List regions = MetaTableAccessor.getTableRegions((Connection)connection, (TableName)name);
        Assert.assertEquals((long)regionCount, (long)regions.size());
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])((RegionInfo)regions.get(0)).getRegionName());
        Assert.assertEquals((Object)((RegionInfo)regions.get(0)).getEncodedName(), (Object)((RegionInfo)pair.getFirst()).getEncodedName());
        return regions;
    }

    private static void testGetRegion(Connection connection, RegionInfo region) throws IOException, InterruptedException {
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])region.getRegionName());
        Assert.assertEquals((Object)region.getEncodedName(), (Object)((RegionInfo)pair.getFirst()).getEncodedName());
    }

    @Test
    public void testMetaLocationsForRegionReplicas() throws IOException {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)((Random)rand).nextLong());
        ServerName serverName1 = ServerName.valueOf((String)"bar", (int)60010, (long)((Random)rand).nextLong());
        ServerName serverName100 = ServerName.valueOf((String)"baz", (int)60010, (long)((Random)rand).nextLong());
        long regionId = EnvironmentEdgeManager.currentTime();
        RegionInfo primary = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo replica1 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(1).build();
        RegionInfo replica100 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(100).build();
        long seqNum0 = ((Random)rand).nextLong();
        long seqNum1 = ((Random)rand).nextLong();
        long seqNum100 = ((Random)rand).nextLong();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)primary, (ServerName)serverName0, (long)seqNum0, (long)EnvironmentEdgeManager.currentTime());
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)replica1, (ServerName)serverName1, (long)seqNum1, (long)EnvironmentEdgeManager.currentTime());
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName1, seqNum1, 1, true);
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)replica100, (ServerName)serverName100, (long)seqNum100, (long)EnvironmentEdgeManager.currentTime());
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName1, seqNum1, 1, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName100, seqNum100, 100, true);
        }
    }

    public static void assertMetaLocation(Table meta, byte[] row, ServerName serverName, long seqNum, int replicaId, boolean checkSeqNum) throws IOException {
        Get get = new Get(row);
        Result result = meta.get(get);
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerColumn((int)replicaId)), (byte[])Bytes.toBytes((String)serverName.getAddress().toString())));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getStartCodeColumn((int)replicaId)), (byte[])Bytes.toBytes((long)serverName.getStartcode())));
        if (checkSeqNum) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getSeqNumColumn((int)replicaId)), (byte[])Bytes.toBytes((long)seqNum)));
        }
    }

    public static void assertEmptyMetaLocation(Table meta, byte[] row, int replicaId) throws IOException {
        Get get = new Get(row);
        Result result = meta.get(get);
        Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerColumn((int)replicaId));
        Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getStartCodeColumn((int)replicaId));
        Assert.assertNotNull((Object)serverCell);
        Assert.assertNotNull((Object)startCodeCell);
        Assert.assertEquals((long)0L, (long)serverCell.getValueLength());
        Assert.assertEquals((long)0L, (long)startCodeCell.getValueLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtTableCreation() throws IOException {
        long regionId = EnvironmentEdgeManager.currentTime();
        RegionInfo primary = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{primary});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, primary.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, primary.getRegionName(), 2);
        }
    }

    @Test
    public void testMetaScanner() throws Exception {
        LOG.info("Starting " + this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"region_a"), Bytes.toBytes((String)"region_b")};
        UTIL.createTable(tableName, FAMILY, (byte[][])SPLIT_KEYS);
        Table table = connection.getTable(tableName);
        HBaseTestingUtil.countRows(table);
        ClientMetaTableAccessor.Visitor visitor = (ClientMetaTableAccessor.Visitor)Mockito.mock(ClientMetaTableAccessor.Visitor.class);
        ((ClientMetaTableAccessor.Visitor)Mockito.doReturn((Object)true).when((Object)visitor)).visit((Result)ArgumentMatchers.any());
        MetaTableAccessor.scanMetaForTableRegions((Connection)connection, (ClientMetaTableAccessor.Visitor)visitor, (TableName)tableName);
        ((ClientMetaTableAccessor.Visitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).visit((Result)ArgumentMatchers.any());
        Mockito.reset((Object[])new ClientMetaTableAccessor.Visitor[]{visitor});
        ((ClientMetaTableAccessor.Visitor)Mockito.doReturn((Object)true).when((Object)visitor)).visit((Result)ArgumentMatchers.any());
        MetaTableAccessor.scanMeta((Connection)connection, (ClientMetaTableAccessor.Visitor)visitor, (TableName)tableName, null, (int)1000);
        ((ClientMetaTableAccessor.Visitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).visit((Result)ArgumentMatchers.any());
        Mockito.reset((Object[])new ClientMetaTableAccessor.Visitor[]{visitor});
        ((ClientMetaTableAccessor.Visitor)Mockito.doReturn((Object)true).when((Object)visitor)).visit((Result)ArgumentMatchers.any());
        MetaTableAccessor.scanMeta((Connection)connection, (ClientMetaTableAccessor.Visitor)visitor, (TableName)tableName, (byte[])Bytes.toBytes((String)"region_ac"), (int)1000);
        ((ClientMetaTableAccessor.Visitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)2))).visit((Result)ArgumentMatchers.any());
        Mockito.reset((Object[])new ClientMetaTableAccessor.Visitor[]{visitor});
        ((ClientMetaTableAccessor.Visitor)Mockito.doReturn((Object)true).when((Object)visitor)).visit((Result)ArgumentMatchers.any());
        MetaTableAccessor.scanMeta((Connection)connection, (ClientMetaTableAccessor.Visitor)visitor, (TableName)tableName, (byte[])Bytes.toBytes((String)"region_ac"), (int)1);
        ((ClientMetaTableAccessor.Visitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)1))).visit((Result)ArgumentMatchers.any());
        table.close();
    }

    @Test
    public void testMastersSystemTimeIsUsedInUpdateLocations() throws IOException {
        long regionId = EnvironmentEdgeManager.currentTime();
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        ServerName sn = ServerName.valueOf((String)"bar", (int)0, (long)0L);
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{regionInfo});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)1);
            long masterSystemTime = EnvironmentEdgeManager.currentTime() + 123456789L;
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)regionInfo, (ServerName)sn, (long)1L, (long)masterSystemTime);
            Get get = new Get(regionInfo.getRegionName());
            Result result = meta.get(get);
            Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerColumn((int)0));
            Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getStartCodeColumn((int)0));
            Cell seqNumCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getSeqNumColumn((int)0));
            Assert.assertNotNull((Object)serverCell);
            Assert.assertNotNull((Object)startCodeCell);
            Assert.assertNotNull((Object)seqNumCell);
            Assert.assertTrue((serverCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((startCodeCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((seqNumCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)masterSystemTime, (long)serverCell.getTimestamp());
            Assert.assertEquals((long)masterSystemTime, (long)startCodeCell.getTimestamp());
            Assert.assertEquals((long)masterSystemTime, (long)seqNumCell.getTimestamp());
        }
    }

    @Test
    public void testScanByRegionEncodedNameExistingRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testScanByRegionEncodedNameExistingRegion");
        UTIL.createTable(tableName, "cf");
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        String encodedName = regions.get(0).getRegionInfo().getEncodedName();
        Result result = MetaTableAccessor.scanByRegionEncodedName((Connection)UTIL.getConnection(), (String)encodedName);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.advance());
        String resultingRowKey = CellUtil.getCellKeyAsString((Cell)result.current());
        Assert.assertTrue((boolean)resultingRowKey.contains(encodedName));
        UTIL.deleteTable(tableName);
    }

    @Test
    public void testScanByRegionEncodedNameNonExistingRegion() throws Exception {
        String encodedName = "nonexistingregion";
        Result result = MetaTableAccessor.scanByRegionEncodedName((Connection)UTIL.getConnection(), (String)"nonexistingregion");
        Assert.assertNull((Object)result);
    }

    public static class SpyingRpcScheduler
    extends DelegatingRpcScheduler {
        long numPriorityCalls = 0L;

        public SpyingRpcScheduler(RpcScheduler delegate) {
            super(delegate);
        }

        @Override
        public boolean dispatch(CallRunner task) {
            int priority = task.getRpcCall().getPriority();
            if (priority > 10) {
                ++this.numPriorityCalls;
            }
            return super.dispatch(task);
        }
    }

    public static class SpyingRpcSchedulerFactory
    extends SimpleRpcSchedulerFactory {
        public RpcScheduler create(Configuration conf, PriorityFunction priority, Abortable server) {
            RpcScheduler delegate = super.create(conf, priority, server);
            return new SpyingRpcScheduler(delegate);
        }
    }

    static abstract class MetaTask
    extends Thread {
        boolean stop = false;
        int count = 0;
        Throwable t = null;
        final Connection connection;

        MetaTask(Connection connection, String name) {
            super(name);
            this.connection = connection;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    LOG.info("Before " + this.getName() + ", count=" + this.count);
                    this.metaTask();
                    ++this.count;
                    LOG.info("After " + this.getName() + ", count=" + this.count);
                    Thread.sleep(100L);
                }
            }
            catch (Throwable t) {
                LOG.info(this.getName() + " failed", t);
                this.t = t;
            }
        }

        boolean isProgressing() throws InterruptedException {
            int currentCount = this.count;
            while (currentCount == this.count) {
                if (!this.isAlive()) {
                    return false;
                }
                if (this.t != null) {
                    return false;
                }
                Thread.sleep(10L);
            }
            return true;
        }

        @Override
        public String toString() {
            return "count=" + this.count + ", t=" + (this.t == null ? "null" : this.t.toString());
        }

        abstract void metaTask() throws Throwable;
    }
}

