/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.util.Threads;

public class SleepAtFirstRpcCall
implements RegionCoprocessor,
RegionObserver {
    static final AtomicLong ct = new AtomicLong(0L);
    static final String SLEEP_TIME_CONF_KEY = "hbase.coprocessor.SleepAtFirstRpcCall.sleepTime";
    static final long DEFAULT_SLEEP_TIME = 2000L;
    static final AtomicLong sleepTime = new AtomicLong(2000L);

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
        Configuration conf = env.getConfiguration();
        sleepTime.set(conf.getLong(SLEEP_TIME_CONF_KEY, 2000L));
    }

    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment, Result result) throws IOException {
        if (ct.incrementAndGet() == 1L) {
            Threads.sleep((long)sleepTime.get());
        }
        return result;
    }

    public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append, Result result) throws IOException {
        if (ct.incrementAndGet() == 1L) {
            Threads.sleep((long)sleepTime.get());
        }
        return result;
    }
}

