/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractTestCITimeout;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, MediumTests.class})
public class TestCISleep
extends AbstractTestCITimeout {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCISleep.class);
    private static Logger LOG = LoggerFactory.getLogger(TestCISleep.class);
    private TableName tableName;

    @Before
    public void setUp() {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @Test
    public void testRpcRetryingCallerSleep() throws Exception {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAM_NAM)).setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)AbstractTestCITimeout.SleepAndFailFirstTime.class.getName()).setProperty("hbase.coprocessor.SleepAndFailFirstTime.sleepTime", String.valueOf(2000)).build()).build();
        TEST_UTIL.getAdmin().createTable(htd);
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.setInt("hbase.client.pause", 3000);
        c.setInt("hbase.rpc.timeout", 4000);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)c);){
            AbstractTestCITimeout.SleepAndFailFirstTime.ct.set(0L);
            try (Table table = conn.getTableBuilder(this.tableName, null).setOperationTimeout(8000).build();){
                table.get(new Get(FAM_NAM));
            }
            AbstractTestCITimeout.SleepAndFailFirstTime.ct.set(0L);
            try {
                table = conn.getTableBuilder(this.tableName, null).setOperationTimeout(6000).build();
                var6_9 = null;
                try {
                    table.get(new Get(FAM_NAM));
                    Assert.fail((String)"We expect an exception here");
                }
                catch (Throwable throwable) {
                    var6_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (table != null) {
                        if (var6_9 != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable throwable) {
                                var6_9.addSuppressed(throwable);
                            }
                        } else {
                            table.close();
                        }
                    }
                }
            }
            catch (RetriesExhaustedException e) {
                LOG.info("We received an exception, as expected ", (Throwable)e);
            }
        }
    }
}

