/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.DeallocateRewriteByteBuffAllocator;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestCheckAndMutateWithByteBuff {
    private static final Logger LOG = LoggerFactory.getLogger(TestCheckAndMutateWithByteBuff.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCheckAndMutateWithByteBuff.class);
    @Rule
    public TestName name = new TestName();
    private static final byte[] CF = Bytes.toBytes((String)"CF");
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static Admin admin = null;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf.set("hbase.hregion.impl", TestCheckAndMutateRegion.class.getName());
        conf.set("hbase.bytebuff.allocator.class", DeallocateRewriteByteBuffAllocator.class.getName());
        conf.setBoolean("hbase.server.allocator.pool.enabled", true);
        conf.setInt("hbase.server.allocator.minimal.allocate.size", 1);
        conf.setInt("hbase.bucketcache.writer.threads", 20);
        conf.setInt("hbase.server.allocator.buffer.size", 1024);
        conf.set("hbase.bucketcache.ioengine", "offheap");
        conf.setInt("hbase.bucketcache.size", 64);
        conf.setInt("hbase.client.retries.number", 1);
        TEST_UTIL.startMiniCluster();
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCheckAndMutateWithByteBuffNoEncode() throws Exception {
        this.testCheckAndMutateWithByteBuff(TableName.valueOf((String)this.name.getMethodName()), DataBlockEncoding.NONE);
    }

    @Test
    public void testCheckAndMutateWithByteBuffEncode() throws Exception {
        this.testCheckAndMutateWithByteBuff(TableName.valueOf((String)this.name.getMethodName()), DataBlockEncoding.FAST_DIFF);
    }

    private void testCheckAndMutateWithByteBuff(TableName tableName, DataBlockEncoding dbe) throws Exception {
        Table testTable = this.createTable(tableName, dbe);
        byte[] checkRow = Bytes.toBytes((String)"checkRow");
        byte[] checkQualifier = Bytes.toBytes((String)"cq");
        byte[] checkValue = Bytes.toBytes((String)"checkValue");
        Put put = new Put(checkRow);
        put.addColumn(CF, checkQualifier, checkValue);
        testTable.put(put);
        admin.flush(testTable.getName());
        Assert.assertTrue((boolean)testTable.checkAndMutate(checkRow, CF).qualifier(checkQualifier).ifEquals(checkValue).thenPut(new Put(checkRow).addColumn(CF, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"testValue"))));
    }

    private Table createTable(TableName tableName, DataBlockEncoding dbe) throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setBlocksize(100).setDataBlockEncoding(dbe).build()).build();
        return TEST_UTIL.createTable(td, (byte[][])null);
    }

    public static class TestCheckAndMutateRegion
    extends HRegion {
        public TestCheckAndMutateRegion(Path tableDir, WAL log, FileSystem fs, Configuration confParam, RegionInfo info, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        public TestCheckAndMutateRegion(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        public List<Cell> get(Get get, boolean withCoprocessor) throws IOException {
            List cells = super.get(get, withCoprocessor);
            Threads.sleep((long)600L);
            return cells;
        }
    }
}

