/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientSideRegionScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.IndexOnlyLruBlockCache;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class, ClientTests.class})
public class TestClientSideRegionScanner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientSideRegionScanner.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final byte[] FAM_NAME = Bytes.toBytes((String)"f");
    private Configuration conf;
    private Path rootDir;
    private FileSystem fs;
    private TableDescriptor htd;
    private RegionInfo hri;
    private Scan scan;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.rootDir = TEST_UTIL.getDefaultRootDirPath();
        this.fs = TEST_UTIL.getTestFileSystem();
        this.htd = TEST_UTIL.getAdmin().getDescriptor(TableName.META_TABLE_NAME);
        this.hri = (RegionInfo)TEST_UTIL.getAdmin().getRegions(TableName.META_TABLE_NAME).get(0);
        this.scan = new Scan();
    }

    @Test
    public void testDefaultBlockCache() throws IOException {
        Configuration copyConf = new Configuration(this.conf);
        ClientSideRegionScanner clientSideRegionScanner = new ClientSideRegionScanner(copyConf, this.fs, this.rootDir, this.htd, this.hri, this.scan, null);
        BlockCache blockCache = clientSideRegionScanner.getRegion().getBlockCache();
        Assert.assertNotNull((Object)blockCache);
        Assert.assertTrue((boolean)(blockCache instanceof IndexOnlyLruBlockCache));
        Assert.assertTrue((0x2000000L == blockCache.getMaxSize() ? 1 : 0) != 0);
    }

    @Test
    public void testConfiguredBlockCache() throws IOException {
        Configuration copyConf = new Configuration(this.conf);
        long blockCacheFixedSize = 0x100000L;
        copyConf.setLong("hfile.onheap.block.cache.fixed.size", blockCacheFixedSize);
        ClientSideRegionScanner clientSideRegionScanner = new ClientSideRegionScanner(copyConf, this.fs, this.rootDir, this.htd, this.hri, this.scan, null);
        BlockCache blockCache = clientSideRegionScanner.getRegion().getBlockCache();
        Assert.assertNotNull((Object)blockCache);
        Assert.assertTrue((boolean)(blockCache instanceof IndexOnlyLruBlockCache));
        Assert.assertTrue((blockCacheFixedSize == blockCache.getMaxSize() ? 1 : 0) != 0);
    }

    @Test
    public void testNoBlockCache() throws IOException {
        Configuration copyConf = new Configuration(this.conf);
        copyConf.setFloat("hfile.block.cache.size", 0.0f);
        ClientSideRegionScanner clientSideRegionScanner = new ClientSideRegionScanner(copyConf, this.fs, this.rootDir, this.htd, this.hri, this.scan, null);
        BlockCache blockCache = clientSideRegionScanner.getRegion().getBlockCache();
        Assert.assertNull((Object)blockCache);
    }

    @Test
    public void testContinuesToScanIfHasMore() throws IOException {
        Configuration copyConf = new Configuration(this.conf);
        copyConf.setLong("hbase.storescanner.pread.max.bytes", 1L);
        Scan scan = new Scan();
        scan.setFilter((Filter)new FiltersRowsLessThan5());
        scan.setLimit(1);
        try (Table table = TEST_UTIL.createTable(TABLE_NAME, FAM_NAME);){
            RegionScanner scannerSpy;
            TableDescriptor htd = TEST_UTIL.getAdmin().getDescriptor(TABLE_NAME);
            RegionInfo hri = (RegionInfo)TEST_UTIL.getAdmin().getRegions(TABLE_NAME).get(0);
            for (int i = 0; i < 10; ++i) {
                table.put(TestClientSideRegionScanner.createPut(i));
            }
            TEST_UTIL.getAdmin().flush(TABLE_NAME);
            ClientSideRegionScanner clientSideRegionScanner = new ClientSideRegionScanner(copyConf, this.fs, this.rootDir, htd, hri, scan, null);
            clientSideRegionScanner.scanner = scannerSpy = (RegionScanner)Mockito.spy((Object)clientSideRegionScanner.scanner);
            Result result = clientSideRegionScanner.next();
            ((RegionScanner)Mockito.verify((Object)scannerSpy, (VerificationMode)Mockito.times((int)6))).nextRaw(ArgumentMatchers.anyList());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)Bytes.toInt((byte[])result.getRow()), (long)5L);
            Assert.assertTrue((boolean)clientSideRegionScanner.hasMore);
            for (int i = 6; i < 10; ++i) {
                result = clientSideRegionScanner.next();
                ((RegionScanner)Mockito.verify((Object)scannerSpy, (VerificationMode)Mockito.times((int)(i + 1)))).nextRaw(ArgumentMatchers.anyList());
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)Bytes.toInt((byte[])result.getRow()), (long)i);
            }
            result = clientSideRegionScanner.next();
            Assert.assertNull((Object)result);
            Assert.assertFalse((boolean)clientSideRegionScanner.hasMore);
        }
    }

    private static Put createPut(int rowAsInt) {
        byte[] row = Bytes.toBytes((int)rowAsInt);
        Put put = new Put(row);
        put.addColumn(FAM_NAME, row, row);
        return put;
    }

    private static class FiltersRowsLessThan5
    extends FilterBase {
        private FiltersRowsLessThan5() {
        }

        public boolean filterRowKey(Cell cell) {
            byte[] rowKey = Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength() + cell.getRowOffset());
            int intValue = Bytes.toInt((byte[])rowKey);
            return intValue < 5;
        }

        public boolean hasFilterRow() {
            return true;
        }
    }
}

