/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestDropTimeoutRequest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDropTimeoutRequest.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestDropTimeoutRequest.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final byte[] FAM_NAM = Bytes.toBytes((String)"f");
    private static final int RPC_RETRY = 5;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 5);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 1);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDropTimeoutRequest() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName()));
        builder.setCoprocessor(SleepLongerAtFirstCoprocessor.class.getName());
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAM_NAM).build();
        builder.setColumnFamily(cfd);
        TableDescriptor td = builder.build();
        try (Admin admin = TEST_UTIL.getConnection().getAdmin();){
            admin.createTable(td);
        }
        TableBuilder tb = TEST_UTIL.getConnection().getTableBuilder(td.getTableName(), null);
        tb.setReadRpcTimeout(4000);
        tb.setWriteRpcTimeout(4000);
        try (Table table = tb.build();){
            table.get(new Get(FAM_NAM));
        }
    }

    public static class SleepLongerAtFirstCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public static final int SLEEP_TIME = 2000;
        static final AtomicLong ct = new AtomicLong(0L);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (ct.incrementAndGet() <= 1L) {
                Threads.sleep((long)20000L);
            } else {
                Threads.sleep((long)2000L);
            }
        }
    }
}

