/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestFlushFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFlushFromClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFlushFromClient.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static AsyncConnection asyncConn;
    private static final byte[][] SPLITS;
    private static final List<byte[]> ROWS;
    private static final byte[] FAMILY_1;
    private static final byte[] FAMILY_2;
    public static final byte[][] FAMILIES;
    @Rule
    public TestName name = new TestName();
    public TableName tableName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(ROWS.size());
        asyncConn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{asyncConn});
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Table t = TEST_UTIL.createTable(this.tableName, FAMILIES, SPLITS);){
            List<Put> puts = ROWS.stream().map(r -> new Put(r)).collect(Collectors.toList());
            for (int i = 0; i != 20; ++i) {
                byte[] value = Bytes.toBytes((int)i);
                puts.forEach(p -> {
                    p.addColumn(FAMILY_1, value, value);
                    p.addColumn(FAMILY_2, value, value);
                });
            }
            t.put(puts);
        }
        Assert.assertFalse((boolean)this.getRegionInfo().isEmpty());
        Assert.assertTrue((boolean)this.getRegionInfo().stream().allMatch(r -> r.getMemStoreDataSize() != 0L));
    }

    @After
    public void tearDown() throws Exception {
        for (TableDescriptor htd : TEST_UTIL.getAdmin().listTableDescriptors()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testFlushTable() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.flush(this.tableName);
            Assert.assertFalse((boolean)this.getRegionInfo().stream().anyMatch(r -> r.getMemStoreDataSize() != 0L));
        }
    }

    @Test
    public void testFlushTableFamily() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            long sizeBeforeFlush = this.getRegionInfo().get(0).getMemStoreDataSize();
            admin.flush(this.tableName, FAMILY_1);
            Assert.assertFalse((boolean)this.getRegionInfo().stream().anyMatch(r -> r.getMemStoreDataSize() != sizeBeforeFlush / 2L));
        }
    }

    @Test
    public void testAsyncFlushTable() throws Exception {
        AsyncAdmin admin = asyncConn.getAdmin();
        admin.flush(this.tableName).get();
        Assert.assertFalse((boolean)this.getRegionInfo().stream().anyMatch(r -> r.getMemStoreDataSize() != 0L));
    }

    @Test
    public void testAsyncFlushTableFamily() throws Exception {
        AsyncAdmin admin = asyncConn.getAdmin();
        long sizeBeforeFlush = this.getRegionInfo().get(0).getMemStoreDataSize();
        admin.flush(this.tableName, FAMILY_1).get();
        Assert.assertFalse((boolean)this.getRegionInfo().stream().anyMatch(r -> r.getMemStoreDataSize() != sizeBeforeFlush / 2L));
    }

    @Test
    public void testFlushRegion() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            for (HRegion r : this.getRegionInfo()) {
                admin.flushRegion(r.getRegionInfo().getRegionName());
                TimeUnit.SECONDS.sleep(1L);
                Assert.assertEquals((long)0L, (long)r.getMemStoreDataSize());
            }
        }
    }

    @Test
    public void testFlushRegionFamily() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            for (HRegion r : this.getRegionInfo()) {
                long sizeBeforeFlush = r.getMemStoreDataSize();
                admin.flushRegion(r.getRegionInfo().getRegionName(), FAMILY_1);
                TimeUnit.SECONDS.sleep(1L);
                Assert.assertEquals((long)(sizeBeforeFlush / 2L), (long)r.getMemStoreDataSize());
            }
        }
    }

    @Test
    public void testAsyncFlushRegion() throws Exception {
        AsyncAdmin admin = asyncConn.getAdmin();
        for (HRegion r : this.getRegionInfo()) {
            admin.flushRegion(r.getRegionInfo().getRegionName()).get();
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertEquals((long)0L, (long)r.getMemStoreDataSize());
        }
    }

    @Test
    public void testAsyncFlushRegionFamily() throws Exception {
        AsyncAdmin admin = asyncConn.getAdmin();
        for (HRegion r : this.getRegionInfo()) {
            long sizeBeforeFlush = r.getMemStoreDataSize();
            admin.flushRegion(r.getRegionInfo().getRegionName(), FAMILY_1).get();
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertEquals((long)(sizeBeforeFlush / 2L), (long)r.getMemStoreDataSize());
        }
    }

    @Test
    public void testFlushRegionServer() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            for (HRegionServer rs : TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).collect(Collectors.toList())) {
                admin.flushRegionServer(rs.getServerName());
                Assert.assertFalse((boolean)this.getRegionInfo(rs).stream().anyMatch(r -> r.getMemStoreDataSize() != 0L));
            }
        }
    }

    @Test
    public void testAsyncFlushRegionServer() throws Exception {
        AsyncAdmin admin = asyncConn.getAdmin();
        for (HRegionServer rs : TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).collect(Collectors.toList())) {
            admin.flushRegionServer(rs.getServerName()).get();
            Assert.assertFalse((boolean)this.getRegionInfo(rs).stream().anyMatch(r -> r.getMemStoreDataSize() != 0L));
        }
    }

    private List<HRegion> getRegionInfo() {
        return TEST_UTIL.getHBaseCluster().getRegions(this.tableName);
    }

    private List<HRegion> getRegionInfo(HRegionServer rs) {
        return rs.getRegions().stream().filter(v -> v.getTableDescriptor().getTableName().equals((Object)this.tableName)).collect(Collectors.toList());
    }

    static {
        SPLITS = new byte[][]{Bytes.toBytes((String)"3"), Bytes.toBytes((String)"7")};
        ROWS = Arrays.asList(Bytes.toBytes((String)"1"), Bytes.toBytes((String)"4"), Bytes.toBytes((String)"8"));
        FAMILY_1 = Bytes.toBytes((String)"f1");
        FAMILY_2 = Bytes.toBytes((String)"f2");
        FAMILIES = new byte[][]{FAMILY_1, FAMILY_2};
    }
}

