/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.FromClientSideBase;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SleepAtFirstRpcCall;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.ZKConnectionRegistry;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.LongComparator;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
@RunWith(value=Parameterized.class)
public class TestFromClientSide
extends FromClientSideBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestFromClientSide.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFromClientSide.class);
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    TestFromClientSide() {
    }

    public TestFromClientSide(Class registry, int numHedgedReqs) throws Exception {
        TestFromClientSide.initialize(registry, numHedgedReqs, MultiRowMutationEndpoint.class);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({MasterRegistry.class, 1}, {MasterRegistry.class, 2}, {ZKConnectionRegistry.class, 1});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestFromClientSide.afterClass();
    }

    @Test
    public void testDuplicateAppend() throws Exception {
        TableDescriptorBuilder builder = TEST_UTIL.createModifyableTableDescriptor(this.name.getTableName(), 0, 3, Integer.MAX_VALUE, ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED);
        HashMap<String, String> kvs = new HashMap<String, String>();
        kvs.put("hbase.coprocessor.SleepAtFirstRpcCall.sleepTime", "2000");
        builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)SleepAtFirstRpcCall.class.getName()).setPriority(1).setProperties(kvs).build());
        TEST_UTIL.createTable(builder.build(), (byte[][])new byte[][]{ROW}).close();
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.setInt("hbase.client.pause", 50);
        c.setInt("hbase.rpc.timeout", 1500);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)c);
             Table table = connection.getTableBuilder(this.name.getTableName(), null).setOperationTimeout(3000).build();){
            Append append = new Append(ROW);
            append.addColumn(HBaseTestingUtil.fam1, QUALIFIER, VALUE);
            Result result = table.append(append);
            Cell[] cells = result.rawCells();
            Assert.assertEquals((long)1L, (long)cells.length);
            this.assertKey(cells[0], ROW, HBaseTestingUtil.fam1, QUALIFIER, VALUE);
            Result readResult = table.get(new Get(ROW));
            cells = readResult.rawCells();
            Assert.assertEquals((long)1L, (long)cells.length);
            this.assertKey(cells[0], ROW, HBaseTestingUtil.fam1, QUALIFIER, VALUE);
        }
    }

    @Test
    public void testDuplicateBatchAppend() throws Exception {
        TableDescriptorBuilder builder = TEST_UTIL.createModifyableTableDescriptor(this.name.getTableName(), 0, 3, Integer.MAX_VALUE, ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED);
        HashMap<String, String> kvs = new HashMap<String, String>();
        kvs.put("hbase.coprocessor.SleepAtFirstRpcCall.sleepTime", "2000");
        builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)SleepAtFirstRpcCall.class.getName()).setPriority(1).setProperties(kvs).build());
        TEST_UTIL.createTable(builder.build(), (byte[][])new byte[][]{ROW}).close();
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.setInt("hbase.client.pause", 50);
        c.setInt("hbase.rpc.timeout", 1500);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)c);
             Table table = connection.getTableBuilder(this.name.getTableName(), null).setOperationTimeout(3000).build();){
            Append append = new Append(ROW);
            append.addColumn(HBaseTestingUtil.fam1, QUALIFIER, VALUE);
            Object[] results = new Object[1];
            table.batch(Collections.singletonList(append), results);
            Cell[] cells = ((Result)results[0]).rawCells();
            Assert.assertEquals((long)1L, (long)cells.length);
            this.assertKey(cells[0], ROW, HBaseTestingUtil.fam1, QUALIFIER, VALUE);
            Result readResult = table.get(new Get(ROW));
            cells = readResult.rawCells();
            Assert.assertEquals((long)1L, (long)cells.length);
            this.assertKey(cells[0], ROW, HBaseTestingUtil.fam1, QUALIFIER, VALUE);
        }
    }

    @Test
    public void testKeepDeletedCells() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] C0 = Bytes.toBytes((String)"c0");
        byte[] T1 = Bytes.toBytes((String)"T1");
        byte[] T2 = Bytes.toBytes((String)"T2");
        byte[] T3 = Bytes.toBytes((String)"T3");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setKeepDeletedCells(KeepDeletedCells.TRUE).setMaxVersions(3).build()).build();
        TEST_UTIL.getAdmin().createTable(tableDescriptor);
        try (Table h = TEST_UTIL.getConnection().getTable(tableName);){
            long ts = EnvironmentEdgeManager.currentTime();
            Put p = new Put(T1, ts);
            p.addColumn(FAMILY, C0, T1);
            h.put(p);
            p = new Put(T1, ts + 2L);
            p.addColumn(FAMILY, C0, T2);
            h.put(p);
            p = new Put(T1, ts + 4L);
            p.addColumn(FAMILY, C0, T3);
            h.put(p);
            Delete d = new Delete(T1, ts + 3L);
            h.delete(d);
            d = new Delete(T1, ts + 3L);
            d.addColumns(FAMILY, C0, ts + 3L);
            h.delete(d);
            Get g = new Get(T1);
            g.setTimeRange(0L, ts + 3L);
            Result r = h.get(g);
            Assert.assertArrayEquals((byte[])T2, (byte[])r.getValue(FAMILY, C0));
            Scan s = new Scan().withStartRow(T1);
            s.setTimeRange(0L, ts + 3L);
            s.readAllVersions();
            ResultScanner scanner = h.getScanner(s);
            Cell[] kvs = scanner.next().rawCells();
            Assert.assertArrayEquals((byte[])T2, (byte[])CellUtil.cloneValue((Cell)kvs[0]));
            Assert.assertArrayEquals((byte[])T1, (byte[])CellUtil.cloneValue((Cell)kvs[1]));
            scanner.close();
            s = new Scan().withStartRow(T1);
            s.setRaw(true);
            s.readAllVersions();
            scanner = h.getScanner(s);
            kvs = scanner.next().rawCells();
            Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)kvs[0]));
            Assert.assertArrayEquals((byte[])T3, (byte[])CellUtil.cloneValue((Cell)kvs[1]));
            Assert.assertTrue((boolean)CellUtil.isDelete((Cell)kvs[2]));
            Assert.assertArrayEquals((byte[])T2, (byte[])CellUtil.cloneValue((Cell)kvs[3]));
            Assert.assertArrayEquals((byte[])T1, (byte[])CellUtil.cloneValue((Cell)kvs[4]));
            scanner.close();
        }
    }

    @Test
    public void testPurgeFutureDeletes() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[] ROW = Bytes.toBytes((String)"row");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN = Bytes.toBytes((String)"column");
        byte[] VALUE = Bytes.toBytes((String)"value");
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            long ts = EnvironmentEdgeManager.currentTime() * 2L;
            Put put = new Put(ROW, ts);
            put.addColumn(FAMILY, COLUMN, VALUE);
            table.put(put);
            Get get = new Get(ROW);
            Result result = table.get(get);
            Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, COLUMN));
            Delete del = new Delete(ROW);
            del.addColumn(FAMILY, COLUMN, ts);
            table.delete(del);
            get = new Get(ROW);
            result = table.get(get);
            Assert.assertNull((Object)result.getValue(FAMILY, COLUMN));
            TEST_UTIL.getAdmin().flush(tableName);
            TEST_UTIL.getAdmin().majorCompact(tableName);
            TEST_UTIL.waitFor(6000L, () -> TEST_UTIL.getAdmin().getCompactionState(tableName) == CompactionState.NONE);
            put = new Put(ROW, ts);
            put.addColumn(FAMILY, COLUMN, VALUE);
            table.put(put);
            get = new Get(ROW);
            result = table.get(get);
            Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, COLUMN));
        }
    }

    @Test
    public void testGetConfiguration() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Table table = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES);){
            Assert.assertSame((Object)conf, (Object)table.getConfiguration());
        }
    }

    @Test
    public void testWeirdCacheBehaviour() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"trans-blob"), Bytes.toBytes((String)"trans-type"), Bytes.toBytes((String)"trans-date"), Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"trans-group")};
        try (Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES);){
            String value = "this is the value";
            String value2 = "this is some other value";
            String keyPrefix1 = HBaseTestingUtil.getRandomUUID().toString();
            String keyPrefix2 = HBaseTestingUtil.getRandomUUID().toString();
            String keyPrefix3 = HBaseTestingUtil.getRandomUUID().toString();
            this.putRows(ht, 3, value, keyPrefix1);
            this.putRows(ht, 3, value, keyPrefix2);
            this.putRows(ht, 3, value, keyPrefix3);
            this.putRows(ht, 3, value2, keyPrefix1);
            this.putRows(ht, 3, value2, keyPrefix2);
            this.putRows(ht, 3, value2, keyPrefix3);
            try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
                System.out.println("Checking values for key: " + keyPrefix1);
                Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
                System.out.println("Checking values for key: " + keyPrefix2);
                Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
                System.out.println("Checking values for key: " + keyPrefix3);
                Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix3, value2, table));
                this.deleteColumns(ht, value2, keyPrefix1);
                this.deleteColumns(ht, value2, keyPrefix2);
                this.deleteColumns(ht, value2, keyPrefix3);
                System.out.println("Starting important checks.....");
                Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (long)0L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
                Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (long)0L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
                Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (long)0L, (long)this.getNumberOfRows(keyPrefix3, value2, table));
            }
        }
    }

    @Test
    public void testFilterAcrossMultipleRegions() throws IOException {
        TableName tableName = this.name.getTableName();
        try (Table t = TEST_UTIL.createTable(tableName, FAMILY);){
            int rowCount = TEST_UTIL.loadTable(t, FAMILY, false);
            this.assertRowCount(t, rowCount);
            List<HRegionLocation> regions = this.splitTable(t);
            this.assertRowCount(t, rowCount);
            byte[] endKey = regions.get(0).getRegion().getEndKey();
            int endKeyCount = HBaseTestingUtil.countRows(t, this.createScanWithRowFilter(endKey));
            Assert.assertTrue((endKeyCount < rowCount ? 1 : 0) != 0);
            byte[] key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 1)};
            int plusOneCount = HBaseTestingUtil.countRows(t, this.createScanWithRowFilter(key));
            Assert.assertEquals((long)(endKeyCount + 1), (long)plusOneCount);
            key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 2)};
            int plusTwoCount = HBaseTestingUtil.countRows(t, this.createScanWithRowFilter(key));
            Assert.assertEquals((long)(endKeyCount + 2), (long)plusTwoCount);
            key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] - 1)};
            int minusOneCount = HBaseTestingUtil.countRows(t, this.createScanWithRowFilter(key));
            Assert.assertEquals((long)(endKeyCount - 1), (long)minusOneCount);
            key = new byte[]{97, 97, 97};
            int countBBB = HBaseTestingUtil.countRows(t, this.createScanWithRowFilter(key, null, CompareOperator.EQUAL));
            Assert.assertEquals((long)1L, (long)countBBB);
            int countGreater = HBaseTestingUtil.countRows(t, this.createScanWithRowFilter(endKey, null, CompareOperator.GREATER_OR_EQUAL));
            Assert.assertEquals((long)0L, (long)countGreater);
            countGreater = HBaseTestingUtil.countRows(t, this.createScanWithRowFilter(endKey, endKey, CompareOperator.GREATER_OR_EQUAL));
            Assert.assertEquals((long)(rowCount - endKeyCount), (long)countGreater);
        }
    }

    @Test
    public void testSuperSimple() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            Scan scan = new Scan();
            scan.addColumn(FAMILY, tableName.toBytes());
            ResultScanner scanner = ht.getScanner(scan);
            Result result = scanner.next();
            Assert.assertNull((String)"Expected null result", (Object)result);
            scanner.close();
        }
    }

    @Test
    public void testMaxKeyValueSize() throws Exception {
        TableName tableName = this.name.getTableName();
        Configuration conf = TEST_UTIL.getConfiguration();
        String oldMaxSize = conf.get("hbase.client.keyvalue.maxsize");
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[] value = new byte[0x400000];
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, value);
            ht.put(put);
            try {
                TEST_UTIL.getConfiguration().setInt("hbase.client.keyvalue.maxsize", 0x200000);
                try (Connection connection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                     Table t = connection.getTable(TableName.valueOf((byte[])FAMILY));){
                    put = new Put(ROW);
                    put.addColumn(FAMILY, QUALIFIER, value);
                    t.put(put);
                }
                Assert.fail((String)"Inserting a too large KeyValue worked, should throw exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        conf.set("hbase.client.keyvalue.maxsize", oldMaxSize);
    }

    @Test
    public void testFilters() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[][] ROWS = this.makeN(ROW, 10);
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
            for (int i = 0; i < 10; ++i) {
                Put put = new Put(ROWS[i]);
                put.setDurability(Durability.SKIP_WAL);
                put.addColumn(FAMILY, QUALIFIERS[i], VALUE);
                ht.put(put);
            }
            Scan scan = new Scan();
            scan.addFamily(FAMILY);
            QualifierFilter filter = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator("col[1-5]"));
            scan.setFilter((Filter)filter);
            try (ResultScanner scanner = ht.getScanner(scan);){
                int expectedIndex = 1;
                for (Result result : scanner) {
                    Assert.assertEquals((long)1L, (long)result.size());
                    Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[expectedIndex]));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneQualifier((Cell)result.rawCells()[0]), (byte[])QUALIFIERS[expectedIndex]));
                    ++expectedIndex;
                }
                Assert.assertEquals((long)6L, (long)expectedIndex);
            }
        }
    }

    @Test
    public void testFilterWithLongCompartor() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            int i;
            byte[][] ROWS = this.makeN(ROW, 10);
            byte[][] values = new byte[10][];
            for (i = 0; i < 10; ++i) {
                values[i] = Bytes.toBytes((long)(100L * (long)i));
            }
            for (i = 0; i < 10; ++i) {
                Put put = new Put(ROWS[i]);
                put.setDurability(Durability.SKIP_WAL);
                put.addColumn(FAMILY, QUALIFIER, values[i]);
                ht.put(put);
            }
            Scan scan = new Scan();
            scan.addFamily(FAMILY);
            SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILY, QUALIFIER, CompareOperator.GREATER, (ByteArrayComparable)new LongComparator(500L));
            scan.setFilter((Filter)filter);
            try (ResultScanner scanner = ht.getScanner(scan);){
                int expectedIndex = 0;
                for (Result result : scanner) {
                    Assert.assertEquals((long)1L, (long)result.size());
                    Assert.assertTrue((Bytes.toLong((byte[])result.getValue(FAMILY, QUALIFIER)) > 500L ? 1 : 0) != 0);
                    ++expectedIndex;
                }
                Assert.assertEquals((long)4L, (long)expectedIndex);
            }
        }
    }

    @Test
    public void testKeyOnlyFilter() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[][] ROWS = this.makeN(ROW, 10);
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
            for (int i = 0; i < 10; ++i) {
                Put put = new Put(ROWS[i]);
                put.setDurability(Durability.SKIP_WAL);
                put.addColumn(FAMILY, QUALIFIERS[i], VALUE);
                ht.put(put);
            }
            Scan scan = new Scan();
            scan.addFamily(FAMILY);
            KeyOnlyFilter filter = new KeyOnlyFilter(true);
            scan.setFilter((Filter)filter);
            try (ResultScanner scanner = ht.getScanner(scan);){
                int count = 0;
                for (Result result : scanner) {
                    Assert.assertEquals((long)1L, (long)result.size());
                    Assert.assertEquals((long)4L, (long)result.rawCells()[0].getValueLength());
                    Assert.assertEquals((long)VALUE.length, (long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0])));
                    ++count;
                }
                Assert.assertEquals((long)10L, (long)count);
            }
        }
    }

    @Test
    public void testSimpleMissing() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[][] ROWS = this.makeN(ROW, 4);
            Get get = new Get(ROWS[0]);
            Result result = ht.get(get);
            this.assertEmptyResult(result);
            get = new Get(ROWS[0]);
            get.addFamily(FAMILY);
            result = ht.get(get);
            this.assertEmptyResult(result);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILY, QUALIFIER);
            result = ht.get(get);
            this.assertEmptyResult(result);
            Scan scan = new Scan();
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan().withStartRow(ROWS[0]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan().withStartRow(ROWS[0]).withStopRow(ROWS[1]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan();
            scan.addFamily(FAMILY);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan();
            scan.addColumn(FAMILY, QUALIFIER);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            Put put = new Put(ROWS[2]);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            get = new Get(ROWS[1]);
            result = ht.get(get);
            this.assertEmptyResult(result);
            get = new Get(ROWS[0]);
            get.addFamily(FAMILY);
            result = ht.get(get);
            this.assertEmptyResult(result);
            get = new Get(ROWS[3]);
            get.addColumn(FAMILY, QUALIFIER);
            result = ht.get(get);
            this.assertEmptyResult(result);
            scan = new Scan().withStartRow(ROWS[3]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan().withStartRow(ROWS[0]).withStopRow(ROWS[2]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            get = new Get(ROWS[2]);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
            get = new Get(ROWS[2]);
            get.addFamily(FAMILY);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
            get = new Get(ROWS[2]);
            get.addColumn(FAMILY, QUALIFIER);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
            scan = new Scan();
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
            scan = new Scan().withStartRow(ROWS[0]).withStopRow(ROWS[3]);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
            scan = new Scan().withStartRow(ROWS[2]).withStopRow(ROWS[3]);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        }
    }

    @Test
    public void testSingleRowMultipleFamily() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] ROWS = this.makeN(ROW, 3);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 10);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, 10);
        byte[][] VALUES = this.makeN(VALUE, 10);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILIES);){
            Put put = new Put(ROWS[0]);
            put.addColumn(FAMILIES[4], QUALIFIERS[0], VALUES[0]);
            ht.put(put);
            this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
            this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
            this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
            this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
            TEST_UTIL.flush();
            this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
            this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
            this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
            this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
            put = new Put(ROWS[0]);
            put.addColumn(FAMILIES[2], QUALIFIERS[2], VALUES[2]);
            put.addColumn(FAMILIES[2], QUALIFIERS[4], VALUES[4]);
            put.addColumn(FAMILIES[4], QUALIFIERS[4], VALUES[4]);
            put.addColumn(FAMILIES[6], QUALIFIERS[6], VALUES[6]);
            put.addColumn(FAMILIES[6], QUALIFIERS[7], VALUES[7]);
            put.addColumn(FAMILIES[7], QUALIFIERS[7], VALUES[7]);
            put.addColumn(FAMILIES[9], QUALIFIERS[0], VALUES[0]);
            ht.put(put);
            this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
            this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
            TEST_UTIL.flush();
            this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
            this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
            put = new Put(ROWS[0]);
            put.addColumn(FAMILIES[6], QUALIFIERS[5], VALUES[5]);
            put.addColumn(FAMILIES[6], QUALIFIERS[8], VALUES[8]);
            put.addColumn(FAMILIES[6], QUALIFIERS[9], VALUES[9]);
            put.addColumn(FAMILIES[4], QUALIFIERS[3], VALUES[3]);
            ht.put(put);
            Delete delete = new Delete(ROWS[0]);
            delete.addColumns(FAMILIES[6], QUALIFIERS[7]);
            ht.delete(delete);
            Get get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[6], QUALIFIERS[7]);
            Result result = ht.get(get);
            this.assertEmptyResult(result);
            Scan scan = new Scan();
            scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[6], QUALIFIERS[6]);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[6], QUALIFIERS[8]);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
            scan = new Scan();
            scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
            scan = new Scan();
            scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
            delete = new Delete(ROWS[0]);
            delete.addColumns(FAMILIES[6], QUALIFIERS[8]);
            ht.delete(delete);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[6], QUALIFIERS[8]);
            result = ht.get(get);
            this.assertEmptyResult(result);
            scan = new Scan();
            scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[6], QUALIFIERS[6]);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[6], QUALIFIERS[9]);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
            scan = new Scan();
            scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
            scan = new Scan();
            scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
            delete = new Delete(ROWS[0]);
            delete.addFamily(FAMILIES[4]);
            ht.delete(delete);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[4], QUALIFIERS[4]);
            result = ht.get(get);
            this.assertEmptyResult(result);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[4], QUALIFIERS[3]);
            result = ht.get(get);
            this.assertEmptyResult(result);
            get = new Get(ROWS[0]);
            get.addFamily(FAMILIES[4]);
            result = ht.get(get);
            this.assertEmptyResult(result);
            scan = new Scan();
            scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan();
            scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan();
            scan.addFamily(FAMILIES[4]);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[2], QUALIFIERS[2]);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
            get = new Get(ROWS[0]);
            get.addColumn(FAMILIES[6], QUALIFIERS[9]);
            result = ht.get(get);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
            scan = new Scan();
            scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
            scan = new Scan();
            scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
            TEST_UTIL.flush();
            this.assertEmptyResult(ht.get(new Get(ROWS[0]).addColumn(FAMILIES[4], QUALIFIERS[4])));
            this.assertEmptyResult(ht.get(new Get(ROWS[0]).addColumn(FAMILIES[4], QUALIFIERS[3])));
            this.assertEmptyResult(ht.get(new Get(ROWS[0]).addFamily(FAMILIES[4])));
            this.assertNullResult(this.getSingleScanResult(ht, new Scan().addColumn(FAMILIES[4], QUALIFIERS[4])));
            this.assertNullResult(this.getSingleScanResult(ht, new Scan().addColumn(FAMILIES[4], QUALIFIERS[3])));
            this.assertNullResult(this.getSingleScanResult(ht, new Scan().addFamily(FAMILIES[4])));
            this.assertSingleResult(ht.get(new Get(ROWS[0]).addColumn(FAMILIES[2], QUALIFIERS[2])), ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
            this.assertSingleResult(ht.get(new Get(ROWS[0]).addColumn(FAMILIES[6], QUALIFIERS[9])), ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
            this.assertSingleResult(this.getSingleScanResult(ht, new Scan().addColumn(FAMILIES[6], QUALIFIERS[6])), ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
            this.assertSingleResult(this.getSingleScanResult(ht, new Scan().addColumn(FAMILIES[6], QUALIFIERS[9])), ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNullTableName() throws IOException {
        TEST_UTIL.createTable(null, FAMILY);
        Assert.fail((String)"Creating a table with null name passed, should have failed");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullFamilyName() throws IOException {
        TableName tableName = this.name.getTableName();
        TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{null});
        Assert.fail((String)"Creating a table with a null family passed, should fail");
    }

    @Test
    public void testNullRowAndQualifier() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            Put put2;
            try {
                put2 = new Put((byte[])null);
                put2.addColumn(FAMILY, QUALIFIER, VALUE);
                ht.put(put2);
                Assert.fail((String)"Inserting a null row worked, should throw exception");
            }
            catch (Exception put2) {
                // empty catch block
            }
            put2 = new Put(ROW);
            put2.addColumn(FAMILY, null, VALUE);
            ht.put(put2);
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            Delete delete = new Delete(ROW);
            delete.addColumns(FAMILY, null);
            ht.delete(delete);
            Get get = new Get(ROW);
            Result result = ht.get(get);
            this.assertEmptyResult(result);
        }
    }

    @Test
    public void testNullEmptyQualifier() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            try {
                Put put = new Put(ROW);
                put.addColumn(FAMILY, HConstants.EMPTY_BYTE_ARRAY, VALUE);
                ht.put(put);
                this.getTestNull(ht, ROW, FAMILY, VALUE);
                this.scanTestNull(ht, ROW, FAMILY, VALUE);
                TEST_UTIL.flush();
                this.getTestNull(ht, ROW, FAMILY, VALUE);
                this.scanTestNull(ht, ROW, FAMILY, VALUE);
                Delete delete = new Delete(ROW);
                delete.addColumns(FAMILY, HConstants.EMPTY_BYTE_ARRAY);
                ht.delete(delete);
                Get get = new Get(ROW);
                Result result = ht.get(get);
                this.assertEmptyResult(result);
            }
            catch (Exception e) {
                throw new IOException("Using a row with null qualifier should not throw exception");
            }
        }
    }

    @Test
    public void testNullValue() throws IOException {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            try {
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, null);
                ht.put(put);
                Get get = new Get(ROW);
                get.addColumn(FAMILY, QUALIFIER);
                Result result = ht.get(get);
                this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
                Scan scan = new Scan();
                scan.addColumn(FAMILY, QUALIFIER);
                result = this.getSingleScanResult(ht, scan);
                this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
                Delete delete = new Delete(ROW);
                delete.addColumns(FAMILY, QUALIFIER);
                ht.delete(delete);
                get = new Get(ROW);
                result = ht.get(get);
                this.assertEmptyResult(result);
            }
            catch (Exception e) {
                throw new IOException("Null values should be allowed, but threw exception");
            }
        }
    }

    @Test
    public void testNullQualifier() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, null, VALUE);
            table.put(put);
            this.getTestNull(table, ROW, FAMILY, VALUE);
            this.scanTestNull(table, ROW, FAMILY, VALUE);
            Delete delete = new Delete(ROW);
            delete.addColumns(FAMILY, null);
            table.delete(delete);
            Get get = new Get(ROW);
            Result result = table.get(get);
            this.assertEmptyResult(result);
            Increment increment = new Increment(ROW);
            increment.addColumn(FAMILY, null, 1L);
            table.increment(increment);
            this.getTestNull(table, ROW, FAMILY, 1L);
            table.incrementColumnValue(ROW, FAMILY, null, 1L);
            this.getTestNull(table, ROW, FAMILY, 2L);
            delete = new Delete(ROW);
            delete.addColumns(FAMILY, null);
            table.delete(delete);
            Append append = new Append(ROW);
            append.addColumn(FAMILY, null, VALUE);
            table.append(append);
            this.getTestNull(table, ROW, FAMILY, VALUE);
            put = new Put(ROW);
            put.addColumn(FAMILY, null, Bytes.toBytes((String)"checkAndPut"));
            table.put(put);
            table.checkAndMutate(ROW, FAMILY).ifEquals(VALUE).thenPut(put);
            RowMutations mutate = new RowMutations(ROW);
            mutate.add((Mutation)new Put(ROW).addColumn(FAMILY, null, Bytes.toBytes((String)"checkAndMutate")));
            table.checkAndMutate(ROW, FAMILY).ifEquals(Bytes.toBytes((String)"checkAndPut")).thenMutate(mutate);
            delete = new Delete(ROW);
            delete.addColumns(FAMILY, null);
            table.checkAndMutate(ROW, FAMILY).ifEquals(Bytes.toBytes((String)"checkAndMutate")).thenDelete(delete);
        }
    }

    @Test
    public void testVersions() throws Exception {
        TableName tableName = this.name.getTableName();
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            ht.put(put);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(2);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
            Scan scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.readVersions(2);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
            TEST_UTIL.flush();
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(2);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
            scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.readVersions(2);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
            ht.put(put);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readAllVersions();
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
            scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.readAllVersions();
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
            get = new Get(ROW);
            get.readAllVersions();
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
            scan = new Scan().withStartRow(ROW);
            scan.readAllVersions();
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
            TEST_UTIL.flush();
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
            ht.put(put);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
            scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
            Delete delete = new Delete(ROW);
            delete.addColumn(FAMILY, QUALIFIER, STAMPS[11]);
            delete.addColumn(FAMILY, QUALIFIER, STAMPS[7]);
            ht.delete(delete);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
            scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        }
    }

    @Test
    public void testVersionLimits() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        int[] LIMITS = new int[]{1, 3, 5};
        long[] STAMPS = this.makeStamps(10);
        byte[][] VALUES = this.makeNAscii(VALUE, 10);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILIES, LIMITS);){
            Put put = new Put(ROW);
            put.addColumn(FAMILIES[0], QUALIFIER, STAMPS[0], VALUES[0]);
            put.addColumn(FAMILIES[0], QUALIFIER, STAMPS[1], VALUES[1]);
            put.addColumn(FAMILIES[1], QUALIFIER, STAMPS[0], VALUES[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, STAMPS[1], VALUES[1]);
            put.addColumn(FAMILIES[1], QUALIFIER, STAMPS[2], VALUES[2]);
            put.addColumn(FAMILIES[1], QUALIFIER, STAMPS[3], VALUES[3]);
            put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[0], VALUES[0]);
            put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[1], VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[2], VALUES[2]);
            put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[3], VALUES[3]);
            put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[4], VALUES[4]);
            put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[5], VALUES[5]);
            put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[6], VALUES[6]);
            ht.put(put);
            Get get = new Get(ROW);
            get.addColumn(FAMILIES[0], QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
            get = new Get(ROW);
            get.addFamily(FAMILIES[0]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
            Scan scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILIES[0], QUALIFIER);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
            scan = new Scan().withStartRow(ROW);
            scan.addFamily(FAMILIES[0]);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
            get = new Get(ROW);
            get.addColumn(FAMILIES[1], QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            get = new Get(ROW);
            get.addFamily(FAMILIES[1]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILIES[1], QUALIFIER);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            scan = new Scan().withStartRow(ROW);
            scan.addFamily(FAMILIES[1]);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            get = new Get(ROW);
            get.addColumn(FAMILIES[2], QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
            get = new Get(ROW);
            get.addFamily(FAMILIES[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
            scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILIES[2], QUALIFIER);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
            scan = new Scan().withStartRow(ROW);
            scan.addFamily(FAMILIES[2]);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
            get = new Get(ROW);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((String)("Expected 9 keys but received " + result.size()), (long)9L, (long)result.size());
            get = new Get(ROW);
            get.addFamily(FAMILIES[0]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((String)("Expected 9 keys but received " + result.size()), (long)9L, (long)result.size());
            get = new Get(ROW);
            get.addColumn(FAMILIES[0], QUALIFIER);
            get.addColumn(FAMILIES[1], QUALIFIER);
            get.addColumn(FAMILIES[2], QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((String)("Expected 9 keys but received " + result.size()), (long)9L, (long)result.size());
            scan = new Scan().withStartRow(ROW);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((String)("Expected 9 keys but received " + result.size()), (long)9L, (long)result.size());
            scan = new Scan().withStartRow(ROW);
            scan.readVersions(Integer.MAX_VALUE);
            scan.addFamily(FAMILIES[0]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((String)("Expected 9 keys but received " + result.size()), (long)9L, (long)result.size());
            scan = new Scan().withStartRow(ROW);
            scan.readVersions(Integer.MAX_VALUE);
            scan.addColumn(FAMILIES[0], QUALIFIER);
            scan.addColumn(FAMILIES[1], QUALIFIER);
            scan.addColumn(FAMILIES[2], QUALIFIER);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((String)("Expected 9 keys but received " + result.size()), (long)9L, (long)result.size());
        }
    }

    @Test
    public void testDeleteFamilyVersion() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            TableName tableName = this.name.getTableName();
            byte[][] QUALIFIERS = this.makeNAscii(QUALIFIER, 1);
            byte[][] VALUES = this.makeN(VALUE, 5);
            long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
            try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 5);){
                Put put = new Put(ROW);
                for (int q = 0; q < 1; ++q) {
                    for (int t = 0; t < 5; ++t) {
                        put.addColumn(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
                    }
                }
                ht.put(put);
                admin.flush(tableName);
                Delete delete = new Delete(ROW);
                delete.addFamilyVersion(FAMILY, ts[1]);
                delete.addFamilyVersion(FAMILY, ts[3]);
                ht.delete(delete);
                admin.flush(tableName);
                for (int i = 0; i < 1; ++i) {
                    Get get = new Get(ROW);
                    get.addColumn(FAMILY, QUALIFIERS[i]);
                    get.readVersions(Integer.MAX_VALUE);
                    Result result = ht.get(get);
                    this.assertNResult(result, ROW, FAMILY, QUALIFIERS[i], new long[]{ts[0], ts[2], ts[4]}, new byte[][]{VALUES[0], VALUES[2], VALUES[4]}, 0, 2);
                }
            }
        }
    }

    @Test
    public void testDeleteFamilyVersionWithOtherDeletes() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] QUALIFIERS = this.makeNAscii(QUALIFIER, 5);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        try (Admin admin = TEST_UTIL.getAdmin();
             Table ht = TEST_UTIL.createTable(tableName, FAMILY, 5);){
            Delete delete = null;
            Put put = new Put(ROW);
            for (int q = 0; q < 5; ++q) {
                for (int t = 0; t < 5; ++t) {
                    put.addColumn(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
                }
            }
            ht.put(put);
            admin.flush(tableName);
            byte[] ROW2 = Bytes.toBytes((String)"myRowForTest");
            put = new Put(ROW2);
            for (int q = 0; q < 5; ++q) {
                for (int t = 0; t < 5; ++t) {
                    put.addColumn(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
                }
            }
            ht.put(put);
            admin.flush(tableName);
            delete = new Delete(ROW);
            delete.addFamily(FAMILY, ts[1]);
            delete.addFamilyVersion(FAMILY, ts[3]);
            delete.addColumns(FAMILY, QUALIFIERS[0], ts[2]);
            delete.addColumns(FAMILY, QUALIFIERS[2], ts[4]);
            delete.addColumn(FAMILY, QUALIFIERS[4], ts[4]);
            ht.delete(delete);
            admin.flush(tableName);
            delete = new Delete(ROW2);
            delete.addFamilyVersion(FAMILY, ts[1]);
            delete.addFamilyVersion(FAMILY, ts[3]);
            ht.delete(delete);
            admin.flush(tableName);
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIERS[0]);
            get.readVersions(Integer.MAX_VALUE);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIERS[0], new long[]{ts[4]}, new byte[][]{VALUES[4]}, 0, 0);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIERS[1]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIERS[1], new long[]{ts[2], ts[4]}, new byte[][]{VALUES[2], VALUES[4]}, 0, 1);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIERS[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((long)0L, (long)result.size());
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIERS[3]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIERS[3], new long[]{ts[2], ts[4]}, new byte[][]{VALUES[2], VALUES[4]}, 0, 1);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIERS[4]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIERS[4], new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
            for (int i = 0; i < 5; ++i) {
                get = new Get(ROW2);
                get.addColumn(FAMILY, QUALIFIERS[i]);
                get.readVersions(Integer.MAX_VALUE);
                result = ht.get(get);
                this.assertNResult(result, ROW2, FAMILY, QUALIFIERS[i], new long[]{ts[0], ts[2], ts[4]}, new byte[][]{VALUES[0], VALUES[2], VALUES[4]}, 0, 2);
            }
        }
    }

    @Test
    public void testDeleteWithFailed() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILIES, 3);){
            Put put = new Put(ROW);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
            ht.put(put);
            Delete delete = new Delete(ROW);
            delete.addFamily(FAMILIES[1], ts[0]);
            ht.delete(delete);
            Get get = new Get(ROW);
            get.addFamily(FAMILIES[0]);
            get.readAllVersions();
            Result result = ht.get(get);
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(FAMILIES[0], QUALIFIER), (byte[])VALUES[0]));
        }
    }

    @Test
    public void testDeletes() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] ROWS = this.makeNAscii(ROW, 6);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILIES, 3);){
            byte[] bytes;
            int i;
            byte[] bytes2;
            int i2;
            Put put = new Put(ROW);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
            ht.put(put);
            Delete delete = new Delete(ROW);
            delete.addFamily(FAMILIES[0], ts[0]);
            ht.delete(delete);
            Get get = new Get(ROW);
            get.addFamily(FAMILIES[0]);
            get.readVersions(Integer.MAX_VALUE);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
            Scan scan = new Scan().withStartRow(ROW);
            scan.addFamily(FAMILIES[0]);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
            put = new Put(ROW);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
            put.addColumn(FAMILIES[0], null, ts[4], VALUES[4]);
            put.addColumn(FAMILIES[0], null, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[0], null, ts[3], VALUES[3]);
            ht.put(put);
            delete = new Delete(ROW);
            delete.addColumn(FAMILIES[0], QUALIFIER);
            ht.delete(delete);
            get = new Get(ROW);
            get.addColumn(FAMILIES[0], QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            scan = new Scan().withStartRow(ROW);
            scan.addColumn(FAMILIES[0], QUALIFIER);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            delete = new Delete(ROW);
            delete.addColumn(FAMILIES[0], null);
            ht.delete(delete);
            delete = new Delete(ROW);
            delete.addColumns(FAMILIES[0], null);
            ht.delete(delete);
            put = new Put(ROW);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
            ht.put(put);
            get = new Get(ROW);
            get.addFamily(FAMILIES[0]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            scan = new Scan().withStartRow(ROW);
            scan.addFamily(FAMILIES[0]);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            put = new Put(ROWS[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            put = new Put(ROWS[1]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            put = new Put(ROWS[2]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            get = new Get(ROWS[2]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((String)("Expected 4 key but received " + result.size() + ": " + result), (long)4L, (long)result.size());
            delete = new Delete(ROWS[0]);
            delete.addFamily(FAMILIES[2]);
            ht.delete(delete);
            delete = new Delete(ROWS[1]);
            delete.addColumns(FAMILIES[1], QUALIFIER);
            ht.delete(delete);
            delete = new Delete(ROWS[2]);
            delete.addColumn(FAMILIES[1], QUALIFIER);
            delete.addColumn(FAMILIES[1], QUALIFIER);
            delete.addColumn(FAMILIES[2], QUALIFIER);
            ht.delete(delete);
            get = new Get(ROWS[0]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
            scan = new Scan().withStartRow(ROWS[0]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
            get = new Get(ROWS[1]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            scan = new Scan().withStartRow(ROWS[1]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            get = new Get(ROWS[2]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
            scan = new Scan().withStartRow(ROWS[2]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.readVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((long)1L, (long)result.size());
            this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
            delete = new Delete(ROWS[3]);
            delete.addFamily(FAMILIES[1]);
            ht.delete(delete);
            put = new Put(ROWS[3]);
            put.addColumn(FAMILIES[2], QUALIFIER, VALUES[0]);
            ht.put(put);
            put = new Put(ROWS[4]);
            put.addColumn(FAMILIES[1], QUALIFIER, VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, VALUES[2]);
            ht.put(put);
            get = new Get(ROWS[3]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((String)("Expected 1 key but received " + result.size()), (long)1L, (long)result.size());
            get = new Get(ROWS[4]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            scan = new Scan().withStartRow(ROWS[3]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.readVersions(Integer.MAX_VALUE);
            ResultScanner scanner = ht.getScanner(scan);
            result = scanner.next();
            Assert.assertEquals((String)("Expected 1 key but received " + result.size()), (long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[3]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[0]));
            result = scanner.next();
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[4]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[1]), (byte[])ROWS[4]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[1]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[1]), (byte[])VALUES[2]));
            scanner.close();
            for (i2 = 0; i2 < 10; ++i2) {
                bytes2 = Bytes.toBytes((int)i2);
                put = new Put(bytes2);
                put.setDurability(Durability.SKIP_WAL);
                put.addColumn(FAMILIES[0], QUALIFIER, bytes2);
                ht.put(put);
            }
            for (i2 = 0; i2 < 10; ++i2) {
                bytes2 = Bytes.toBytes((int)i2);
                get = new Get(bytes2);
                get.addFamily(FAMILIES[0]);
                result = ht.get(get);
                Assert.assertEquals((long)1L, (long)result.size());
            }
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (i = 0; i < 10; ++i) {
                bytes = Bytes.toBytes((int)i);
                delete = new Delete(bytes);
                delete.addFamily(FAMILIES[0]);
                deletes.add(delete);
            }
            ht.delete(deletes);
            for (i = 0; i < 10; ++i) {
                bytes = Bytes.toBytes((int)i);
                get = new Get(bytes);
                get.addFamily(FAMILIES[0]);
                result = ht.get(get);
                Assert.assertTrue((boolean)result.isEmpty());
            }
        }
    }
}

