/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.function.ThrowingRunnable;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMetaCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaCache.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test_table");
    private static final byte[] FAMILY = Bytes.toBytes((String)"fam1");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qual");
    private static HRegionServer badRS;
    private Connection conn;
    private MetricsConnection metrics;
    private AsyncRegionLocator locator;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.regionserver.impl", new String[]{RegionServerWithFakeRpcServices.class.getName()});
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        badRS = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        Assert.assertTrue((boolean)(badRS.getRSRpcServices() instanceof FakeRSRpcServices));
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(2).build()).build();
        TEST_UTIL.createTable(desc, (byte[][])null);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    private void setupConnection(int retry) throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.retries.number", retry);
        conf.setBoolean("hbase.client.metrics.enable", true);
        this.conn = ConnectionFactory.createConnection((Configuration)conf);
        AsyncConnectionImpl asyncConn = (AsyncConnectionImpl)this.conn.toAsyncConnection();
        this.locator = asyncConn.getLocator();
        this.metrics = (MetricsConnection)asyncConn.getConnectionMetrics().get();
    }

    @Test
    public void testAddToCacheReverse() throws IOException, InterruptedException {
        int i;
        this.setupConnection(1);
        TableName tableName = TableName.valueOf((String)"testAddToCache");
        byte[] family = Bytes.toBytes((String)"CF");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        int maxSplits = 10;
        List splits = IntStream.range(1, maxSplits).mapToObj(Bytes::toBytes).collect(Collectors.toList());
        TEST_UTIL.getAdmin().createTable(td, (byte[][])splits.toArray((T[])new byte[0][]));
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        Assert.assertEquals((long)(splits.size() + 1), (long)TEST_UTIL.getAdmin().getRegions(tableName).size());
        RegionLocator locatorForTable = this.conn.getRegionLocator(tableName);
        for (i = maxSplits; i >= 0; --i) {
            locatorForTable.getRegionLocation(Bytes.toBytes((int)i));
        }
        for (i = 0; i < maxSplits; ++i) {
            Assert.assertNotNull((Object)this.locator.getRegionLocationInCache(tableName, Bytes.toBytes((int)i)));
        }
    }

    @Test
    public void testMergeEmptyWithMetaCache() throws Throwable {
        TableName tableName = TableName.valueOf((String)"testMergeEmptyWithMetaCache");
        byte[] family = Bytes.toBytes((String)"CF");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        TEST_UTIL.getAdmin().createTable(td, (byte[][])new byte[][]{Bytes.toBytes((int)2), Bytes.toBytes((int)5)});
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        RegionInfo regionA = null;
        RegionInfo regionB = null;
        RegionInfo regionC = null;
        for (RegionInfo region : TEST_UTIL.getAdmin().getRegions(tableName)) {
            if (region.getStartKey().length == 0) {
                regionA = region;
                continue;
            }
            if (Bytes.equals((byte[])region.getStartKey(), (byte[])Bytes.toBytes((int)2))) {
                regionB = region;
                continue;
            }
            if (!Bytes.equals((byte[])region.getStartKey(), (byte[])Bytes.toBytes((int)5))) continue;
            regionC = region;
        }
        Assert.assertNotNull(regionA);
        Assert.assertNotNull(regionB);
        Assert.assertNotNull(regionC);
        TEST_UTIL.getConfiguration().setBoolean("hbase.client.metrics.enable", true);
        try (AsyncConnection asyncConn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();){
            AsyncConnectionImpl asyncConnImpl = (AsyncConnectionImpl)asyncConn;
            MetricsConnection asyncMetrics = (MetricsConnection)asyncConnImpl.getConnectionMetrics().get();
            asyncConn.getRegionLocator(tableName).getAllRegionLocations().get();
            Assert.assertEquals((long)3L, (long)TEST_UTIL.getAdmin().getRegions(tableName).size());
            TEST_UTIL.getAdmin().mergeRegionsAsync((byte[][])new byte[][]{regionA.getRegionName(), regionB.getRegionName(), regionC.getRegionName()}, false).get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getAdmin().getRegions(tableName).size());
            AsyncTable asyncTable = asyncConn.getTable(tableName);
            Assert.assertTrue((this.executeAndGetNewMisses(() -> {
                Result cfr_ignored_0 = (Result)asyncTable.get(new Get(Bytes.toBytes((int)6))).get();
            }, asyncMetrics) > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)this.executeAndGetNewMisses(() -> {
                Result cfr_ignored_0 = (Result)asyncTable.get(new Get(Bytes.toBytes((int)6))).get();
            }, asyncMetrics));
        }
    }

    private long executeAndGetNewMisses(ThrowingRunnable runnable, MetricsConnection metrics) throws Throwable {
        long lastVal = metrics.getMetaCacheMisses();
        runnable.run();
        long curVal = metrics.getMetaCacheMisses();
        return curVal - lastVal;
    }

    @Test
    public void testPreserveMetaCacheOnException() throws Exception {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new RoundRobinExceptionInjector());
        this.setupConnection(1);
        try (Table table = this.conn.getTable(TABLE_NAME);){
            byte[] row = Bytes.toBytes((String)"row1");
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
            Get get = new Get(row);
            Append append = new Append(row);
            append.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)11));
            Increment increment = new Increment(row);
            increment.addColumn(FAMILY, QUALIFIER, 10L);
            Delete delete = new Delete(row);
            delete.addColumn(FAMILY, QUALIFIER);
            RowMutations mutations = new RowMutations(row);
            mutations.add((Mutation)put);
            mutations.add((Mutation)delete);
            for (int i = 0; i < 50; ++i) {
                boolean success;
                IOException exp;
                block16: {
                    exp = null;
                    success = false;
                    try {
                        table.put(put);
                        success = true;
                        table.get(get);
                        table.append(append);
                        table.increment(increment);
                        table.delete(delete);
                        table.mutateRow(mutations);
                    }
                    catch (IOException ex) {
                        if (!ClientExceptionsUtil.isMetaClearingException((Throwable)ex) && !success) break block16;
                        exp = ex;
                    }
                }
                if (exp != null && ClientExceptionsUtil.isMetaClearingException((Throwable)exp)) {
                    Assert.assertNull((Object)this.locator.getRegionLocationInCache(TABLE_NAME, row));
                    continue;
                }
                if (!success) continue;
                Assert.assertNotNull((Object)this.locator.getRegionLocationInCache(TABLE_NAME, row));
            }
        }
    }

    @Test
    public void testCacheClearingOnCallQueueTooBig() throws Exception {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new CallQueueTooBigExceptionInjector());
        this.setupConnection(2);
        Table table = this.conn.getTable(TABLE_NAME);
        byte[] row = Bytes.toBytes((String)"row1");
        Put put = new Put(row);
        put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
        table.put(put);
        long preGetRegionClears = this.metrics.getMetaCacheNumClearRegion().getCount();
        long preGetServerClears = this.metrics.getMetaCacheNumClearServer().getCount();
        Get get = new Get(row);
        try {
            table.get(get);
            Assert.fail((String)"Expected CallQueueTooBigException");
        }
        catch (RetriesExhaustedException retriesExhaustedException) {
            // empty catch block
        }
        long postGetRegionClears = this.metrics.getMetaCacheNumClearRegion().getCount();
        long postGetServerClears = this.metrics.getMetaCacheNumClearServer().getCount();
        Assert.assertEquals((long)preGetRegionClears, (long)postGetRegionClears);
        Assert.assertEquals((long)preGetServerClears, (long)postGetServerClears);
    }

    public static List<Throwable> metaCachePreservingExceptions() {
        return Arrays.asList(new Throwable[]{new RegionOpeningException(" "), new RegionTooBusyException("Some old message"), new RpcThrottlingException(" "), new MultiActionResultTooLarge(" "), new RetryImmediatelyException(" "), new CallQueueTooBigException()});
    }

    public static class CallQueueTooBigExceptionInjector
    extends ExceptionInjector {
        @Override
        public void throwOnGet(FakeRSRpcServices rpcServices, ClientProtos.GetRequest request) throws ServiceException {
            if (this.isTestTable(rpcServices, request.getRegion())) {
                throw new ServiceException((Throwable)new CallQueueTooBigException());
            }
        }

        @Override
        public void throwOnMutate(FakeRSRpcServices rpcServices, ClientProtos.MutateRequest request) throws ServiceException {
        }

        @Override
        public void throwOnScan(FakeRSRpcServices rpcServices, ClientProtos.ScanRequest request) throws ServiceException {
        }
    }

    public static class RoundRobinExceptionInjector
    extends ExceptionInjector {
        private int numReqs = -1;
        private int expCount = -1;
        private List<Throwable> metaCachePreservingExceptions = TestMetaCache.metaCachePreservingExceptions();

        @Override
        public void throwOnGet(FakeRSRpcServices rpcServices, ClientProtos.GetRequest request) throws ServiceException {
            this.throwSomeExceptions(rpcServices, request.getRegion());
        }

        @Override
        public void throwOnMutate(FakeRSRpcServices rpcServices, ClientProtos.MutateRequest request) throws ServiceException {
            this.throwSomeExceptions(rpcServices, request.getRegion());
        }

        @Override
        public void throwOnScan(FakeRSRpcServices rpcServices, ClientProtos.ScanRequest request) throws ServiceException {
            if (!request.hasScannerId()) {
                this.throwSomeExceptions(rpcServices, request.getRegion());
            }
        }

        private void throwSomeExceptions(FakeRSRpcServices rpcServices, HBaseProtos.RegionSpecifier regionSpec) throws ServiceException {
            if (!this.isTestTable(rpcServices, regionSpec)) {
                return;
            }
            ++this.numReqs;
            if (this.numReqs % 5 == 0) {
                return;
            }
            if (this.numReqs % 5 == 1 || this.numReqs % 5 == 2) {
                throw new ServiceException((Throwable)new NotServingRegionException());
            }
            ++this.expCount;
            Throwable t = this.metaCachePreservingExceptions.get(this.expCount % this.metaCachePreservingExceptions.size());
            throw new ServiceException(t);
        }
    }

    public static abstract class ExceptionInjector {
        protected boolean isTestTable(FakeRSRpcServices rpcServices, HBaseProtos.RegionSpecifier regionSpec) throws ServiceException {
            try {
                return TABLE_NAME.equals((Object)rpcServices.getRegion(regionSpec).getTableDescriptor().getTableName());
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
        }

        public abstract void throwOnGet(FakeRSRpcServices var1, ClientProtos.GetRequest var2) throws ServiceException;

        public abstract void throwOnMutate(FakeRSRpcServices var1, ClientProtos.MutateRequest var2) throws ServiceException;

        public abstract void throwOnScan(FakeRSRpcServices var1, ClientProtos.ScanRequest var2) throws ServiceException;
    }

    public static class FakeRSRpcServices
    extends RSRpcServices {
        private ExceptionInjector exceptions = new RoundRobinExceptionInjector();

        public FakeRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public void setExceptionInjector(ExceptionInjector injector) {
            this.exceptions = injector;
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            this.exceptions.throwOnGet(this, request);
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
            this.exceptions.throwOnMutate(this, request);
            return super.mutate(controller, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            this.exceptions.throwOnScan(this, request);
            return super.scan(controller, request);
        }
    }

    public static class RegionServerWithFakeRpcServices
    extends HRegionServer {
        private FakeRSRpcServices rsRpcServices;

        public RegionServerWithFakeRpcServices(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            this.rsRpcServices = new FakeRSRpcServices(this);
            return this.rsRpcServices;
        }

        public void setExceptionInjector(ExceptionInjector injector) {
            this.rsRpcServices.setExceptionInjector(injector);
        }
    }
}

