/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MetaWithReplicasTestBase;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaWithReplicasShutdownHandling
extends MetaWithReplicasTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaWithReplicasShutdownHandling.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaWithReplicasShutdownHandling.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestMetaWithReplicasShutdownHandling.startCluster();
    }

    @Test
    public void testShutdownHandling() throws Exception {
        TestMetaWithReplicasShutdownHandling.shutdownMetaAndDoValidations(TEST_UTIL);
    }

    public static void shutdownMetaAndDoValidations(HBaseTestingUtil util) throws Exception {
        Throwable throwable;
        Table htable;
        ZKWatcher zkw = util.getZooKeeperWatcher();
        Configuration conf = util.getConfiguration();
        conf.setBoolean("hbase.meta.replicas.use", true);
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String[])new String[]{conf.get("zookeeper.znode.metaserver", "meta-region-server")});
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ServerName primary = ProtobufUtil.toServerName((byte[])data);
        LOG.info("Primary=" + primary.toString());
        TableName TABLE = TableName.valueOf((String)"testShutdownHandling");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        if (util.getAdmin().tableExists(TABLE)) {
            util.getAdmin().disableTable(TABLE);
            util.getAdmin().deleteTable(TABLE);
        }
        byte[] row = Bytes.toBytes((String)"test");
        ServerName master = null;
        try (Connection c = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
            htable = util.createTable(TABLE, (byte[][])FAMILIES);
            throwable = null;
            try {
                util.getAdmin().flush(TableName.META_TABLE_NAME);
                Thread.sleep(conf.getInt("hbase.regionserver.storefile.refresh.period", 30000) * 6);
                List regions = MetaTableAccessor.getTableRegions((Connection)c, (TableName)TABLE);
                HRegionLocation hrl = MetaTableAccessor.getRegionLocation((Connection)c, (RegionInfo)((RegionInfo)regions.get(0)));
                if (hrl.getServerName().equals((Object)primary)) {
                    util.getAdmin().move(hrl.getRegion().getEncodedNameAsBytes());
                    do {
                        Thread.sleep(10L);
                    } while (primary.equals((Object)(hrl = MetaTableAccessor.getRegionLocation((Connection)c, (RegionInfo)((RegionInfo)regions.get(0)))).getServerName()));
                    util.getAdmin().flush(TableName.META_TABLE_NAME);
                    Thread.sleep(conf.getInt("hbase.regionserver.storefile.refresh.period", 30000) * 3);
                }
                master = util.getHBaseClusterInterface().getClusterMetrics().getMasterName();
                LOG.info("Stopping master=" + master.toString());
                util.getHBaseClusterInterface().stopMaster(master);
                util.getHBaseClusterInterface().waitForMasterToStop(master, 60000L);
                LOG.info("Master " + master + " stopped!");
                if (!master.equals((Object)primary)) {
                    util.getHBaseClusterInterface().killRegionServer(primary);
                    util.getHBaseClusterInterface().waitForRegionServerToStop(primary, 60000L);
                }
                c.clearRegionLocationCache();
            }
            catch (Throwable regions) {
                throwable = regions;
                throw regions;
            }
            finally {
                if (htable != null) {
                    if (throwable != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable regions) {
                            throwable.addSuppressed(regions);
                        }
                    } else {
                        htable.close();
                    }
                }
            }
            LOG.info("Running GETs");
            htable = c.getTable(TABLE);
            throwable = null;
            try {
                Put put = new Put(row);
                put.addColumn(Bytes.toBytes((String)"foo"), row, row);
                BufferedMutator m = c.getBufferedMutator(TABLE);
                m.mutate((Mutation)put);
                m.flush();
                Result r = htable.get(new Get(row));
                Assert.assertTrue((boolean)Arrays.equals(r.getRow(), row));
                LOG.info("Starting Master");
                util.getHBaseClusterInterface().startMaster(master.getHostname(), 0);
                util.getHBaseClusterInterface().startRegionServer(primary.getHostname(), 0);
                util.getHBaseClusterInterface().waitForActiveAndReadyMaster();
                LOG.info("Master active!");
                c.clearRegionLocationCache();
            }
            catch (Throwable put) {
                throwable = put;
                throw put;
            }
            finally {
                if (htable != null) {
                    if (throwable != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable put) {
                            throwable.addSuppressed(put);
                        }
                    } else {
                        htable.close();
                    }
                }
            }
        }
        conf.setBoolean("hbase.meta.replicas.use", false);
        LOG.info("Running GETs no replicas");
        c = ConnectionFactory.createConnection((Configuration)conf);
        var12_12 = null;
        try {
            htable = c.getTable(TABLE);
            throwable = null;
            try {
                Result r = htable.get(new Get(row));
                Assert.assertArrayEquals((byte[])row, (byte[])r.getRow());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (htable != null) {
                    if (throwable != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        htable.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var12_12 = throwable4;
            throw throwable4;
        }
        finally {
            if (c != null) {
                if (var12_12 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable5) {
                        var12_12.addSuppressed(throwable5);
                    }
                } else {
                    c.close();
                }
            }
        }
    }
}

