/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestSizeFailures {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSizeFailures.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSizeFailures.class);
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    protected static int SLAVES = 1;
    private static TableName TABLENAME;
    private static final int NUM_ROWS = 1000000;
    private static final int NUM_COLS = 9;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
        TABLENAME = TableName.valueOf((String)"testSizeFailures");
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        for (int i = 1; i <= 10; ++i) {
            qualifiers.add(Bytes.toBytes((String)Integer.toString(i)));
        }
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        byte[][] splits = new byte[9][2];
        for (int i = 1; i < 10; ++i) {
            int split = 48 + i;
            splits[i - 1][0] = (byte)(split >>> 8);
            splits[i - 1][0] = (byte)split;
        }
        TEST_UTIL.getAdmin().createTable(tableDescriptor, splits);
        Connection conn = TEST_UTIL.getConnection();
        try (Table table = conn.getTable(TABLENAME);){
            LinkedList<Put> puts = new LinkedList<Put>();
            for (int i = 0; i < 1000000; ++i) {
                Put p = new Put(Bytes.toBytes((String)Integer.toString(i)));
                for (int j = 0; j < 9; ++j) {
                    byte[] value = new byte[50];
                    Bytes.random((byte[])value);
                    p.addColumn(FAMILY, Bytes.toBytes((String)Integer.toString(j)), value);
                }
                puts.add(p);
                if (puts.size() != 1000) continue;
                table.batch(puts, null);
                puts.clear();
            }
            if (puts.size() > 0) {
                table.batch(puts, null);
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testScannerSeesAllRecords() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        try (Table table = conn.getTable(TABLENAME);){
            Scan s = new Scan();
            s.addFamily(FAMILY);
            s.setMaxResultSize(-1L);
            s.setBatch(-1);
            s.setCaching(500);
            Map.Entry<Long, Long> entry = this.sumTable(table.getScanner(s));
            long rowsObserved = entry.getKey();
            long entriesObserved = entry.getValue();
            Assert.assertEquals((long)1000000L, (long)rowsObserved);
            Assert.assertEquals((long)9000000L, (long)entriesObserved);
        }
    }

    @Test
    public void testSmallScannerSeesAllRecords() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        try (Table table = conn.getTable(TABLENAME);){
            Scan s = new Scan();
            s.setReadType(Scan.ReadType.PREAD);
            s.addFamily(FAMILY);
            s.setMaxResultSize(-1L);
            s.setBatch(-1);
            s.setCaching(500);
            Map.Entry<Long, Long> entry = this.sumTable(table.getScanner(s));
            long rowsObserved = entry.getKey();
            long entriesObserved = entry.getValue();
            Assert.assertEquals((long)1000000L, (long)rowsObserved);
            Assert.assertEquals((long)9000000L, (long)entriesObserved);
        }
    }

    private Map.Entry<Long, Long> sumTable(ResultScanner scanner) {
        long rowsObserved = 0L;
        long entriesObserved = 0L;
        for (Result result : scanner) {
            ++rowsObserved;
            while (result.advance()) {
                ++entriesObserved;
            }
        }
        return Maps.immutableEntry((Object)rowsObserved, (Object)entriesObserved);
    }
}

