/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestSnapshotTemporaryDirectory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotTemporaryDirectory.class);
    @Parameterized.Parameter
    public int manifestVersion;
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotTemporaryDirectory.class);
    protected static final int NUM_RS = 2;
    protected static String TEMP_DIR = Paths.get("", new String[0]).toAbsolutePath().toString() + "/" + UUID.randomUUID().toString();
    protected static Admin admin;
    protected static final HBaseTestingUtil UTIL;
    protected static final String STRING_TABLE_NAME = "test";
    protected static final byte[] TEST_FAM;
    protected static final TableName TABLE_NAME;

    @Parameterized.Parameters
    public static Iterable<Integer> data() {
        return Arrays.asList(0, 2);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotTemporaryDirectory.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
        admin = UTIL.getAdmin();
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.set("hbase.snapshot.working.dir", "file://" + new Path(TEMP_DIR, ".tmpDir").toUri());
    }

    @Before
    public void setup() throws Exception {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setRegionReplication(this.getNumReplicas()).build();
        UTIL.createTable(htd, (byte[][])new byte[][]{TEST_FAM}, UTIL.getConfiguration());
    }

    protected int getNumReplicas() {
        return 1;
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() {
        try {
            UTIL.shutdownMiniCluster();
            FileUtils.deleteDirectory((File)new File(TEMP_DIR));
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testRestoreDisabledSnapshot() throws IOException, InterruptedException {
        int snapshot1Rows;
        int snapshot0Rows;
        long tid = EnvironmentEdgeManager.currentTime();
        TableName tableName = TableName.valueOf((String)("testtb-" + tid));
        String emptySnapshot = "emptySnaptb-" + tid;
        String snapshotName0 = "snaptb0-" + tid;
        String snapshotName1 = "snaptb1-" + tid;
        SnapshotTestingUtils.createTable(UTIL, tableName, this.getNumReplicas(), (byte[][])new byte[][]{TEST_FAM});
        admin.disableTable(tableName);
        this.takeSnapshot(tableName, emptySnapshot, true);
        admin.enableTable(tableName);
        SnapshotTestingUtils.loadData(UTIL, tableName, 500, (byte[][])new byte[][]{TEST_FAM});
        try (Table table = UTIL.getConnection().getTable(tableName);){
            snapshot0Rows = HBaseTestingUtil.countRows(table);
        }
        admin.disableTable(tableName);
        this.takeSnapshot(tableName, snapshotName0, true);
        admin.enableTable(tableName);
        SnapshotTestingUtils.loadData(UTIL, tableName, 500, (byte[][])new byte[][]{TEST_FAM});
        table = UTIL.getConnection().getTable(tableName);
        var10_7 = null;
        try {
            snapshot1Rows = HBaseTestingUtil.countRows(table);
        }
        catch (Throwable throwable) {
            var10_7 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var10_7 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var10_7.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, snapshot1Rows);
        admin.disableTable(tableName);
        this.takeSnapshot(tableName, snapshotName1, true);
        admin.restoreSnapshot(snapshotName0);
        admin.enableTable(tableName);
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, admin, this.getNumReplicas());
        admin.disableTable(tableName);
        admin.restoreSnapshot(emptySnapshot);
        admin.enableTable(tableName);
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, 0L);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, admin, this.getNumReplicas());
        admin.disableTable(tableName);
        admin.restoreSnapshot(snapshotName1);
        admin.enableTable(tableName);
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, admin, this.getNumReplicas());
        UTIL.deleteTable(tableName);
        admin.restoreSnapshot(snapshotName1);
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, admin, this.getNumReplicas());
    }

    @Test
    public void testRestoreEnabledSnapshot() throws IOException, InterruptedException {
        int snapshot1Rows;
        int snapshot0Rows;
        long tid = EnvironmentEdgeManager.currentTime();
        TableName tableName = TableName.valueOf((String)("testtb-" + tid));
        String emptySnapshot = "emptySnaptb-" + tid;
        String snapshotName0 = "snaptb0-" + tid;
        String snapshotName1 = "snaptb1-" + tid;
        SnapshotTestingUtils.createTable(UTIL, tableName, this.getNumReplicas(), (byte[][])new byte[][]{TEST_FAM});
        this.takeSnapshot(tableName, emptySnapshot, false);
        SnapshotTestingUtils.loadData(UTIL, tableName, 500, (byte[][])new byte[][]{TEST_FAM});
        try (Table table = UTIL.getConnection().getTable(tableName);){
            snapshot0Rows = HBaseTestingUtil.countRows(table);
        }
        this.takeSnapshot(tableName, snapshotName0, false);
        SnapshotTestingUtils.loadData(UTIL, tableName, 500, (byte[][])new byte[][]{TEST_FAM});
        table = UTIL.getConnection().getTable(tableName);
        var10_7 = null;
        try {
            snapshot1Rows = HBaseTestingUtil.countRows(table);
        }
        catch (Throwable throwable) {
            var10_7 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var10_7 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var10_7.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, snapshot1Rows);
        this.takeSnapshot(tableName, snapshotName1, false);
        admin.disableTable(tableName);
        admin.restoreSnapshot(snapshotName0);
        admin.enableTable(tableName);
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, admin, this.getNumReplicas());
        admin.disableTable(tableName);
        admin.restoreSnapshot(emptySnapshot);
        admin.enableTable(tableName);
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, 0L);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, admin, this.getNumReplicas());
        admin.disableTable(tableName);
        admin.restoreSnapshot(snapshotName1);
        admin.enableTable(tableName);
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, admin, this.getNumReplicas());
        UTIL.deleteTable(tableName);
        admin.restoreSnapshot(snapshotName1);
        SnapshotTestingUtils.verifyRowCount(UTIL, tableName, snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, admin, this.getNumReplicas());
    }

    @Test
    public void testOfflineTableSnapshot() throws Exception {
        Admin admin = UTIL.getAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        Table table = UTIL.getConnection().getTable(TABLE_NAME);
        UTIL.loadTable(table, TEST_FAM, false);
        LOG.debug("FS state before disable:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        admin.disableTable(TABLE_NAME);
        LOG.debug("FS state before snapshot:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        String SNAPSHOT_NAME = "offlineTableSnapshot";
        String snapshot = "offlineTableSnapshot";
        this.takeSnapshot(TABLE_NAME, "offlineTableSnapshot", true);
        LOG.debug("Snapshot completed.");
        List<SnapshotDescription> snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot, TABLE_NAME);
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        LOG.debug("FS state after snapshot:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        SnapshotTestingUtils.confirmSnapshotValid(ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshots.get(0)), TABLE_NAME, TEST_FAM, rootDir, admin, fs);
        admin.deleteSnapshot(snapshot);
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    @Test
    public void testSnapshotCloneContents() throws Exception {
        SnapshotTestingUtils.assertNoSnapshots(admin);
        Table table = UTIL.getConnection().getTable(TABLE_NAME);
        UTIL.loadTable(table, TEST_FAM);
        table.close();
        String snapshot1 = "TableSnapshot1";
        this.takeSnapshot(TABLE_NAME, snapshot1, false);
        LOG.debug("Snapshot1 completed.");
        TableName clone = TableName.valueOf((String)"Table1Clone");
        admin.cloneSnapshot(snapshot1, clone, false);
        Scan original = new Scan();
        Scan cloned = new Scan();
        ResultScanner originalScan = admin.getConnection().getTable(TABLE_NAME).getScanner(original);
        ResultScanner clonedScan = admin.getConnection().getTable(TableName.valueOf((String)"Table1Clone")).getScanner(cloned);
        Iterator i = originalScan.iterator();
        Iterator i2 = clonedScan.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        while (i.hasNext()) {
            Assert.assertTrue((boolean)i2.hasNext());
            Assert.assertEquals((Object)Bytes.toString((byte[])((Result)i.next()).getValue(TEST_FAM, new byte[0])), (Object)Bytes.toString((byte[])((Result)i2.next()).getValue(TEST_FAM, new byte[0])));
        }
        Assert.assertFalse((boolean)i2.hasNext());
        admin.deleteSnapshot(snapshot1);
        UTIL.deleteTable(clone);
        admin.close();
    }

    @Test
    public void testOfflineTableSnapshotWithEmptyRegion() throws Exception {
        SnapshotTestingUtils.assertNoSnapshots(admin);
        LOG.debug("FS state before disable:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        admin.disableTable(TABLE_NAME);
        LOG.debug("FS state before snapshot:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        String snapshot = "testOfflineTableSnapshotWithEmptyRegion";
        this.takeSnapshot(TABLE_NAME, snapshot, true);
        LOG.debug("Snapshot completed.");
        List<SnapshotDescription> snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot, TABLE_NAME);
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        LOG.debug("FS state after snapshot:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        ArrayList emptyCfs = Lists.newArrayList((Object[])new byte[][]{TEST_FAM});
        ArrayList nonEmptyCfs = Lists.newArrayList();
        SnapshotTestingUtils.confirmSnapshotValid(ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshots.get(0)), TABLE_NAME, nonEmptyCfs, emptyCfs, rootDir, admin, fs);
        admin.deleteSnapshot(snapshot);
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnsureTemporaryDirectoryTransfer() throws Exception {
        Admin admin = UTIL.getAdmin();
        TableName tableName2 = TableName.valueOf((String)"testListTableSnapshots");
        try {
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName2).build();
            UTIL.createTable(htd, (byte[][])new byte[][]{TEST_FAM}, UTIL.getConfiguration());
            String table1Snapshot1 = "Table1Snapshot1";
            this.takeSnapshot(TABLE_NAME, table1Snapshot1, false);
            LOG.debug("Snapshot1 completed.");
            String table1Snapshot2 = "Table1Snapshot2";
            this.takeSnapshot(TABLE_NAME, table1Snapshot2, false);
            LOG.debug("Snapshot2 completed.");
            String table2Snapshot1 = "Table2Snapshot1";
            this.takeSnapshot(TABLE_NAME, table2Snapshot1, false);
            LOG.debug("Table2Snapshot1 completed.");
            List listTableSnapshots = admin.listTableSnapshots(Pattern.compile("test.*"), Pattern.compile(".*"));
            ArrayList<String> listTableSnapshotNames = new ArrayList<String>();
            Assert.assertEquals((long)3L, (long)listTableSnapshots.size());
            for (SnapshotDescription s : listTableSnapshots) {
                listTableSnapshotNames.add(s.getName());
            }
            Assert.assertTrue((boolean)listTableSnapshotNames.contains(table1Snapshot1));
            Assert.assertTrue((boolean)listTableSnapshotNames.contains(table1Snapshot2));
            Assert.assertTrue((boolean)listTableSnapshotNames.contains(table2Snapshot1));
        }
        finally {
            try {
                admin.deleteSnapshots(Pattern.compile("Table.*"));
            }
            catch (SnapshotDoesNotExistException snapshotDoesNotExistException) {}
            if (admin.tableExists(tableName2)) {
                UTIL.deleteTable(tableName2);
            }
            admin.close();
        }
    }

    private void takeSnapshot(TableName tableName, String snapshotName, boolean disabled) throws IOException {
        SnapshotType type = disabled ? SnapshotType.DISABLED : SnapshotType.FLUSH;
        SnapshotDescription desc = new SnapshotDescription(snapshotName, tableName, type, null, -1L, this.manifestVersion, null);
        admin.snapshot(desc);
    }

    static {
        UTIL = new HBaseTestingUtil();
        TEST_FAM = Bytes.toBytes((String)"fam");
        TABLE_NAME = TableName.valueOf((String)STRING_TABLE_NAME);
    }
}

