/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.client.AbstractTestUpdateConfiguration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestUpdateConfiguration
extends AbstractTestUpdateConfiguration {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUpdateConfiguration.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestUpdateConfiguration.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setup() throws Exception {
        TestUpdateConfiguration.setUpConfigurationFiles(TEST_UTIL);
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(2).build();
        TEST_UTIL.startMiniCluster(option);
        TestUpdateConfiguration.addResourceToRegionServerConfiguration(TEST_UTIL);
    }

    @Test
    public void testOnlineConfigChange() throws IOException {
        LOG.debug("Starting the test {}", (Object)this.name.getMethodName());
        Admin admin = TEST_UTIL.getAdmin();
        ServerName server = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        admin.updateConfiguration(server);
    }

    @Test
    public void testMasterOnlineConfigChange() throws IOException {
        LOG.debug("Starting the test {}", (Object)this.name.getMethodName());
        this.replaceHBaseSiteXML();
        Admin admin = TEST_UTIL.getAdmin();
        ServerName server = TEST_UTIL.getHBaseCluster().getMaster().getServerName();
        admin.updateConfiguration(server);
        Configuration conf = TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration();
        int custom = conf.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        this.restoreHBaseSiteXML();
    }

    @Test
    public void testAllOnlineConfigChange() throws IOException {
        LOG.debug("Starting the test {} ", (Object)this.name.getMethodName());
        Admin admin = TEST_UTIL.getAdmin();
        admin.updateConfiguration();
    }

    @Test
    public void testAllCustomOnlineConfigChange() throws IOException {
        LOG.debug("Starting the test {}", (Object)this.name.getMethodName());
        this.replaceHBaseSiteXML();
        Admin admin = TEST_UTIL.getAdmin();
        admin.updateConfiguration();
        Configuration masterConfiguration = TEST_UTIL.getMiniHBaseCluster().getMaster(0).getConfiguration();
        int custom = masterConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        Configuration backupMasterConfiguration = TEST_UTIL.getMiniHBaseCluster().getMaster(1).getConfiguration();
        custom = backupMasterConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        Configuration regionServerConfiguration = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getConfiguration();
        custom = regionServerConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        this.restoreHBaseSiteXML();
    }
}

