/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MockRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, SmallTests.class})
public class TestCoreRegionServerCoprocessor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoreRegionServerCoprocessor.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    private RegionServerServices rss;
    private RegionServerCoprocessorHost rsch;

    @Before
    public void before() throws IOException {
        String methodName = this.name.getMethodName();
        this.rss = new MockRegionServerServices(HTU.getConfiguration());
        this.rsch = new RegionServerCoprocessorHost(this.rss, HTU.getConfiguration());
    }

    @After
    public void after() throws IOException {
        this.rsch.preStop("Stopping", null);
    }

    @Test
    public void testCoreRegionCoprocessor() throws IOException {
        RegionServerCoprocessorEnvironment env = (RegionServerCoprocessorEnvironment)this.rsch.load(null, NotCoreRegionServerCoprocessor.class.getName(), 0, HTU.getConfiguration());
        Assert.assertFalse((boolean)(env instanceof HasRegionServerServices));
        env = (RegionServerCoprocessorEnvironment)this.rsch.load(null, CoreRegionServerCoprocessor.class.getName(), 1, HTU.getConfiguration());
        Assert.assertTrue((boolean)(env instanceof HasRegionServerServices));
        Assert.assertEquals((Object)this.rss, (Object)((HasRegionServerServices)env).getRegionServerServices());
    }

    @CoreCoprocessor
    public static class CoreRegionServerCoprocessor
    implements RegionServerCoprocessor {
    }

    public static class NotCoreRegionServerCoprocessor
    implements RegionServerCoprocessor {
    }
}

