/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagBuilderFactory;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestFromClientSide;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestPostIncrementAndAppendBeforeWAL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPostIncrementAndAppendBeforeWAL.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestFromClientSide.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static Connection connection;
    private static final byte[] ROW;
    private static final String CF1 = "cf1";
    private static final byte[] CF1_BYTES;
    private static final String CF2 = "cf2";
    private static final byte[] CF2_BYTES;
    private static final String CF_NOT_EXIST = "cf_not_exist";
    private static final byte[] CF_NOT_EXIST_BYTES;
    private static final byte[] CQ1;
    private static final byte[] CQ2;
    private static final byte[] VALUE;
    private static final byte[] VALUE2;
    private static final String USER = "User";
    private static final Permission PERMS;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        UTIL.startMiniCluster();
        connection = UTIL.getConnection();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        connection.close();
        UTIL.shutdownMiniCluster();
    }

    private void createTableWithCoprocessor(TableName tableName, String coprocessor) throws IOException {
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF1_BYTES).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF2_BYTES).build()).setCoprocessor(coprocessor).build();
        connection.getAdmin().createTable(tableDesc);
    }

    @Test
    public void testChangeCellWithDifferntColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableWithCoprocessor(tableName, ChangeCellWithDifferntColumnFamilyObserver.class.getName());
        try (Table table = connection.getTable(tableName);){
            Increment increment = new Increment(ROW).addColumn(CF1_BYTES, CQ1, 1L);
            table.increment(increment);
            Get get = new Get(ROW).addColumn(CF2_BYTES, CQ1);
            Result result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(CF2_BYTES, CQ1)));
            Append append = new Append(ROW).addColumn(CF1_BYTES, CQ2, VALUE);
            table.append(append);
            get = new Get(ROW).addColumn(CF2_BYTES, CQ2);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(CF2_BYTES, CQ2)));
        }
    }

    @Test
    public void testChangeCellWithNotExistColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableWithCoprocessor(tableName, ChangeCellWithNotExistColumnFamilyObserver.class.getName());
        try (Table table = connection.getTable(tableName);){
            try {
                Increment increment = new Increment(ROW).addColumn(CF1_BYTES, CQ1, 1L);
                table.increment(increment);
                Assert.fail((String)"should throw NoSuchColumnFamilyException");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof NoSuchColumnFamilyException));
            }
            try {
                Append append = new Append(ROW).addColumn(CF1_BYTES, CQ2, VALUE);
                table.append(append);
                Assert.fail((String)"should throw NoSuchColumnFamilyException");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof NoSuchColumnFamilyException));
            }
        }
    }

    @Test
    public void testIncrementTTLWithACLTag() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableWithCoprocessor(tableName, ChangeCellWithACLTagObserver.class.getName());
        try (Table table = connection.getTable(tableName);){
            Increment firstIncrement = new Increment(ROW).addColumn(CF1_BYTES, CQ1, 1L).setACL(USER, PERMS);
            Result result = table.increment(firstIncrement);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(CF1_BYTES, CQ1)));
            Get get = new Get(ROW).addColumn(CF1_BYTES, CQ1);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(CF1_BYTES, CQ1)));
            Increment secondIncrement = new Increment(ROW).addColumn(CF1_BYTES, CQ1, 1L).setTTL(1000L).setACL(USER, PERMS);
            result = table.increment(secondIncrement);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])result.getValue(CF1_BYTES, CQ1)));
            Thread.sleep(4000L);
            get = new Get(ROW).addColumn(CF1_BYTES, CQ1);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(CF1_BYTES, CQ1)));
        }
    }

    @Test
    public void testAppendTTLWithACLTag() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableWithCoprocessor(tableName, ChangeCellWithACLTagObserver.class.getName());
        try (Table table = connection.getTable(tableName);){
            Append firstAppend = new Append(ROW).addColumn(CF1_BYTES, CQ2, VALUE).setACL(USER, PERMS);
            Result result = table.append(firstAppend);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(CF1_BYTES, CQ2)));
            Get get = new Get(ROW).addColumn(CF1_BYTES, CQ2);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(CF1_BYTES, CQ2)));
            Append secondAppend = new Append(ROW).addColumn(CF1_BYTES, CQ2, VALUE).setTTL(1000L).setACL(USER, PERMS);
            result = table.append(secondAppend);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE2, (byte[])result.getValue(CF1_BYTES, CQ2)));
            Thread.sleep(4000L);
            get = new Get(ROW).addColumn(CF1_BYTES, CQ2);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(CF1_BYTES, CQ2)));
        }
    }

    private static boolean checkAclTag(byte[] acl, Cell cell) {
        Iterator iter = PrivateCellUtil.tagsIterator((Cell)cell);
        while (iter.hasNext()) {
            Tag tag = (Tag)iter.next();
            if (tag.getType() != 1) continue;
            Tag temp = TagBuilderFactory.create().setTagType((byte)1).setTagValue(acl).build();
            return Tag.matchingValue((Tag)tag, (Tag)temp);
        }
        return false;
    }

    static {
        ROW = Bytes.toBytes((String)"row");
        CF1_BYTES = Bytes.toBytes((String)CF1);
        CF2_BYTES = Bytes.toBytes((String)CF2);
        CF_NOT_EXIST_BYTES = Bytes.toBytes((String)CF_NOT_EXIST);
        CQ1 = Bytes.toBytes((String)"cq1");
        CQ2 = Bytes.toBytes((String)"cq2");
        VALUE = Bytes.toBytes((String)"value");
        VALUE2 = Bytes.toBytes((String)"valuevalue");
        PERMS = Permission.newBuilder().withActions(new Permission.Action[]{Permission.Action.READ}).build();
    }

    public static class ChangeCellWithACLTagObserver
    extends AccessController {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public List<Pair<Cell, Cell>> postIncrementBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
            List result = super.postIncrementBeforeWAL(ctx, mutation, cellPairs);
            for (Pair pair : result) {
                if (mutation.getACL() == null || TestPostIncrementAndAppendBeforeWAL.checkAclTag(mutation.getACL(), (Cell)pair.getSecond())) continue;
                throw new DoNotRetryIOException("Unmatched ACL tag.");
            }
            return result;
        }

        public List<Pair<Cell, Cell>> postAppendBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
            List result = super.postAppendBeforeWAL(ctx, mutation, cellPairs);
            for (Pair pair : result) {
                if (mutation.getACL() == null || TestPostIncrementAndAppendBeforeWAL.checkAclTag(mutation.getACL(), (Cell)pair.getSecond())) continue;
                throw new DoNotRetryIOException("Unmatched ACL tag.");
            }
            return result;
        }
    }

    public static class ChangeCellWithNotExistColumnFamilyObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public List<Pair<Cell, Cell>> postIncrementBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
            return cellPairs.stream().map(pair -> new Pair(pair.getFirst(), (Object)this.newCellWithNotExistColumnFamily((Cell)pair.getSecond()))).collect(Collectors.toList());
        }

        private Cell newCellWithNotExistColumnFamily(Cell cell) {
            return ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength()).setFamily(CF_NOT_EXIST_BYTES, 0, CF_NOT_EXIST_BYTES.length).setQualifier(CellUtil.cloneQualifier((Cell)cell)).setTimestamp(cell.getTimestamp()).setType(cell.getType().getCode()).setValue(CellUtil.cloneValue((Cell)cell)).build();
        }

        public List<Pair<Cell, Cell>> postAppendBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
            return cellPairs.stream().map(pair -> new Pair(pair.getFirst(), (Object)this.newCellWithNotExistColumnFamily((Cell)pair.getSecond()))).collect(Collectors.toList());
        }
    }

    public static class ChangeCellWithDifferntColumnFamilyObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public List<Pair<Cell, Cell>> postIncrementBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
            return cellPairs.stream().map(pair -> new Pair(pair.getFirst(), (Object)this.newCellWithDifferentColumnFamily((Cell)pair.getSecond()))).collect(Collectors.toList());
        }

        private Cell newCellWithDifferentColumnFamily(Cell cell) {
            return ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength()).setFamily(CF2_BYTES, 0, CF2_BYTES.length).setQualifier(CellUtil.cloneQualifier((Cell)cell)).setTimestamp(cell.getTimestamp()).setType(cell.getType().getCode()).setValue(CellUtil.cloneValue((Cell)cell)).build();
        }

        public List<Pair<Cell, Cell>> postAppendBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
            return cellPairs.stream().map(pair -> new Pair(pair.getFirst(), (Object)this.newCellWithDifferentColumnFamily((Cell)pair.getSecond()))).collect(Collectors.toList());
        }
    }
}

