/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, MediumTests.class})
public class FilterTestingCluster {
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Admin admin = null;
    private static List<TableName> createdTables = new ArrayList<TableName>();

    protected static void createTable(TableName tableName, String columnFamilyName) {
        Assert.assertNotNull((String)"HBaseAdmin is not initialized successfully.", (Object)admin);
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)columnFamilyName))).build();
        try {
            admin.createTable(tableDescriptor);
            createdTables.add(tableName);
            Assert.assertTrue((String)"Fail to create the table", (boolean)admin.tableExists(tableName));
        }
        catch (IOException e) {
            Assert.assertNull((String)"Exception found while creating table", (Object)e);
        }
    }

    protected static Table openTable(TableName tableName) throws IOException {
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        Assert.assertTrue((String)"Fail to create the table", (boolean)admin.tableExists(tableName));
        return table;
    }

    private static void deleteTables() {
        if (admin != null) {
            for (TableName tableName : createdTables) {
                try {
                    if (!admin.tableExists(tableName)) continue;
                    admin.disableTable(tableName);
                    admin.deleteTable(tableName);
                }
                catch (IOException e) {
                    Assert.assertNull((String)"Exception found deleting the table", (Object)e);
                }
            }
        }
    }

    private static void initialize(Configuration conf) {
        conf = HBaseConfiguration.create((Configuration)conf);
        conf.setInt("hbase.client.retries.number", 1);
        try {
            admin = TEST_UTIL.getAdmin();
        }
        catch (MasterNotRunningException e) {
            Assert.assertNull((String)"Master is not running", (Object)((Object)e));
        }
        catch (ZooKeeperConnectionException e) {
            Assert.assertNull((String)"Cannot connect to ZooKeeper", (Object)((Object)e));
        }
        catch (IOException e) {
            Assert.assertNull((String)"IOException", (Object)e);
        }
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        FilterTestingCluster.initialize(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        FilterTestingCluster.deleteTables();
        TEST_UTIL.shutdownMiniCluster();
    }
}

