/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.StringRange;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, MediumTests.class})
public class TestColumnRangeFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestColumnRangeFilter.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestColumnRangeFilter.class);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void TestColumnRangeFilterClient() throws Exception {
        String family = "Family";
        Table ht = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)family), Integer.MAX_VALUE);
        List<String> rows = this.generateRandomWords(10, 8);
        long maxTimestamp = 2L;
        List<String> columns = this.generateRandomWords(20000, 8);
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        HashMap rangeMap = new HashMap();
        rangeMap.put(new StringRange(null, true, "b", false), new ArrayList());
        rangeMap.put(new StringRange("p", true, "q", false), new ArrayList());
        rangeMap.put(new StringRange("r", false, "s", true), new ArrayList());
        rangeMap.put(new StringRange("z", false, null, false), new ArrayList());
        String valueString = "ValueString";
        for (String row : rows) {
            Put p = new Put(Bytes.toBytes((String)row));
            p.setDurability(Durability.SKIP_WAL);
            for (String column : columns) {
                for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                    KeyValue kv = KeyValueTestUtil.create((String)row, (String)family, (String)column, (long)timestamp, (String)valueString);
                    p.add((Cell)kv);
                    kvList.add(kv);
                    for (StringRange s : rangeMap.keySet()) {
                        if (!s.inRange(column)) continue;
                        ((List)rangeMap.get(s)).add(kv);
                    }
                }
            }
            ht.put(p);
        }
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.readAllVersions();
        for (StringRange s : rangeMap.keySet()) {
            ColumnRangeFilter filter = new ColumnRangeFilter(s.getStart() == null ? null : Bytes.toBytes((String)s.getStart()), s.isStartInclusive(), s.getEnd() == null ? null : Bytes.toBytes((String)s.getEnd()), s.isEndInclusive());
            Assert.assertEquals((long)((List)rangeMap.get(s)).size(), (long)this.cellsCount(ht, (Filter)filter));
        }
        ht.close();
    }

    @Test
    public void TestColumnRangeFilterWithColumnPaginationFilter() throws Exception {
        String family = "Family";
        String table = "TestColumnRangeFilterWithColumnPaginationFilter";
        try (Table ht = TEST_UTIL.createTable(TableName.valueOf((String)table), Bytes.toBytes((String)family), Integer.MAX_VALUE);){
            String row = "row";
            long timestamp = 100L;
            int[] columns = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
            String valueString = "ValueString";
            Put p = new Put(Bytes.toBytes((String)row));
            p.setDurability(Durability.SKIP_WAL);
            for (int column : columns) {
                KeyValue kv = KeyValueTestUtil.create((String)row, (String)family, (String)Integer.toString(column), (long)timestamp, (String)valueString);
                p.add((Cell)kv);
            }
            ht.put(p);
            TEST_UTIL.flush();
            StringRange stringRange = new StringRange("1", true, "9", false);
            ColumnRangeFilter filter1 = new ColumnRangeFilter(Bytes.toBytes((String)stringRange.getStart()), stringRange.isStartInclusive(), Bytes.toBytes((String)stringRange.getEnd()), stringRange.isEndInclusive());
            ColumnPaginationFilter filter2 = new ColumnPaginationFilter(5, 0);
            ColumnPaginationFilter filter3 = new ColumnPaginationFilter(5, 1);
            ColumnPaginationFilter filter4 = new ColumnPaginationFilter(5, 2);
            ColumnPaginationFilter filter5 = new ColumnPaginationFilter(5, 6);
            ColumnPaginationFilter filter6 = new ColumnPaginationFilter(5, 9);
            Assert.assertEquals((long)5L, (long)this.cellsCount(ht, (Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{filter1, filter2})));
            Assert.assertEquals((long)5L, (long)this.cellsCount(ht, (Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{filter1, filter3})));
            Assert.assertEquals((long)5L, (long)this.cellsCount(ht, (Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{filter1, filter4})));
            Assert.assertEquals((long)2L, (long)this.cellsCount(ht, (Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{filter1, filter5})));
            Assert.assertEquals((long)0L, (long)this.cellsCount(ht, (Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{filter1, filter6})));
        }
    }

    private int cellsCount(Table table, Filter filter) throws IOException {
        Scan scan = new Scan().setFilter(filter).readAllVersions();
        try (ResultScanner scanner = table.getScanner(scan);){
            Result result;
            ArrayList results = new ArrayList();
            while ((result = scanner.next()) != null) {
                result.listCells().forEach(results::add);
            }
            int n = results.size();
            return n;
        }
    }

    List<String> generateRandomWords(int numberOfWords, int maxLengthOfWords) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            int lengthOfWords = (int)(Math.random() * (double)maxLengthOfWords) + 1;
            char[] wordChar = new char[lengthOfWords];
            for (int j = 0; j < wordChar.length; ++j) {
                wordChar[j] = (char)(Math.random() * 26.0 + 97.0);
            }
            String word = new String(wordChar);
            wordSet.add(word);
        }
        ArrayList<String> wordList = new ArrayList<String>(wordSet);
        return wordList;
    }
}

