/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.filter.BigDecimalComparator;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassLoaderTestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={FilterTests.class, SmallTests.class})
public class TestComparatorSerialization {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestComparatorSerialization.class);
    @Parameterized.Parameter(value=0)
    public boolean allowFastReflectionFallthrough;

    @Parameterized.Parameters(name="{index}: allowFastReflectionFallthrough={0}")
    public static Iterable<Object[]> data() {
        return HBaseCommonTestingUtil.BOOLEAN_PARAMETERIZED;
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ProtobufUtil.setAllowFastReflectionFallthrough((boolean)true);
    }

    @Test
    public void testBinaryComparator() throws Exception {
        BinaryComparator binaryComparator = new BinaryComparator(Bytes.toBytes((String)"binaryComparator"));
        Assert.assertTrue((boolean)binaryComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)binaryComparator))));
    }

    @Test
    public void testBinaryPrefixComparator() throws Exception {
        BinaryPrefixComparator binaryPrefixComparator = new BinaryPrefixComparator(Bytes.toBytes((String)"binaryPrefixComparator"));
        Assert.assertTrue((boolean)binaryPrefixComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)binaryPrefixComparator))));
    }

    @Test
    public void testBitComparator() throws Exception {
        BitComparator bitComparator = new BitComparator(Bytes.toBytes((String)"bitComparator"), BitComparator.BitwiseOp.XOR);
        Assert.assertTrue((boolean)bitComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)bitComparator))));
    }

    @Test
    public void testNullComparator() throws Exception {
        NullComparator nullComparator = new NullComparator();
        Assert.assertTrue((boolean)nullComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)nullComparator))));
    }

    @Test
    public void testRegexStringComparator() throws Exception {
        RegexStringComparator regexStringComparator = new RegexStringComparator(".+-2");
        Assert.assertTrue((boolean)regexStringComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)regexStringComparator))));
        try {
            new RegexStringComparator("regex", 34);
        }
        catch (Throwable t) {
            Assert.assertNull((String)"Exception occurred while created the RegexStringComparator object", (Object)t);
        }
    }

    @Test
    public void testSubstringComparator() throws Exception {
        SubstringComparator substringComparator = new SubstringComparator("substr");
        Assert.assertTrue((boolean)substringComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)substringComparator))));
    }

    @Test
    public void testBigDecimalComparator() throws Exception {
        BigDecimal bigDecimal = new BigDecimal(Double.MIN_VALUE);
        BigDecimalComparator bigDecimalComparator = new BigDecimalComparator(bigDecimal);
        Assert.assertTrue((boolean)bigDecimalComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)bigDecimalComparator))));
    }

    @Test
    public void testCustomComparator() throws Exception {
        BinaryComparator baseFilter = new BinaryComparator("foo".getBytes());
        ComparatorProtos.Comparator proto = ProtobufUtil.toComparator((ByteArrayComparable)baseFilter);
        String suffix = "" + System.currentTimeMillis() + this.allowFastReflectionFallthrough;
        String className = "CustomLoadedComparator" + suffix;
        proto = proto.toBuilder().setName(className).build();
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtil testUtil = new HBaseTestingUtil();
        String dataTestDir = testUtil.getDataTestDir().toString();
        ClassLoaderTestHelper.deleteClass((String)className, (String)dataTestDir, (Configuration)conf);
        try {
            ProtobufUtil.toComparator((ComparatorProtos.Comparator)proto);
            Assert.fail((String)"expected to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String code = StringSubstitutor.replace((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/CustomLoadedComparator.java.template"), (Charset)Charset.defaultCharset()), Collections.singletonMap("suffix", suffix));
        ClassLoaderTestHelper.buildJar((String)dataTestDir, (String)className, (String)code, (String)ClassLoaderTestHelper.localDirPath((Configuration)conf));
        ProtobufUtil.setAllowFastReflectionFallthrough((boolean)false);
        try {
            ProtobufUtil.toComparator((ComparatorProtos.Comparator)proto);
            Assert.fail((String)"expected to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ProtobufUtil.setAllowFastReflectionFallthrough((boolean)true);
        ProtobufUtil.toComparator((ComparatorProtos.Comparator)proto);
    }
}

