/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, FilterTests.class})
public class TestFilterListOnMini {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFilterListOnMini.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFilterListOnMini.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFiltersWithOR() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tn, new String[]{"cf1", "cf2"});
        byte[] CF1 = Bytes.toBytes((String)"cf1");
        byte[] CF2 = Bytes.toBytes((String)"cf2");
        Put put1 = new Put(Bytes.toBytes((String)"0"));
        put1.addColumn(CF1, Bytes.toBytes((String)"col_a"), Bytes.toBytes((int)0));
        table.put(put1);
        Put put2 = new Put(Bytes.toBytes((String)"0"));
        put2.addColumn(CF2, Bytes.toBytes((String)"col_b"), Bytes.toBytes((int)0));
        table.put(put2);
        FamilyFilter filterCF1 = new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(CF1));
        FamilyFilter filterCF2 = new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(CF2));
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter((Filter)filterCF1);
        filterList.addFilter((Filter)filterCF2);
        Scan scan = new Scan();
        scan.setFilter((Filter)filterList);
        ResultScanner scanner = table.getScanner(scan);
        LOG.info("Filter list: " + filterList);
        Result rr = scanner.next();
        while (rr != null) {
            Assert.assertEquals((long)2L, (long)rr.size());
            rr = scanner.next();
        }
    }

    @Test
    public void testColumnPrefixFilterConcatWithOR() throws Exception {
        Result result;
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        byte[] cf1 = Bytes.toBytes((String)"f1");
        byte[] row = Bytes.toBytes((String)"row");
        byte[] value = Bytes.toBytes((String)"value");
        String[] columns = new String[]{"1544768273917010001_lt", "1544768273917010001_w_1", "1544768723910010001_ca_1", "1544768723910010001_lt", "1544768723910010001_ut_1", "1544768723910010001_w_5", "1544769779710010001_lt", "1544769779710010001_w_5", "1544769883529010001_lt", "1544769883529010001_w_5", "1544769915805010001_lt", "1544769915805010001_w_5", "1544779883529010001_lt", "1544770422942010001_lt", "1544770422942010001_w_5"};
        Table table = TEST_UTIL.createTable(tn, cf1);
        for (int i = 0; i < columns.length; ++i) {
            Put put = new Put(row).addColumn(cf1, Bytes.toBytes((String)columns[i]), value);
            table.put(put);
        }
        Scan scan = new Scan();
        scan.withStartRow(row).withStopRow(row, true).setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ONE, new Filter[]{new ColumnPrefixFilter(Bytes.toBytes((String)"1544770422942010001_")), new ColumnPrefixFilter(Bytes.toBytes((String)"1544769883529010001_"))}));
        ResultScanner scanner = table.getScanner(scan);
        int resultCount = 0;
        int cellCount = 0;
        while ((result = scanner.next()) != null) {
            cellCount += result.listCells().size();
            ++resultCount;
        }
        Assert.assertEquals((long)resultCount, (long)1L);
        Assert.assertEquals((long)cellCount, (long)4L);
    }
}

