/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMultiRowRangeFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiRowRangeFilter.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiRowRangeFilter.class);
    private byte[] family = Bytes.toBytes((String)"family");
    private byte[] qf = Bytes.toBytes((String)"qf");
    private byte[] value = Bytes.toBytes((String)"val");
    private TableName tableName;
    private int numRows = 100;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRowKeyPrefixWithEmptyPrefix() throws IOException {
        byte[] prefix = new byte[]{};
        byte[][] rowKeyPrefixes = new byte[][]{prefix};
        MultiRowRangeFilter filter = new MultiRowRangeFilter((byte[][])rowKeyPrefixes);
        List actualRanges = filter.getRowRanges();
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(HConstants.EMPTY_START_ROW, true, HConstants.EMPTY_END_ROW, false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testRowKeyPrefixWithLastIncrementablePrefix() throws IOException {
        byte[] prefix = new byte[]{18, 35, -1, -2};
        byte[][] rowKeyPrefixes = new byte[][]{prefix};
        MultiRowRangeFilter filter = new MultiRowRangeFilter((byte[][])rowKeyPrefixes);
        List actualRanges = filter.getRowRanges();
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        byte[] expectedStop = new byte[]{18, 35, -1, -1};
        expectedRanges.add(new MultiRowRangeFilter.RowRange(prefix, true, expectedStop, false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testRowKeyPrefixWithoutLastIncrementablePrefix() throws IOException {
        byte[] prefix = new byte[]{18, 35, -1, -1};
        byte[][] rowKeyPrefixes = new byte[][]{prefix};
        MultiRowRangeFilter filter = new MultiRowRangeFilter((byte[][])rowKeyPrefixes);
        List actualRanges = filter.getRowRanges();
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        byte[] expectedStop = new byte[]{18, 36};
        expectedRanges.add(new MultiRowRangeFilter.RowRange(prefix, true, expectedStop, false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testRowKeyPrefixWithMergablePrefix() throws IOException {
        byte[] prefix1 = new byte[]{18, 35, -1, -2};
        byte[] prefix2 = new byte[]{18, 35, -1, -1};
        byte[][] rowKeyPrefixes = new byte[][]{prefix1, prefix2};
        MultiRowRangeFilter filter = new MultiRowRangeFilter((byte[][])rowKeyPrefixes);
        List actualRanges = filter.getRowRanges();
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        byte[] expectedStop = new byte[]{18, 36};
        expectedRanges.add(new MultiRowRangeFilter.RowRange(prefix1, true, expectedStop, false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testRanges() throws IOException {
        byte[] key1Start = new byte[]{-3};
        byte[] key1End = new byte[]{-2};
        byte[] key2Start = new byte[]{5};
        byte[] key2End = new byte[]{6};
        byte[] badKey = new byte[]{-10};
        MultiRowRangeFilter filter = new MultiRowRangeFilter(Arrays.asList(new MultiRowRangeFilter.RowRange(key1Start, true, key1End, false), new MultiRowRangeFilter.RowRange(key2Start, true, key2End, false)));
        filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])badKey));
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell(null));
    }

    @Test
    public void testOutOfOrderScannerNextException() throws Exception {
        MultiRowRangeFilter filter = new MultiRowRangeFilter(Arrays.asList(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"c"), true), new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"d"), true, Bytes.toBytes((String)"e"), true)));
        filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"a")));
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell(null));
        filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"b")));
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell(null));
        filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"c")));
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell(null));
        filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"d")));
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell(null));
        filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"e")));
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell(null));
    }

    @Test
    public void testMergeAndSortWithEmptyStartRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((int)40), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((int)40), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithEmptyStopRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((String)""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)70), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithEmptyStartRowAndStopRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((String)""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)70), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiRowRangeWithoutRange() throws IOException {
        ArrayList ranges = new ArrayList();
        new MultiRowRangeFilter(ranges);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiRowRangeWithInvalidRange() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)80), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)70), false));
        new MultiRowRangeFilter(ranges);
    }

    @Test
    public void testMergeAndSortWithoutOverlap() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithOverlap() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)30), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)50), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)70), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)90), true, Bytes.toBytes((int)100), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)95), true, Bytes.toBytes((int)100), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)70), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)90), true, Bytes.toBytes((int)100), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithStartRowInclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((String)""), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithRowExclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), false, Bytes.toBytes((String)""), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), false, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithRowInclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), true));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), false, Bytes.toBytes((String)""), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    public void assertRangesEqual(List<MultiRowRangeFilter.RowRange> expected, List<MultiRowRangeFilter.RowRange> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])expected.get(i).getStartRow(), (byte[])actual.get(i).getStartRow()));
            Assert.assertTrue((expected.get(i).isStartRowInclusive() == actual.get(i).isStartRowInclusive() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])expected.get(i).getStopRow(), (byte[])actual.get(i).getStopRow()));
            Assert.assertTrue((expected.get(i).isStopRowInclusive() == actual.get(i).isStopRowInclusive() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiRowRangeFilterWithRangeOverlap() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.readAllVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)65), true, Bytes.toBytes((int)75), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, null, false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)80), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        LOG.info("found " + resultsSize + " results");
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)60), Bytes.toBytes((String)""), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithoutRangeOverlap() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.readAllVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        LOG.info("found " + resultsSize + " results");
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)20), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)30), Bytes.toBytes((int)40), ht);
        List<Cell> results3 = this.getScanResult(Bytes.toBytes((int)60), Bytes.toBytes((int)70), ht);
        Assert.assertEquals((long)(results1.size() + results2.size() + results3.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithEmptyStartRow() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.readAllVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((int)10), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((String)""), Bytes.toBytes((int)10), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)30), Bytes.toBytes((int)40), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithEmptyStopRow() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.readAllVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((String)""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((String)""), ht);
        Assert.assertEquals((long)results1.size(), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithInclusive() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.readAllVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)65), true, Bytes.toBytes((int)75), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, null, false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)80), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        LOG.info("found " + resultsSize + " results");
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)60), Bytes.toBytes((String)""), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithExclusive() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.getConfiguration().setInt("hbase.client.scanner.timeout.period", 6000000);
        TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        try (Table ht = TEST_UTIL.getConnection().getTableBuilder(this.tableName, null).setReadRpcTimeout(600000).setOperationTimeout(6000000).build();){
            this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
            Scan scan = new Scan();
            scan.readAllVersions();
            ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
            ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
            ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), false, Bytes.toBytes((int)40), false));
            ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)65), true, Bytes.toBytes((int)75), false));
            MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
            scan.setFilter((Filter)filter);
            int resultsSize = this.getResultsSize(ht, scan);
            LOG.info("found " + resultsSize + " results");
            List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)40), ht);
            List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)65), Bytes.toBytes((int)75), ht);
            Assert.assertEquals((long)(results1.size() - 1 + results2.size()), (long)resultsSize);
        }
    }

    @Test
    public void testMultiRowRangeWithFilterListAndOperator() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.readAllVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges1 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        MultiRowRangeFilter filter1 = new MultiRowRangeFilter(ranges1);
        ArrayList<MultiRowRangeFilter.RowRange> ranges2 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)40), false));
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)80), true, Bytes.toBytes((int)90), false));
        MultiRowRangeFilter filter2 = new MultiRowRangeFilter(ranges2);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        filterList.addFilter((Filter)filter1);
        filterList.addFilter((Filter)filter2);
        scan.setFilter((Filter)filterList);
        int resultsSize = this.getResultsSize(ht, scan);
        LOG.info("found " + resultsSize + " results");
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)30), Bytes.toBytes((int)40), ht);
        Assert.assertEquals((long)results1.size(), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeWithFilterListOrOperator() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.readAllVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges1 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        MultiRowRangeFilter filter1 = new MultiRowRangeFilter(ranges1);
        ArrayList<MultiRowRangeFilter.RowRange> ranges2 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)40), false));
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)80), true, Bytes.toBytes((int)90), false));
        MultiRowRangeFilter filter2 = new MultiRowRangeFilter(ranges2);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter((Filter)filter1);
        filterList.addFilter((Filter)filter2);
        scan.setFilter((Filter)filterList);
        int resultsSize = this.getResultsSize(ht, scan);
        LOG.info("found " + resultsSize + " results");
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)60), Bytes.toBytes((int)70), ht);
        List<Cell> results3 = this.getScanResult(Bytes.toBytes((int)80), Bytes.toBytes((int)90), ht);
        Assert.assertEquals((long)(results1.size() + results2.size() + results3.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testOneRowRange() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        ArrayList<MultiRowRangeFilter.RowRange> rowRangesList = new ArrayList<MultiRowRangeFilter.RowRange>();
        rowRangesList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)50), true, Bytes.toBytes((int)50), true));
        Scan scan = new Scan();
        scan.setFilter((Filter)new MultiRowRangeFilter(rowRangesList));
        int resultsSize = this.getResultsSize(ht, scan);
        Assert.assertEquals((long)1L, (long)resultsSize);
        rowRangesList.clear();
        rowRangesList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)50), true, Bytes.toBytes((int)51), false));
        scan = new Scan();
        scan.setFilter((Filter)new MultiRowRangeFilter(rowRangesList));
        resultsSize = this.getResultsSize(ht, scan);
        Assert.assertEquals((long)1L, (long)resultsSize);
        rowRangesList.clear();
        rowRangesList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)50), true, Bytes.toBytes((int)51), true));
        scan = new Scan();
        scan.setFilter((Filter)new MultiRowRangeFilter(rowRangesList));
        resultsSize = this.getResultsSize(ht, scan);
        Assert.assertEquals((long)2L, (long)resultsSize);
        ht.close();
    }

    @Test
    public void testReverseMultiRowRangeFilterWithinTable() throws IOException {
        int i;
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setReversed(true);
        List<MultiRowRangeFilter.RowRange> ranges = Arrays.asList(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)30), true), new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)50), true, Bytes.toBytes((int)60), true));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        ArrayList<Integer> expectedResults = new ArrayList<Integer>();
        for (i = 60; i >= 50; --i) {
            expectedResults.add(i);
        }
        for (i = 30; i >= 20; --i) {
            expectedResults.add(i);
        }
        List<Cell> results = this.getResults(ht, scan);
        ArrayList<Integer> actualResults = new ArrayList<Integer>();
        StringBuilder sb = new StringBuilder();
        for (Cell result : results) {
            int observedValue = Bytes.toInt((byte[])result.getRowArray(), (int)result.getRowOffset(), (int)result.getRowLength());
            actualResults.add(observedValue);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(observedValue);
        }
        Assert.assertEquals((String)("Saw results: " + sb.toString()), (long)22L, (long)results.size());
    }

    @Test
    public void testReverseMultiRowRangeFilterIncludingMaxRow() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family);
        for (String rowkey : Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h")) {
            byte[] row = Bytes.toBytes((String)rowkey);
            Put p = new Put(row);
            p.addColumn(this.family, this.qf, this.value);
            ht.put(p);
        }
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.setReversed(true);
        List<MultiRowRangeFilter.RowRange> ranges = Arrays.asList(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"c"), true), new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"f"), true, Bytes.toBytes((String)"h"), true));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        List<String> expected = Arrays.asList("h", "g", "f", "c", "b");
        ArrayList<String> actual = new ArrayList<String>();
        for (Cell cell : this.getResults(ht, scan)) {
            actual.add(Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testReverseMultiRowRangeFilterIncludingMinRow() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family);
        for (String rowkey : Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h")) {
            byte[] row = Bytes.toBytes((String)rowkey);
            Put p = new Put(row);
            p.addColumn(this.family, this.qf, this.value);
            ht.put(p);
        }
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.setReversed(true);
        List<MultiRowRangeFilter.RowRange> ranges = Arrays.asList(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"c"), true), new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"f"), true, Bytes.toBytes((String)"g"), true));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        List<String> expected = Arrays.asList("g", "f", "c", "b", "a");
        ArrayList<String> actual = new ArrayList<String>();
        for (Cell cell : this.getResults(ht, scan)) {
            actual.add(Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testReverseMultiRowRangeFilterIncludingMinAndMaxRow() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family);
        for (String rowkey : Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h")) {
            byte[] row = Bytes.toBytes((String)rowkey);
            Put p = new Put(row);
            p.addColumn(this.family, this.qf, this.value);
            ht.put(p);
        }
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.setReversed(true);
        List<MultiRowRangeFilter.RowRange> ranges = Arrays.asList(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"c"), true), new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"f"), true, Bytes.toBytes((String)"h"), true));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        List<String> expected = Arrays.asList("h", "g", "f", "c", "b", "a");
        ArrayList<String> actual = new ArrayList<String>();
        for (Cell cell : this.getResults(ht, scan)) {
            actual.add(Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
        }
        Assert.assertEquals(expected, actual);
    }

    private void generateRows(int numberOfRows, Table ht, byte[] family, byte[] qf, byte[] value) throws IOException {
        for (int i = 0; i < numberOfRows; ++i) {
            byte[] row = Bytes.toBytes((int)i);
            Put p = new Put(row);
            p.addColumn(family, qf, value);
            ht.put(p);
        }
        TEST_UTIL.flush();
    }

    private List<Cell> getScanResult(byte[] startRow, byte[] stopRow, Table ht) throws IOException {
        Result r;
        Scan scan = new Scan();
        scan.readAllVersions();
        if (!Bytes.toString((byte[])startRow).isEmpty()) {
            scan.withStartRow(startRow);
        }
        if (!Bytes.toString((byte[])stopRow).isEmpty()) {
            scan.withStopRow(stopRow);
        }
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> kvList = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                kvList.add(kv);
            }
        }
        scanner.close();
        return kvList;
    }

    private List<Cell> getResults(Table ht, Scan scan) throws IOException {
        Result r;
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                results.add(kv);
            }
        }
        scanner.close();
        return results;
    }

    private int getResultsSize(Table ht, Scan scan) throws IOException {
        return this.getResults(ht, scan).size();
    }
}

