/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, SmallTests.class})
public class TestQualifierFilterWithEmptyQualifier {
    private static final Logger LOG = LoggerFactory.getLogger(TestQualifierFilterWithEmptyQualifier.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQualifierFilterWithEmptyQualifier.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private HRegion region;
    @Rule
    public TestName name = new TestName();
    private static final byte[][] ROWS = new byte[][]{Bytes.toBytes((String)"testRowOne-0"), Bytes.toBytes((String)"testRowOne-1"), Bytes.toBytes((String)"testRowOne-2"), Bytes.toBytes((String)"testRowOne-3")};
    private static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static final byte[][] QUALIFIERS = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"testQualifier")};
    private static final byte[] VALUE = Bytes.toBytes((String)"testValueOne");
    private long numRows = ROWS.length;

    @Before
    public void setUp() throws Exception {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"TestQualifierFilter")).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build()).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        this.region = HBaseTestingUtil.createRegionAndWAL(info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), htd);
        for (byte[] ROW : ROWS) {
            Put p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS) {
                p.addColumn(FAMILY, QUALIFIER, VALUE);
            }
            this.region.put(p);
        }
        this.region.flush(true);
    }

    @After
    public void tearDown() throws Exception {
        HBaseTestingUtil.closeRegionAndWAL(this.region);
    }

    @Test
    public void testQualifierFilterWithEmptyColumn() throws IOException {
        long colsPerRow = 2L;
        long expectedKeys = colsPerRow / 2L;
        QualifierFilter f = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(QUALIFIERS[0]));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, this.numRows, expectedKeys);
        expectedKeys = colsPerRow / 2L;
        f = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(QUALIFIERS[1]));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, this.numRows, expectedKeys);
        expectedKeys = colsPerRow / 2L;
        f = new QualifierFilter(CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(QUALIFIERS[0]));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, this.numRows, expectedKeys);
        expectedKeys = colsPerRow;
        f = new QualifierFilter(CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(QUALIFIERS[0]));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, this.numRows, expectedKeys);
    }

    private void verifyScanNoEarlyOut(Scan s, long expectedRows, long expectedKeys) throws IOException {
        RegionScannerImpl scanner = this.region.getScanner(s);
        ArrayList results = new ArrayList();
        int i = 0;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Arrays.sort(results.toArray(new Cell[results.size()]), CellComparator.getInstance());
            LOG.info("counter=" + i + ", " + results);
            if (results.isEmpty()) break;
            Assert.assertTrue((String)("Scanned too many rows! Only expected " + expectedRows + " total but already scanned " + (i + 1)), (expectedRows > (long)i ? 1 : 0) != 0);
            Assert.assertEquals((String)("Expected " + expectedKeys + " keys per row but returned " + results.size()), (long)expectedKeys, (long)results.size());
            results.clear();
            ++i;
        }
        Assert.assertEquals((String)("Expected " + expectedRows + " rows but scanned " + i + " rows"), (long)expectedRows, (long)i);
    }
}

