/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.encoding.TestDataBlockEncoders;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IOTests.class, SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestSeekToBlockWithEncoders {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSeekToBlockWithEncoders.class);
    static final byte[] HFILEBLOCK_DUMMY_HEADER = new byte[33];
    private final boolean useOffheapData;
    private final Configuration conf = HBaseConfiguration.create();

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseCommonTestingUtil.BOOLEAN_PARAMETERIZED;
    }

    public TestSeekToBlockWithEncoders(boolean useOffheapData) {
        this.useOffheapData = useOffheapData;
    }

    @Test
    public void testSeekToBlockWithNonMatchingSeekKey() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"aab"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv3);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"aad"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"bba"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes((String)"aae"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        this.seekToTheKey(kv4, sampleKv, (Cell)toSeek);
    }

    @Test
    public void testSeekingToBlockWithBiggerNonLength1() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"aab"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv3);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"aad"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"aaddd"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        this.seekToTheKey(kv1, sampleKv, (Cell)toSeek);
    }

    @Test
    public void testSeekingToBlockToANotAvailableKey() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"aab"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv3);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"aade"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"bbbcd"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes((String)"bbbce"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        this.seekToTheKey(kv5, sampleKv, (Cell)toSeek);
    }

    @Test
    public void testSeekToBlockWithDecreasingCommonPrefix() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"row10aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"row10aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"row10aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q3"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv3);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"row11baa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        Cell toSeek = PrivateCellUtil.createLastOnRow((Cell)kv3);
        this.seekToTheKey(kv3, sampleKv, toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffQualifer() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"aab"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"val"));
        this.seekToTheKey(kv5, sampleKv, (Cell)toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffQualiferOnSameRow() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q3"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q4"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv5);
        KeyValue kv6 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q5"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv6);
        KeyValue toSeek = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q5"), Bytes.toBytes((String)"val"));
        this.seekToTheKey(kv6, sampleKv, (Cell)toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffQualiferOnSameRow1() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q3"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q4"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv5);
        KeyValue kv6 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"z5"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv6);
        KeyValue toSeek = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q5"), Bytes.toBytes((String)"val"));
        this.seekToTheKey(kv5, sampleKv, (Cell)toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffQualiferOnSameRowButDescendingInSize() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"qual1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"qual2"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"qual3"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"qual4"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv5);
        KeyValue kv6 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"qz"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv6);
        KeyValue toSeek = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"qz"), Bytes.toBytes((String)"val"));
        this.seekToTheKey(kv6, sampleKv, (Cell)toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffFamilyAndQualifer() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"aab"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes((String)"aac"), Bytes.toBytes((String)"fam2"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"val"));
        this.seekToTheKey(kv5, sampleKv, (Cell)toSeek);
    }

    private void seekToTheKey(KeyValue expected, List<KeyValue> kvs, Cell toSeek) throws IOException {
        ArrayList<DataBlockEncoder.EncodedSeeker> encodedSeekers = new ArrayList<DataBlockEncoder.EncodedSeeker>();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            if (encoding.getEncoder() == null) continue;
            DataBlockEncoder encoder = encoding.getEncoder();
            HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(false).withCompression(Compression.Algorithm.NONE).build();
            HFileBlockEncodingContext encodingContext = encoder.newDataBlockEncodingContext(this.conf, encoding, HFILEBLOCK_DUMMY_HEADER, meta);
            ByteBuffer encodedBuffer = TestDataBlockEncoders.encodeKeyValues(encoding, kvs, encodingContext, this.useOffheapData);
            DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(encoder.newDataBlockDecodingContext(this.conf, meta));
            seeker.setCurrentBuffer((ByteBuff)new SingleByteBuff(encodedBuffer));
            encodedSeekers.add(seeker);
        }
        this.checkSeekingConsistency(encodedSeekers, toSeek, expected);
    }

    private void checkSeekingConsistency(List<DataBlockEncoder.EncodedSeeker> encodedSeekers, Cell keyValue, KeyValue expected) {
        for (DataBlockEncoder.EncodedSeeker seeker : encodedSeekers) {
            seeker.seekToKeyInBlock(keyValue, false);
            Cell keyValue2 = seeker.getCell();
            Assert.assertEquals((Object)expected, (Object)keyValue2);
            seeker.rewind();
        }
    }
}

