/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.EventMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.io.util.BlockIOUtils;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={IOTests.class, SmallTests.class})
public class TestBlockIOUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockIOUtils.class);
    @Rule
    public TestName testName = new TestName();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public OpenTelemetryRule otelRule = OpenTelemetryRule.create();
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final int NUM_TEST_BLOCKS = 2;
    private static final Compression.Algorithm COMPRESSION_ALGO = Compression.Algorithm.GZ;

    @Test
    public void testIsByteBufferReadable() throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path p = new Path(TEST_UTIL.getDataTestDirOnTestFS(), "testIsByteBufferReadable");
        try (FSDataOutputStream out = fs.create(p);){
            out.writeInt(23);
        }
        var4_4 = null;
        try (FSDataInputStream is = fs.open(p);){
            Assert.assertFalse((boolean)BlockIOUtils.isByteBufferReadable((FSDataInputStream)is));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testReadFully() throws IOException {
        TraceUtil.trace(() -> {
            FileSystem fs = TEST_UTIL.getTestFileSystem();
            Path p = new Path(TEST_UTIL.getDataTestDirOnTestFS(), "testReadFully");
            String s = "hello world";
            try (FSDataOutputStream out = fs.create(p);){
                out.writeBytes(s);
            }
            SingleByteBuff buf = new SingleByteBuff(ByteBuffer.allocate(11));
            try (FSDataInputStream in = fs.open(p);){
                BlockIOUtils.readFully((ByteBuff)buf, (FSDataInputStream)in, (int)11);
            }
            buf.rewind();
            byte[] heapBuf = new byte[s.length()];
            buf.get(heapBuf, 0, heapBuf.length);
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)s), (byte[])heapBuf);
        }, (String)this.testName.getMethodName());
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.readFully"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)11L))))))}));
    }

    @Test
    public void testPreadWithReadFullBytes() throws IOException {
        this.testPreadReadFullBytesInternal(true, EnvironmentEdgeManager.currentTime());
    }

    @Test
    public void testPreadWithoutReadFullBytes() throws IOException {
        this.testPreadReadFullBytesInternal(false, EnvironmentEdgeManager.currentTime());
    }

    private void testPreadReadFullBytesInternal(boolean readAllBytes, long randomSeed) throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hfile.pread.all.bytes.enabled", readAllBytes);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path path = new Path(TEST_UTIL.getDataTestDirOnTestFS(), this.testName.getMethodName());
        Random rand = new Random(randomSeed);
        long totalDataBlockBytes = this.writeBlocks(TEST_UTIL.getConfiguration(), rand, COMPRESSION_ALGO, path);
        this.readDataBlocksAndVerify(fs, path, COMPRESSION_ALGO, totalDataBlockBytes);
    }

    private long writeBlocks(Configuration conf, Random rand, Compression.Algorithm compressAlgo, Path path) throws IOException {
        FileSystem fs = HFileSystem.get((Configuration)conf);
        FSDataOutputStream os = fs.create(path);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(true).withCompression(compressAlgo).build();
        HFileBlock.Writer hbw = new HFileBlock.Writer(conf, null, meta);
        long totalDataBlockBytes = 0L;
        for (int i = 0; i < 2; ++i) {
            int blockTypeOrdinal = rand.nextInt(BlockType.values().length);
            if (blockTypeOrdinal == BlockType.ENCODED_DATA.ordinal()) {
                blockTypeOrdinal = BlockType.DATA.ordinal();
            }
            BlockType bt = BlockType.values()[blockTypeOrdinal];
            DataOutputStream dos = hbw.startWriting(bt);
            int size = rand.nextInt(500);
            for (int j = 0; j < size; ++j) {
                dos.writeShort(i + 1);
                dos.writeInt(j + 1);
            }
            hbw.writeHeaderAndData(os);
            totalDataBlockBytes += (long)hbw.getOnDiskSizeWithHeader();
        }
        FixedFileTrailer trailer = new FixedFileTrailer(3, 3);
        trailer.setFirstDataBlockOffset(0L);
        trailer.setLastDataBlockOffset(totalDataBlockBytes);
        trailer.setComparatorClass(meta.getCellComparator().getClass());
        trailer.setDataIndexCount(2);
        trailer.setCompressionCodec(compressAlgo);
        trailer.serialize((DataOutputStream)os);
        os.close();
        return totalDataBlockBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDataBlocksAndVerify(FileSystem fs, Path path, Compression.Algorithm compressAlgo, long totalDataBlockBytes) throws IOException {
        FSDataInputStream is = fs.open(path);
        HFileContext fileContext = new HFileContextBuilder().withHBaseCheckSum(true).withCompression(compressAlgo).build();
        ReaderContext context = new ReaderContextBuilder().withInputStreamWrapper(new FSDataInputStreamWrapper(is)).withReaderType(ReaderContext.ReaderType.PREAD).withFileSize(totalDataBlockBytes).withFilePath(path).withFileSystem(fs).build();
        HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(context, fileContext, ByteBuffAllocator.HEAP, fs.getConf());
        long onDiskSizeOfNextBlock = -1L;
        long offset = 0L;
        int numOfReadBlock = 0;
        while (offset < totalDataBlockBytes) {
            HFileBlock block = hbr.readBlockData(offset, onDiskSizeOfNextBlock, true, false, false);
            ++numOfReadBlock;
            try {
                onDiskSizeOfNextBlock = block.getNextBlockOnDiskSize();
                offset += (long)block.getOnDiskSizeWithHeader();
            }
            finally {
                block.release();
            }
        }
        Assert.assertEquals((long)totalDataBlockBytes, (long)offset);
        Assert.assertEquals((long)2L, (long)numOfReadBlock);
        this.deleteFile(fs, path);
    }

    private void deleteFile(FileSystem fs, Path path) throws IOException {
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWithExtra() throws IOException {
        byte[] heapBuf;
        Throwable throwable;
        FSDataInputStream in;
        SingleByteBuff buf2;
        Throwable throwable2;
        Scope ignored;
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path p = new Path(TEST_UTIL.getDataTestDirOnTestFS(), "testReadWithExtra");
        String s = "hello world";
        try (FSDataOutputStream out = fs.create(p);){
            out.writeBytes(s);
        }
        Span span = TraceUtil.createSpan((String)this.testName.getMethodName());
        try {
            ignored = span.makeCurrent();
            throwable2 = null;
            try {
                buf2 = new SingleByteBuff(ByteBuffer.allocate(8));
                in = fs.open(p);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)BlockIOUtils.readWithExtra((ByteBuff)buf2, (FSDataInputStream)in, (int)6, (int)2));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
                buf2.rewind();
                heapBuf = new byte[buf2.capacity()];
                buf2.get(heapBuf, 0, heapBuf.length);
                Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"hello wo"), (byte[])heapBuf);
            }
            catch (Throwable buf2) {
                throwable2 = buf2;
                throw buf2;
            }
            finally {
                if (ignored != null) {
                    if (throwable2 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable buf2) {
                            throwable2.addSuppressed(buf2);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        finally {
            span.end();
        }
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.readWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)8L))))))}));
        this.otelRule.clearSpans();
        span = TraceUtil.createSpan((String)this.testName.getMethodName());
        try {
            ignored = span.makeCurrent();
            throwable2 = null;
            try {
                buf2 = new MultiByteBuff(new ByteBuffer[]{ByteBuffer.allocate(4), ByteBuffer.allocate(4), ByteBuffer.allocate(4)});
                in = fs.open(p);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)BlockIOUtils.readWithExtra((ByteBuff)buf2, (FSDataInputStream)in, (int)8, (int)3));
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
                buf2.rewind();
                heapBuf = new byte[11];
                buf2.get(heapBuf, 0, heapBuf.length);
                Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"hello world"), (byte[])heapBuf);
            }
            catch (Throwable buf3) {
                throwable2 = buf3;
                throw buf3;
            }
            finally {
                if (ignored != null) {
                    if (throwable2 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable buf3) {
                            throwable2.addSuppressed(buf3);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        finally {
            span.end();
        }
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.readWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)11L))))))}));
        this.otelRule.clearSpans();
        span = TraceUtil.createSpan((String)this.testName.getMethodName());
        try {
            ignored = span.makeCurrent();
            throwable2 = null;
            try {
                buf2 = new MultiByteBuff(new ByteBuffer[]{ByteBuffer.allocate(4), ByteBuffer.allocate(4), ByteBuffer.allocate(4)});
                buf2.position(0).limit(12);
                this.exception.expect(IOException.class);
                in = fs.open(p);
                throwable = null;
                try {
                    BlockIOUtils.readWithExtra((ByteBuff)buf2, (FSDataInputStream)in, (int)12, (int)0);
                    Assert.fail((String)"Should only read 11 bytes");
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Throwable throwable9) {
                throwable2 = throwable9;
                throw throwable9;
            }
            finally {
                if (ignored != null) {
                    if (throwable2 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        finally {
            span.end();
        }
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.readWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)11L))))))}));
    }

    @Test
    public void testPositionalReadNoExtra() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)totalLen);
        Mockito.when((Object)in.hasCapability(ArgumentMatchers.anyString())).thenReturn((Object)false);
        boolean ret = (Boolean)TraceUtil.trace(() -> TestBlockIOUtils.lambda$testPositionalReadNoExtra$1((ByteBuff)bb, in, position, necessaryLen, extraLen), (String)this.testName.getMethodName());
        Assert.assertFalse((String)"Expect false return when no extra bytes requested", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).hasCapability(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.preadWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)totalLen))))))}));
    }

    @Test
    public void testPositionalReadShortReadOfNecessaryBytes() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)5);
        Mockito.when((Object)in.read(5L, buf, 5, 5)).thenReturn((Object)5);
        Mockito.when((Object)in.hasCapability(ArgumentMatchers.anyString())).thenReturn((Object)false);
        boolean ret = (Boolean)TraceUtil.trace(() -> TestBlockIOUtils.lambda$testPositionalReadShortReadOfNecessaryBytes$2((ByteBuff)bb, in, position, necessaryLen, extraLen), (String)this.testName.getMethodName());
        Assert.assertFalse((String)"Expect false return when no extra bytes requested", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(5L, buf, 5, 5);
        ((FSDataInputStream)Mockito.verify((Object)in)).hasCapability(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.preadWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)totalLen))))))}));
    }

    @Test
    public void testPositionalReadExtraSucceeded() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)totalLen);
        Mockito.when((Object)in.hasCapability(ArgumentMatchers.anyString())).thenReturn((Object)false);
        boolean ret = (Boolean)TraceUtil.trace(() -> TestBlockIOUtils.lambda$testPositionalReadExtraSucceeded$3((ByteBuff)bb, in, position, necessaryLen, extraLen), (String)this.testName.getMethodName());
        Assert.assertTrue((String)"Expect true return when reading extra bytes succeeds", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).hasCapability(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.preadWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)totalLen))))))}));
    }

    @Test
    public void testPositionalReadExtraFailed() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)necessaryLen);
        Mockito.when((Object)in.hasCapability(ArgumentMatchers.anyString())).thenReturn((Object)false);
        boolean ret = (Boolean)TraceUtil.trace(() -> TestBlockIOUtils.lambda$testPositionalReadExtraFailed$4((ByteBuff)bb, in, position, necessaryLen, extraLen), (String)this.testName.getMethodName());
        Assert.assertFalse((String)"Expect false return when reading extra bytes fails", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).hasCapability(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.preadWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)necessaryLen))))))}));
    }

    @Test
    public void testPositionalReadShortReadCompletesNecessaryAndExtraBytes() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)5);
        Mockito.when((Object)in.read(5L, buf, 5, 10)).thenReturn((Object)10);
        Mockito.when((Object)in.hasCapability(ArgumentMatchers.anyString())).thenReturn((Object)false);
        boolean ret = (Boolean)TraceUtil.trace(() -> TestBlockIOUtils.lambda$testPositionalReadShortReadCompletesNecessaryAndExtraBytes$5((ByteBuff)bb, in, position, necessaryLen, extraLen), (String)this.testName.getMethodName());
        Assert.assertTrue((String)"Expect true return when reading extra bytes succeeds", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(5L, buf, 5, 10);
        ((FSDataInputStream)Mockito.verify((Object)in)).hasCapability(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.preadWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"db.hbase.io.heap_bytes_read", (long)totalLen))))))}));
    }

    @Test
    public void testPositionalReadPrematureEOF() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)9);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)-1);
        Mockito.when((Object)in.hasCapability(ArgumentMatchers.anyString())).thenReturn((Object)false);
        this.exception.expect(IOException.class);
        this.exception.expectMessage("EOF");
        Span span = TraceUtil.createSpan((String)this.testName.getMethodName());
        try (Scope ignored = span.makeCurrent();){
            BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
            span.setStatus(StatusCode.OK);
        }
        catch (IOException e) {
            try {
                TraceUtil.setError((Span)span, (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                span.end();
                TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
                MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.preadWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.isEmpty())))))}));
                throw throwable;
            }
        }
        span.end();
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"BlockIOUtils.preadWithExtra"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.isEmpty())))))}));
    }

    private boolean isByteBufferPositionedReadable() {
        try {
            FSDataInputStream.class.getMethod("read", Long.TYPE, ByteBuffer.class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    @Test
    public void testByteBufferPositionedReadable() throws IOException {
        Assume.assumeTrue((String)"Skip the test because ByteBufferPositionedReadable is not available", (boolean)this.isByteBufferPositionedReadable());
        long position = 0L;
        int necessaryLen = 10;
        int extraLen = 1;
        int totalLen = necessaryLen + extraLen;
        int firstReadLen = 6;
        int secondReadLen = totalLen - firstReadLen;
        ByteBuffer buf = ByteBuffer.allocate(totalLen);
        SingleByteBuff bb = new SingleByteBuff(buf);
        MyFSDataInputStream in = (MyFSDataInputStream)((Object)Mockito.mock(MyFSDataInputStream.class));
        Mockito.when((Object)in.read(position, buf)).thenReturn((Object)firstReadLen);
        Mockito.when((Object)in.read(firstReadLen, buf)).thenReturn((Object)secondReadLen);
        Mockito.when((Object)in.hasCapability(ArgumentMatchers.anyString())).thenReturn((Object)true);
        boolean ret = BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
        Assert.assertTrue((String)"Expect true return when reading extra bytes succeeds", (boolean)ret);
        ((MyFSDataInputStream)((Object)Mockito.verify((Object)((Object)in)))).read(position, buf);
        ((MyFSDataInputStream)((Object)Mockito.verify((Object)((Object)in)))).read(firstReadLen, buf);
        ((MyFSDataInputStream)((Object)Mockito.verify((Object)((Object)in)))).hasCapability(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testByteBufferPositionedReadableEOF() throws IOException {
        Assume.assumeTrue((String)"Skip the test because ByteBufferPositionedReadable is not available", (boolean)this.isByteBufferPositionedReadable());
        long position = 0L;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        int firstReadLen = 9;
        ByteBuffer buf = ByteBuffer.allocate(totalLen);
        SingleByteBuff bb = new SingleByteBuff(buf);
        MyFSDataInputStream in = (MyFSDataInputStream)((Object)Mockito.mock(MyFSDataInputStream.class));
        Mockito.when((Object)in.read(position, buf)).thenReturn((Object)firstReadLen);
        Mockito.when((Object)in.read(position, buf)).thenReturn((Object)-1);
        Mockito.when((Object)in.hasCapability(ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.exception.expect(IOException.class);
        this.exception.expectMessage("EOF");
        BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
        ((MyFSDataInputStream)((Object)Mockito.verify((Object)((Object)in)))).read(position, buf);
        ((MyFSDataInputStream)((Object)Mockito.verify((Object)((Object)in)))).read(firstReadLen, buf);
        ((MyFSDataInputStream)((Object)Mockito.verify((Object)((Object)in)))).hasCapability(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    private static /* synthetic */ Boolean lambda$testPositionalReadShortReadCompletesNecessaryAndExtraBytes$5(ByteBuff bb, FSDataInputStream in, long position, int necessaryLen, int extraLen) throws IOException {
        return BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
    }

    private static /* synthetic */ Boolean lambda$testPositionalReadExtraFailed$4(ByteBuff bb, FSDataInputStream in, long position, int necessaryLen, int extraLen) throws IOException {
        return BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
    }

    private static /* synthetic */ Boolean lambda$testPositionalReadExtraSucceeded$3(ByteBuff bb, FSDataInputStream in, long position, int necessaryLen, int extraLen) throws IOException {
        return BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
    }

    private static /* synthetic */ Boolean lambda$testPositionalReadShortReadOfNecessaryBytes$2(ByteBuff bb, FSDataInputStream in, long position, int necessaryLen, int extraLen) throws IOException {
        return BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
    }

    private static /* synthetic */ Boolean lambda$testPositionalReadNoExtra$1(ByteBuff bb, FSDataInputStream in, long position, int necessaryLen, int extraLen) throws IOException {
        return BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
    }

    public static class MyFSDataInputStream
    extends FSDataInputStream {
        public MyFSDataInputStream(InputStream in) {
            super(in);
        }

        public int read(long position, ByteBuffer buf) throws IOException {
            return 0;
        }
    }
}

