/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRecoveryPersistentBucketCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoveryPersistentBucketCache.class);
    final long capacitySize = 0x2000000L;
    final int writeThreads = 3;
    final int writerQLen = 64;

    @Test
    public void testBucketCacheRecovery() throws Exception {
        HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.bucketcache.persist.intervalinmillis", Long.MAX_VALUE);
        int[] bucketSizes = new int[]{9216};
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, bucketSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
        CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks(8192, 4);
        CacheTestUtils.HFileBlockPair[] smallerBlocks = CacheTestUtils.generateHFileBlocks(4096, 1);
        this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[0].getBlockName(), (Cacheable)blocks[0].getBlock());
        this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[1].getBlockName(), (Cacheable)blocks[1].getBlock());
        this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[2].getBlockName(), (Cacheable)blocks[2].getBlock());
        this.cacheAndWaitUntilFlushedToBucket(bucketCache, blocks[3].getBlockName(), (Cacheable)blocks[3].getBlock());
        bucketCache.persistToFile();
        bucketCache.evictBlock(blocks[3].getBlockName());
        this.cacheAndWaitUntilFlushedToBucket(bucketCache, smallerBlocks[0].getBlockName(), (Cacheable)smallerBlocks[0].getBlock());
        BucketCache newBucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, bucketSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
        Thread.sleep(100L);
        Assert.assertEquals((long)3L, (long)newBucketCache.backingMap.size());
        Assert.assertNull((Object)newBucketCache.getBlock(blocks[3].getBlockName(), false, false, false));
        Assert.assertNull((Object)newBucketCache.getBlock(smallerBlocks[0].getBlockName(), false, false, false));
        Assert.assertEquals((Object)blocks[0].getBlock(), (Object)newBucketCache.getBlock(blocks[0].getBlockName(), false, false, false));
        Assert.assertEquals((Object)blocks[1].getBlock(), (Object)newBucketCache.getBlock(blocks[1].getBlockName(), false, false, false));
        Assert.assertEquals((Object)blocks[2].getBlock(), (Object)newBucketCache.getBlock(blocks[2].getBlockName(), false, false, false));
        TEST_UTIL.cleanupTestDir();
    }

    private void waitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey) throws InterruptedException {
        while (!cache.backingMap.containsKey(cacheKey) || cache.ramCache.containsKey(cacheKey)) {
            Thread.sleep(100L);
        }
    }

    private void cacheAndWaitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey, Cacheable block) throws InterruptedException {
        cache.cacheBlock(cacheKey, block);
        this.waitUntilFlushedToBucket(cache, cacheKey);
    }
}

