/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ipc.CallQueueInfo;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.MasterFifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={RPCTests.class, LargeTests.class})
public class TestMasterFifoRpcScheduler {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterFifoRpcScheduler.class);
    private static final String REGION_SERVER_REPORT = "RegionServerReport";
    private static final String OTHER = "Other";
    private static HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.master.rpc.scheduler.factory.class", "org.apache.hadoop.hbase.regionserver.MasterFifoRpcSchedulerFactory");
        conf.setInt("hbase.regionserver.handler.count", 5);
        conf.setInt("hbase.master.server.report.handler.count", 2);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMasterRpcScheduler() {
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        MasterRpcServices masterRpcServices = master.getMasterRpcServices();
        RpcScheduler masterRpcScheduler = masterRpcServices.getRpcScheduler();
        Assert.assertTrue((boolean)(masterRpcScheduler instanceof MasterFifoRpcScheduler));
    }

    @Test
    public void testCallQueueInfo() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        AtomicInteger callExecutionCount = new AtomicInteger(0);
        MockMasterFifoRpcScheduler scheduler = new MockMasterFifoRpcScheduler(conf, 2, 1);
        scheduler.start();
        int totalCallMethods = 30;
        int unableToDispatch = 0;
        for (int i = totalCallMethods; i > 0; --i) {
            CallRunner task = this.createMockTask(callExecutionCount, i < 20);
            if (!scheduler.dispatch(task)) {
                ++unableToDispatch;
            }
            Thread.sleep(10L);
        }
        CallQueueInfo callQueueInfo = scheduler.getCallQueueInfo();
        int executionCount = callExecutionCount.get();
        String expectedQueueName = "Master Fifo Queue";
        Assert.assertEquals((long)1L, (long)callQueueInfo.getCallQueueNames().size());
        long callQueueSize = 0L;
        for (String queueName : callQueueInfo.getCallQueueNames()) {
            Assert.assertEquals((Object)expectedQueueName, (Object)queueName);
            Set methodNames = callQueueInfo.getCalledMethodNames(queueName);
            if (methodNames.size() == 2) {
                Assert.assertTrue((boolean)methodNames.contains(REGION_SERVER_REPORT));
                Assert.assertTrue((boolean)methodNames.contains(OTHER));
            }
            for (String methodName : callQueueInfo.getCalledMethodNames(queueName)) {
                callQueueSize += callQueueInfo.getCallMethodCount(queueName, methodName);
            }
        }
        Assert.assertEquals((long)(totalCallMethods - unableToDispatch), (long)(callQueueSize + (long)executionCount));
        scheduler.stop();
    }

    private CallRunner createMockTask(final AtomicInteger callExecutionCount, boolean isRegionServerReportTask) {
        CallRunner task = (CallRunner)Mockito.mock(CallRunner.class);
        ServerCall call = (ServerCall)Mockito.mock(ServerCall.class);
        Mockito.when((Object)task.getRpcCall()).thenReturn((Object)call);
        Mockito.when((Object)call.getHeader()).thenReturn((Object)RPCProtos.RequestHeader.newBuilder().setMethodName(isRegionServerReportTask ? REGION_SERVER_REPORT : OTHER).build());
        ((CallRunner)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                callExecutionCount.incrementAndGet();
                Thread.sleep(1000L);
                return null;
            }
        }).when((Object)task)).run();
        return task;
    }

    private static class MockMasterFifoRpcScheduler
    extends MasterFifoRpcScheduler {
        public MockMasterFifoRpcScheduler(Configuration conf, int callHandlerCount, int rsReportHandlerCount) {
            super(conf, callHandlerCount, rsReportHandlerCount);
        }

        protected String getCallMethod(CallRunner task) {
            RpcCall call = task.getRpcCall();
            if (call.getHeader() != null) {
                return call.getHeader().getMethodName();
            }
            return null;
        }
    }
}

