/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RPCTests.class, MediumTests.class})
public class TestRpcSkipInitialSaslHandshake {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcSkipInitialSaslHandshake.class);
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    protected static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    protected static MiniKdc KDC;
    protected static String HOST;
    protected static String PRINCIPAL;
    protected String krbKeytab;
    protected String krbPrincipal;
    protected UserGroupInformation ugi;
    protected Configuration clientConf;
    protected Configuration serverConf;

    protected static void initKDCAndConf() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        HBaseKerberosUtils.setPrincipalForTesting((String)(PRINCIPAL + "@" + KDC.getRealm()));
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.socket.timeout.read", 2000000000);
        TEST_UTIL.getConfiguration().setInt("hbase.security.relogin.maxretries", 1);
    }

    protected static void stopKDC() throws InterruptedException {
        if (KDC != null) {
            KDC.stop();
        }
    }

    protected final void setUpPrincipalAndConf() throws Exception {
        this.krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        this.krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        this.ugi = HBaseKerberosUtils.loginKerberosPrincipal((String)this.krbKeytab, (String)this.krbPrincipal);
        this.clientConf = new Configuration(TEST_UTIL.getConfiguration());
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)this.clientConf);
        this.clientConf.setBoolean("hbase.ipc.client.fallback-to-simple-auth-allowed", true);
        this.serverConf = new Configuration(TEST_UTIL.getConfiguration());
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TestRpcSkipInitialSaslHandshake.initKDCAndConf();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRpcSkipInitialSaslHandshake.stopKDC();
        TEST_UTIL.cleanupTestDir();
    }

    @Before
    public void setUpTest() throws Exception {
        this.setUpPrincipalAndConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipal()).thenReturn((Object)"hbase.regionserver.kerberos.principal");
        SecurityInfo.addInfo((String)"TestProtobufRpcProto", (SecurityInfo)securityInfoMock);
        final AtomicReference<Object> conn = new AtomicReference<Object>(null);
        NettyRpcServer rpcServer = new NettyRpcServer(null, this.getClass().getSimpleName(), Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress(HOST, 0), this.serverConf, (RpcScheduler)new FifoRpcScheduler(this.serverConf, 1), true){

            protected NettyServerRpcConnection createNettyServerRpcConnection(Channel channel) {
                conn.set(super.createNettyServerRpcConnection(channel));
                return (NettyServerRpcConnection)conn.get();
            }
        };
        rpcServer.start();
        try (NettyRpcClient rpcClient = new NettyRpcClient(this.clientConf, HConstants.DEFAULT_CLUSTER_ID.toString(), null, null);){
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub((RpcClient)rpcClient, rpcServer.getListenerAddress(), User.create((UserGroupInformation)UserGroupInformation.getCurrentUser()));
            String response = stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("test").build()).getMessage();
            Assert.assertTrue((boolean)"test".equals(response));
            Assert.assertFalse((boolean)((NettyServerRpcConnection)conn.get()).useSasl);
        }
        finally {
            rpcServer.stop();
        }
    }

    static {
        HOST = "localhost";
    }
}

