/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.ipc.TestNettyRpcServer;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, MediumTests.class})
public class TestSecureNettyRpcServer
extends TestNettyRpcServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecureNettyRpcServer.class);
    private static File KEYTAB_FILE;
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;
    private static UserGroupInformation UGI;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @Override
    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtil();
        KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        String principalName = PRINCIPAL + "@" + KDC.getRealm();
        HBaseKerberosUtils.setPrincipalForTesting((String)principalName);
        Configuration conf = TEST_UTIL.getConfiguration();
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf, (String)principalName, (String)principalName);
        UGI = TestSecureNettyRpcServer.login(KEYTAB_FILE.toString(), principalName);
        super.setup();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (KDC != null) {
            KDC.stop();
        }
        KEYTAB_FILE.delete();
        super.tearDown();
        TEST_UTIL.cleanupTestDir();
    }

    @Override
    @Test
    public void testNettyRpcServer() throws Exception {
        UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestSecureNettyRpcServer.this.doTest(TestSecureNettyRpcServer.this.name.getTableName());
                return null;
            }
        });
    }

    static UserGroupInformation login(String krbKeytab, String krbPrincipal) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.loginUserFromKeytab((String)krbPrincipal, (String)krbKeytab);
        return UserGroupInformation.getLoginUser();
    }

    static {
        HOST = "localhost";
    }
}

