/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.ClientMetaTableAccessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMaster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMaster.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestMaster.class);
    private static final TableName TABLENAME = TableName.valueOf((String)"TestMaster");
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static Admin admin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        TEST_UTIL.getConfiguration().set("hbase.min.version.move.system.tables", "0.0.0");
        TEST_UTIL.startMiniCluster(2);
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private Pair<RegionInfo, ServerName> getTableRegionForRow(HMaster master, final TableName tableName, byte[] rowKey) throws IOException {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        ClientMetaTableAccessor.Visitor visitor = new ClientMetaTableAccessor.Visitor(){

            public boolean visit(Result data) throws IOException {
                if (data == null || data.size() <= 0) {
                    return true;
                }
                Pair pair = new Pair((Object)CatalogFamilyFormat.getRegionInfo((Result)data), (Object)CatalogFamilyFormat.getServerName((Result)data, (int)0));
                if (!((RegionInfo)pair.getFirst()).getTable().equals((Object)tableName)) {
                    return false;
                }
                result.set(pair);
                return true;
            }
        };
        MetaTableAccessor.scanMeta((Connection)master.getConnection(), (ClientMetaTableAccessor.Visitor)visitor, (TableName)tableName, (byte[])rowKey, (int)1);
        return result.get();
    }

    @Test
    public void testMasterOpsWhileSplitting() throws Exception {
        SingleProcessHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try (Table ht = TEST_UTIL.createTable(TABLENAME, FAMILYNAME);){
            Assert.assertTrue((boolean)m.getTableStateManager().isTableState(TABLENAME, new TableState.State[]{TableState.State.ENABLED}));
            TEST_UTIL.loadTable(ht, FAMILYNAME, false);
        }
        List tableRegions = MetaTableAccessor.getTableRegionsAndLocations((Connection)m.getConnection(), (TableName)TABLENAME);
        LOG.info("Regions after load: " + Joiner.on((char)',').join((Iterable)tableRegions));
        Assert.assertEquals((long)1L, (long)tableRegions.size());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])((RegionInfo)((Pair)tableRegions.get(0)).getFirst()).getStartKey());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])((RegionInfo)((Pair)tableRegions.get(0)).getFirst()).getEndKey());
        LOG.info("Splitting table");
        TEST_UTIL.getAdmin().split(TABLENAME);
        LOG.info("Making sure we can call getTableRegions while opening");
        while (tableRegions.size() < 3) {
            tableRegions = MetaTableAccessor.getTableRegionsAndLocations((Connection)m.getConnection(), (TableName)TABLENAME, (boolean)false);
            Thread.sleep(100L);
        }
        LOG.info("Regions: " + Joiner.on((char)',').join((Iterable)tableRegions));
        Assert.assertEquals((long)3L, (long)tableRegions.size());
        LOG.info("Making sure we can call getTableRegionClosest while opening");
        Pair<RegionInfo, ServerName> pair = this.getTableRegionForRow(m, TABLENAME, Bytes.toBytes((String)"cde"));
        LOG.info("Result is: " + pair);
        Pair tableRegionFromName = MetaTableAccessor.getRegion((Connection)m.getConnection(), (byte[])((RegionInfo)pair.getFirst()).getRegionName());
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(tableRegionFromName.getFirst(), pair.getFirst()) == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveRegionWhenNotInitialized() {
        SingleProcessHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try {
            m.setInitialized(false);
            RegionInfo meta = RegionInfoBuilder.FIRST_META_REGIONINFO;
            m.move(meta.getEncodedNameAsBytes(), null);
            Assert.fail((String)"Region should not be moved since master is not initialized");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof PleaseHoldException));
        }
        finally {
            m.setInitialized(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveThrowsUnknownRegionException() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"value")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        admin.createTable(tableDescriptorBuilder.build());
        try {
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"A")).setEndKey(Bytes.toBytes((String)"Z")).build();
            admin.move(hri.getEncodedNameAsBytes());
            Assert.fail((String)"Region should not be moved since it is fake");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof UnknownRegionException));
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveThrowsPleaseHoldException() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"value")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        admin.createTable(tableDescriptorBuilder.build());
        try {
            List tableRegions = admin.getRegions(tableName);
            master.setInitialized(false);
            admin.move(((RegionInfo)tableRegions.get(0)).getEncodedNameAsBytes());
            Assert.fail((String)"Region should not be moved since master is not initialized");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)StringUtils.stringifyException((Throwable)ioe).contains("PleaseHoldException"));
        }
        finally {
            master.setInitialized(true);
            TEST_UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testFlushedSequenceIdPersistLoad() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        int msgInterval = conf.getInt("hbase.regionserver.msginterval", 100);
        TableName tableName = TableName.valueOf((String)"testFlushSeqId");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"cf"))).build();
        Table table = TEST_UTIL.createTable(tableDescriptor, (byte[][])null);
        TEST_UTIL.flush(TableName.META_TABLE_NAME);
        Threads.sleep((long)(msgInterval * 2));
        ConcurrentNavigableMap regionMapBefore = TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getFlushedSequenceIdByRegion();
        TEST_UTIL.getMiniHBaseCluster().shutdown();
        TEST_UTIL.restartHBaseCluster(2);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        ConcurrentNavigableMap regionMapAfter = TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getFlushedSequenceIdByRegion();
        Assert.assertTrue((boolean)regionMapBefore.equals(regionMapAfter));
    }

    @Test
    public void testBlockingHbkc1WithLockFile() throws IOException {
        Path hbckLockPath = new Path(HBaseFsck.getTmpDir((Configuration)TEST_UTIL.getConfiguration()), "hbase-hbck.lock");
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Assert.assertTrue((boolean)fs.exists(hbckLockPath));
        TEST_UTIL.getMiniHBaseCluster().killMaster(TEST_UTIL.getMiniHBaseCluster().getMaster().getServerName());
        Assert.assertTrue((boolean)fs.exists(hbckLockPath));
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getMiniHBaseCluster().getMaster() != null && TEST_UTIL.getMiniHBaseCluster().getMaster().isInitialized());
        Assert.assertTrue((boolean)fs.exists(hbckLockPath));
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        Assert.assertTrue((boolean)fs.exists(hbckLockPath));
        fs.delete(hbckLockPath, true);
        Assert.assertFalse((boolean)fs.exists(hbckLockPath));
        TEST_UTIL.getMiniHBaseCluster().getLiveMasterThreads().stream().map(sn -> sn.getMaster().getServerName()).forEach(sn -> {
            try {
                TEST_UTIL.getMiniHBaseCluster().killMaster((ServerName)sn);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getMiniHBaseCluster().getMaster() != null && TEST_UTIL.getMiniHBaseCluster().getMaster().isInitialized());
        Assert.assertTrue((boolean)fs.exists(hbckLockPath));
    }

    @Test
    public void testInstallShutdownHook() throws IOException {
        Assert.assertTrue((boolean)TEST_UTIL.getHBaseCluster().getMaster().isShutdownHookInstalled());
    }
}

