/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionServerList;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReportRegionStateTransitionFromDeadServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReportRegionStateTransitionFromDeadServer.class);
    private static final List<ServerName> EXCLUDE_SERVERS = new ArrayList<ServerName>();
    private static CountDownLatch ARRIVE_GET_REGIONS;
    private static CountDownLatch RESUME_GET_REGIONS;
    private static CountDownLatch ARRIVE_REPORT;
    private static CountDownLatch RESUME_REPORT;
    private static final HBaseTestingUtil UTIL;
    private static TableName NAME;
    private static byte[] CF;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 1000);
        UTIL.startMiniCluster(3);
        UTIL.getAdmin().balancerSwitch(false, true);
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws HBaseIOException, InterruptedException, ExecutionException {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        RegionStateNode rsn = am.getRegionStates().getRegionStateNode(region);
        HRegionServer rs0 = UTIL.getMiniHBaseCluster().getRegionServer(rsn.getRegionLocation());
        HRegionServer rs1 = UTIL.getOtherRegionServer(rs0);
        HRegionServer rs2 = UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).filter(rs -> rs != rs0 && rs != rs1).findAny().get();
        RESUME_REPORT = new CountDownLatch(1);
        ARRIVE_REPORT = new CountDownLatch(1);
        Future future = am.moveAsync(new RegionPlan(region, rs0.getServerName(), rs1.getServerName()));
        ARRIVE_REPORT.await();
        RESUME_GET_REGIONS = new CountDownLatch(1);
        ARRIVE_GET_REGIONS = new CountDownLatch(1);
        rs0.abort("For testing!");
        ARRIVE_GET_REGIONS.await();
        RESUME_REPORT.countDown();
        try {
            future.get(15L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        EXCLUDE_SERVERS.add(rs1.getServerName());
        RESUME_GET_REGIONS.countDown();
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getActiveProcIds().isEmpty());
        boolean onRS1 = !rs1.getRegions(NAME).isEmpty();
        boolean onRS2 = !rs2.getRegions(NAME).isEmpty();
        Assert.assertNotEquals((String)("should either be on rs1 or rs2, but onRS1 is " + onRS1 + " and on RS2 is " + onRS2), (Object)onRS1, (Object)onRS2);
    }

    static {
        UTIL = new HBaseTestingUtil();
        NAME = TableName.valueOf((String)"Report");
        CF = Bytes.toBytes((String)"cf");
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master, MasterRegion masterRegion) {
            return new AssignmentManagerForTest(master, masterRegion);
        }

        protected ServerManager createServerManager(MasterServices master, RegionServerList storage) throws IOException {
            this.setupClusterConnection();
            return new ServerManagerForTest(master, storage);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master, MasterRegion masterRegion) {
            super(master, masterRegion);
        }

        public List<RegionInfo> getRegionsOnServer(ServerName serverName) {
            List regions = super.getRegionsOnServer(serverName);
            if (ARRIVE_GET_REGIONS != null) {
                ARRIVE_GET_REGIONS.countDown();
                try {
                    RESUME_GET_REGIONS.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return regions;
        }

        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
            if (ARRIVE_REPORT != null && req.getTransitionList().stream().allMatch(t -> !ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)t.getRegionInfo(0)).isMetaRegion())) {
                ARRIVE_REPORT.countDown();
                try {
                    RESUME_REPORT.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.reportRegionStateTransition(req);
        }
    }

    private static final class ServerManagerForTest
    extends ServerManager {
        public ServerManagerForTest(MasterServices master, RegionServerList storage) {
            super(master, storage);
        }

        public List<ServerName> createDestinationServersList() {
            return super.createDestinationServersList(EXCLUDE_SERVERS);
        }
    }
}

