/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.ClusterInfoProvider;
import org.apache.hadoop.hbase.master.balancer.MasterClusterInfoProvider;
import org.apache.hadoop.hbase.master.balancer.StochasticBalancerTestBase;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestBalancerDecision
extends StochasticBalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBalancerDecision.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBalancerDecisions() {
        conf.setBoolean("hbase.master.balancer.decision.buffer.enabled", true);
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        MasterClusterInfoProvider provider = new MasterClusterInfoProvider(services);
        loadBalancer.setClusterInfoProvider((ClusterInfoProvider)provider);
        loadBalancer.onConfigurationChange(conf);
        float minCost = conf.getFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 0.05f);
        float slop = conf.getFloat("hbase.regions.slop", 0.2f);
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 1.0f);
        conf.setFloat("hbase.regions.slop", -1.0f);
        try {
            boolean[] perTableBalancerConfigs;
            for (boolean isByTable : perTableBalancerConfigs = new boolean[]{true, false}) {
                conf.setBoolean("hbase.master.loadbalance.bytable", isByTable);
                loadBalancer.onConfigurationChange(conf);
                for (int[] mockCluster : this.clusterStateMocks) {
                    TreeMap servers = this.mockClusterServers(mockCluster);
                    HashMap LoadOfAllTable = this.mockClusterServersWithTables(servers);
                    List plans = loadBalancer.balanceCluster((Map)LoadOfAllTable);
                    boolean emptyPlans = plans == null || plans.isEmpty();
                    Assert.assertTrue((emptyPlans || TestBalancerDecision.needsBalanceIdleRegion(mockCluster) ? 1 : 0) != 0);
                }
            }
            NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
            namedQueueGetRequest.setNamedQueueEvent(1);
            namedQueueGetRequest.setBalancerDecisionsRequest(MasterProtos.BalancerDecisionsRequest.getDefaultInstance());
            NamedQueueGetResponse namedQueueGetResponse = provider.getNamedQueueRecorder().getNamedQueueRecords(namedQueueGetRequest);
            List balancerDecisions = namedQueueGetResponse.getBalancerDecisions();
            MasterProtos.BalancerDecisionsResponse response = MasterProtos.BalancerDecisionsResponse.newBuilder().addAllBalancerDecision((Iterable)balancerDecisions).build();
            List balancerDecisionRecords = ProtobufUtil.getBalancerDecisionEntries((MasterProtos.BalancerDecisionsResponse)response);
            Assert.assertTrue((balancerDecisionRecords.size() > 160 ? 1 : 0) != 0);
        }
        finally {
            conf.unset("hbase.master.loadbalance.bytable");
            conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", minCost);
            conf.setFloat("hbase.regions.slop", slop);
            loadBalancer.onConfigurationChange(conf);
        }
    }

    private static boolean needsBalanceIdleRegion(int[] cluster) {
        return Arrays.stream(cluster).anyMatch(x -> x > 1) && Arrays.stream(cluster).anyMatch(x -> x < 1);
    }
}

