/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.ClusterInfoProvider;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.MasterClusterInfoProvider;
import org.apache.hadoop.hbase.master.balancer.StochasticBalancerTestBase;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestBalancerRejection
extends StochasticBalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBalancerRejection.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBalancerRejections() throws Exception {
        try {
            conf.setBoolean("hbase.master.balancer.rejection.buffer.enabled", true);
            conf.set("hbase.master.balancer.stochastic.additionalCostFunctions", MockCostFunction.class.getName());
            MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
            Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
            MasterClusterInfoProvider provider = new MasterClusterInfoProvider(services);
            loadBalancer.setClusterInfoProvider((ClusterInfoProvider)provider);
            loadBalancer.onConfigurationChange(conf);
            TreeMap servers = this.mockClusterServers(new int[]{5, 5});
            HashMap LoadOfAllTable = this.mockClusterServersWithTables(servers);
            MockCostFunction.mockCost = -1.7976931348623157E308;
            Assert.assertNull((Object)loadBalancer.balanceCluster((Map)LoadOfAllTable));
            MockCostFunction.mockCost = 1.0;
            conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", Float.MAX_VALUE);
            loadBalancer.onConfigurationChange(conf);
            Assert.assertNull((Object)loadBalancer.balanceCluster((Map)LoadOfAllTable));
            int maxWaitingCount = 10;
            while (maxWaitingCount-- > 0 && this.getBalancerRejectionLogEntries(provider).size() != 2) {
                Thread.sleep(1000L);
            }
            List<LogEntry> logEntries = this.getBalancerRejectionLogEntries(provider);
            Assert.assertEquals((long)2L, (long)logEntries.size());
            Assert.assertTrue((boolean)logEntries.get(0).toJsonPrettyPrint().contains("minCostNeedBalance"));
            Assert.assertTrue((boolean)logEntries.get(1).toJsonPrettyPrint().contains("cost1*multiplier1"));
        }
        finally {
            conf.unset("hbase.master.balancer.stochastic.additionalCostFunctions");
            conf.unset("hbase.master.balancer.rejection.buffer.enabled");
            loadBalancer.onConfigurationChange(conf);
        }
    }

    private List<LogEntry> getBalancerRejectionLogEntries(MasterClusterInfoProvider provider) {
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(2);
        namedQueueGetRequest.setBalancerRejectionsRequest(MasterProtos.BalancerRejectionsRequest.getDefaultInstance());
        NamedQueueGetResponse namedQueueGetResponse = provider.getNamedQueueRecorder().getNamedQueueRecords(namedQueueGetRequest);
        List balancerRejections = namedQueueGetResponse.getBalancerRejections();
        MasterProtos.BalancerRejectionsResponse response = MasterProtos.BalancerRejectionsResponse.newBuilder().addAllBalancerRejection((Iterable)balancerRejections).build();
        List balancerRejectionRecords = ProtobufUtil.getBalancerRejectionEntries((MasterProtos.BalancerRejectionsResponse)response);
        return balancerRejectionRecords;
    }

    static class MockCostFunction
    extends CostFunction {
        public static double mockCost;

        public MockCostFunction(Configuration c) {
        }

        protected double cost() {
            return mockCost;
        }

        float getMultiplier() {
            return 1.0f;
        }
    }
}

