/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.cleaner.DirScanPool;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestHFileLinkCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileLinkCleaner.class);
    private Configuration conf;
    private Path rootDir;
    private FileSystem fs;
    private TableName tableName;
    private TableName tableLinkName;
    private String hfileName;
    private String familyName;
    private RegionInfo hri;
    private RegionInfo hriLink;
    private Path archiveDir;
    private Path archiveStoreDir;
    private Path familyPath;
    private Path hfilePath;
    private Path familyLinkPath;
    private String hfileLinkName;
    private Path linkBackRefDir;
    private Path linkBackRef;
    private FileStatus[] backRefs;
    private HFileCleaner cleaner;
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static DirScanPool POOL;
    private static final long TTL = 1000L;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() {
        POOL = DirScanPool.getHFileCleanerScanPool((Configuration)TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() {
        POOL.shutdownNow();
    }

    @Before
    public void configureDirectoriesAndLinks() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)TEST_UTIL.getDataTestDir());
        this.conf.set("hbase.master.hfilecleaner.plugins", HFileLinkCleaner.class.getName());
        this.rootDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        this.fs = FileSystem.get((Configuration)this.conf);
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        this.tableLinkName = TableName.valueOf((String)(this.name.getMethodName() + "-link"));
        this.hfileName = "1234567890";
        this.familyName = "cf";
        this.hri = RegionInfoBuilder.newBuilder((TableName)this.tableName).build();
        this.hriLink = RegionInfoBuilder.newBuilder((TableName)this.tableLinkName).build();
        this.archiveDir = HFileArchiveUtil.getArchivePath((Configuration)this.conf);
        this.archiveStoreDir = HFileArchiveUtil.getStoreArchivePath((Configuration)this.conf, (TableName)this.tableName, (String)this.hri.getEncodedName(), (String)this.familyName);
        this.familyPath = TestHFileLinkCleaner.getFamilyDirPath(this.archiveDir, this.tableName, this.hri.getEncodedName(), this.familyName);
        this.fs.mkdirs(this.familyPath);
        this.hfilePath = new Path(this.familyPath, this.hfileName);
        this.fs.createNewFile(this.hfilePath);
        this.createLink(true);
        this.conf.setLong("hbase.master.hfilecleaner.ttl", 1000L);
        DummyServer server = new DummyServer();
        this.cleaner = new HFileCleaner(1000, (Stoppable)server, this.conf, this.fs, this.archiveDir, POOL);
    }

    private void createLink(boolean createBackReference) throws IOException {
        this.familyLinkPath = TestHFileLinkCleaner.getFamilyDirPath(this.rootDir, this.tableLinkName, this.hriLink.getEncodedName(), this.familyName);
        this.fs.mkdirs(this.familyLinkPath);
        this.hfileLinkName = HFileLink.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.familyLinkPath, (RegionInfo)this.hri, (String)this.hfileName, (boolean)createBackReference);
        this.linkBackRefDir = HFileLink.getBackReferencesDir((Path)this.archiveStoreDir, (String)this.hfileName);
        Assert.assertTrue((boolean)this.fs.exists(this.linkBackRefDir));
        this.backRefs = this.fs.listStatus(this.linkBackRefDir);
        Assert.assertEquals((long)1L, (long)this.backRefs.length);
        this.linkBackRef = this.backRefs[0].getPath();
    }

    @After
    public void cleanup() throws IOException, InterruptedException {
        Thread.sleep(2000L);
        this.cleaner.chore();
        Assert.assertFalse((String)"HFile should be deleted", (boolean)this.fs.exists(this.hfilePath));
        for (int i = 0; i < 4; ++i) {
            Thread.sleep(2000L);
            this.cleaner.chore();
        }
        Assert.assertFalse((String)"HFile should be deleted", (boolean)this.fs.exists(CommonFSUtils.getTableDir((Path)this.archiveDir, (TableName)this.tableName)));
        Assert.assertFalse((String)"Link should be deleted", (boolean)this.fs.exists(CommonFSUtils.getTableDir((Path)this.archiveDir, (TableName)this.tableLinkName)));
    }

    @Test
    public void testHFileLinkCleaning() throws Exception {
        this.cleaner.chore();
        Assert.assertTrue((boolean)this.fs.exists(this.linkBackRef));
        Assert.assertTrue((boolean)this.fs.exists(this.hfilePath));
        this.fs.rename(CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)this.tableLinkName), CommonFSUtils.getTableDir((Path)this.archiveDir, (TableName)this.tableLinkName));
        this.cleaner.chore();
        Assert.assertFalse((String)"Link should be deleted", (boolean)this.fs.exists(this.linkBackRef));
    }

    @Test
    public void testHFileLinkByRemovingReference() throws Exception {
        this.cleaner.chore();
        Assert.assertTrue((boolean)this.fs.exists(this.linkBackRef));
        Assert.assertTrue((boolean)this.fs.exists(this.hfilePath));
        this.fs.delete(new Path(this.familyLinkPath, this.hfileLinkName), false);
        this.cleaner.chore();
        Assert.assertFalse((String)"Link should be deleted", (boolean)this.fs.exists(this.linkBackRef));
    }

    @Test
    public void testHFileLinkEmptyBackReferenceDirectory() throws Exception {
        this.fs.delete(this.linkBackRef, false);
        Assert.assertTrue((String)"back reference directory still exists", (boolean)this.fs.exists(this.linkBackRefDir));
        this.cleaner.chore();
        Assert.assertFalse((String)"back reference directory should be deleted", (boolean)this.fs.exists(this.linkBackRefDir));
    }

    private static Path getFamilyDirPath(Path rootDir, TableName table, String region, String family) {
        return new Path(new Path(CommonFSUtils.getTableDir((Path)rootDir, (TableName)table), region), family);
    }

    static class DummyServer
    extends MockServer {
        DummyServer() {
        }

        @Override
        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        @Override
        public ZKWatcher getZooKeeper() {
            try {
                return new ZKWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

