/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TestMasterProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;

public class MasterProcedureSchedulerPerformanceEvaluation
extends AbstractHBaseTool {
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    public static final int DEFAULT_NUM_TABLES = 5;
    public static final Option NUM_TABLES_OPTION = new Option("num_table", true, "Number of tables to use for table operations. Default: 5");
    public static final int DEFAULT_REGIONS_PER_TABLE = 10;
    public static final Option REGIONS_PER_TABLE_OPTION = new Option("regions_per_table", true, "Total number of regions per table. Default: 10");
    public static final int DEFAULT_NUM_OPERATIONS = 10000000;
    public static final Option NUM_OPERATIONS_OPTION = new Option("num_ops", true, "Total number of operations to schedule. Default: 10000000");
    public static final int DEFAULT_NUM_THREADS = 10;
    public static final Option NUM_THREADS_OPTION = new Option("threads", true, "Number of procedure executor threads. Default: 10");
    public static final String DEFAULT_OPS_TYPE = "both";
    public static final Option OPS_TYPE_OPTION = new Option("ops_type", true, "Type of operations to run. Value can be table/region/both. In case of 'both', proportion of table:region ops is 1:regions_per_table. Default: both");
    private int numTables = 5;
    private int regionsPerTable = 10;
    private int numOps = 10000000;
    private int numThreads = 10;
    private String opsType = "both";
    private MasterProcedureScheduler procedureScheduler;
    ProcedureFactory[] ops;
    private final AtomicLong procIds = new AtomicLong(0L);
    private final AtomicLong yield = new AtomicLong(0L);
    private final AtomicLong completed = new AtomicLong(0L);

    private void setupOperations() throws Exception {
        Object[] tableOps = new ProcedureFactory[this.numTables];
        for (int i = 0; i < this.numTables; ++i) {
            tableOps[i] = new TableProcedureFactory(TableName.valueOf((String)("testTableLock-" + i)));
        }
        Object[] regionOps = new ProcedureFactory[this.numTables * this.regionsPerTable];
        for (int i = 0; i < this.numTables; ++i) {
            for (int j = 0; j < this.regionsPerTable; ++j) {
                regionOps[i * this.regionsPerTable + j] = new RegionProcedureFactory(RegionInfoBuilder.newBuilder((TableName)((TableProcedureFactory)tableOps[i]).tableName).setStartKey(Bytes.toBytes((int)j)).setEndKey(Bytes.toBytes((int)(j + 1))).build());
            }
        }
        if (this.opsType.equals("table")) {
            System.out.println("Operations: table only");
            this.ops = tableOps;
        } else if (this.opsType.equals("region")) {
            System.out.println("Operations: region only");
            this.ops = regionOps;
        } else if (this.opsType.equals(DEFAULT_OPS_TYPE)) {
            System.out.println("Operations: both (table + region)");
            this.ops = (ProcedureFactory[])ArrayUtils.addAll((Object[])tableOps, (Object[])regionOps);
        } else {
            throw new Exception("-ops_type should be one of table/region/both.");
        }
    }

    protected void addOptions() {
        this.addOption(NUM_TABLES_OPTION);
        this.addOption(REGIONS_PER_TABLE_OPTION);
        this.addOption(NUM_OPERATIONS_OPTION);
        this.addOption(NUM_THREADS_OPTION);
        this.addOption(OPS_TYPE_OPTION);
    }

    protected void processOptions(CommandLine cmd) {
        this.numTables = this.getOptionAsInt(cmd, NUM_TABLES_OPTION.getOpt(), 5);
        this.regionsPerTable = this.getOptionAsInt(cmd, REGIONS_PER_TABLE_OPTION.getOpt(), 10);
        this.numOps = this.getOptionAsInt(cmd, NUM_OPERATIONS_OPTION.getOpt(), 10000000);
        this.numThreads = this.getOptionAsInt(cmd, NUM_THREADS_OPTION.getOpt(), 10);
        this.opsType = cmd.getOptionValue(OPS_TYPE_OPTION.getOpt(), DEFAULT_OPS_TYPE);
    }

    long runThreads(Thread[] threads) throws Exception {
        long startTime = EnvironmentEdgeManager.currentTime();
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        return EnvironmentEdgeManager.currentTime() - startTime;
    }

    protected int doWork() throws Exception {
        this.procedureScheduler = new MasterProcedureScheduler(pid -> null);
        this.procedureScheduler.start();
        this.setupOperations();
        Thread[] threads = new Thread[this.numThreads];
        for (int i = 0; i < this.numThreads; ++i) {
            threads[i] = new AddProcsWorker();
        }
        long addBackTime = this.runThreads(threads);
        System.out.println("Added " + this.numOps + " procedures to scheduler.");
        for (int i = 0; i < this.numThreads; ++i) {
            threads[i] = new PollAndLockWorker();
        }
        long pollTime = this.runThreads(threads);
        this.procedureScheduler.stop();
        float pollTimeSec = (float)pollTime / 1000.0f;
        float addBackTimeSec = (float)addBackTime / 1000.0f;
        System.out.println("******************************************");
        System.out.println("Time - addBack     : " + StringUtils.humanTimeDiff((long)addBackTime));
        System.out.println("Ops/sec - addBack  : " + StringUtils.humanSize((double)((float)this.numOps / addBackTimeSec)));
        System.out.println("Time - poll        : " + StringUtils.humanTimeDiff((long)pollTime));
        System.out.println("Ops/sec - poll     : " + StringUtils.humanSize((double)((float)this.numOps / pollTimeSec)));
        System.out.println("Num Operations     : " + this.numOps);
        System.out.println();
        System.out.println("Completed          : " + this.completed.get());
        System.out.println("Yield              : " + this.yield.get());
        System.out.println();
        System.out.println("Num Tables         : " + this.numTables);
        System.out.println("Regions per table  : " + this.regionsPerTable);
        System.out.println("Operations type    : " + this.opsType);
        System.out.println("Threads            : " + this.numThreads);
        System.out.println("******************************************");
        System.out.println("Raw format for scripts");
        System.out.println(String.format("RESULT [%s=%s, %s=%s, %s=%s, %s=%s, %s=%s, num_yield=%s, time_addback_ms=%s, time_poll_ms=%s]", NUM_OPERATIONS_OPTION.getOpt(), this.numOps, OPS_TYPE_OPTION.getOpt(), this.opsType, NUM_TABLES_OPTION.getOpt(), this.numTables, REGIONS_PER_TABLE_OPTION.getOpt(), this.regionsPerTable, NUM_THREADS_OPTION.getOpt(), this.numThreads, this.yield.get(), addBackTime, pollTime));
        return 0;
    }

    public static void main(String[] args) throws IOException {
        MasterProcedureSchedulerPerformanceEvaluation tool = new MasterProcedureSchedulerPerformanceEvaluation();
        tool.setConf(UTIL.getConfiguration());
        tool.run(args);
    }

    private class PollAndLockWorker
    extends Thread {
        private PollAndLockWorker() {
        }

        @Override
        public void run() {
            while (MasterProcedureSchedulerPerformanceEvaluation.this.completed.get() < (long)MasterProcedureSchedulerPerformanceEvaluation.this.numOps) {
                ProcedureTestingUtility.TestProcedure proc = (ProcedureTestingUtility.TestProcedure)MasterProcedureSchedulerPerformanceEvaluation.this.procedureScheduler.poll(1000L);
                if (proc == null) {
                    MasterProcedureSchedulerPerformanceEvaluation.this.yield.incrementAndGet();
                    continue;
                }
                switch (proc.acquireLock(null)) {
                    case LOCK_ACQUIRED: {
                        MasterProcedureSchedulerPerformanceEvaluation.this.completed.incrementAndGet();
                        proc.releaseLock(null);
                        break;
                    }
                    case LOCK_YIELD_WAIT: {
                        break;
                    }
                }
                if (MasterProcedureSchedulerPerformanceEvaluation.this.completed.get() % 100000L != 0L) continue;
                System.out.println("Completed " + MasterProcedureSchedulerPerformanceEvaluation.this.completed.get() + " procedures.");
            }
        }
    }

    private class AddProcsWorker
    extends Thread {
        private AddProcsWorker() {
        }

        @Override
        public void run() {
            long procId = MasterProcedureSchedulerPerformanceEvaluation.this.procIds.incrementAndGet();
            while (procId <= (long)MasterProcedureSchedulerPerformanceEvaluation.this.numOps) {
                int index = ThreadLocalRandom.current().nextInt(MasterProcedureSchedulerPerformanceEvaluation.this.ops.length);
                MasterProcedureSchedulerPerformanceEvaluation.this.procedureScheduler.addBack(MasterProcedureSchedulerPerformanceEvaluation.this.ops[index].newProcedure(procId));
                procId = MasterProcedureSchedulerPerformanceEvaluation.this.procIds.incrementAndGet();
            }
        }
    }

    private class TableProcedureFactory
    implements ProcedureFactory {
        final TableName tableName;

        TableProcedureFactory(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public Procedure newProcedure(long procId) {
            return new TableProcedure(procId, this.tableName);
        }
    }

    private class TableProcedure
    extends TestMasterProcedureScheduler.TestTableProcedure {
        TableProcedure(long procId, TableName tableName) {
            super(procId, tableName, TableProcedureInterface.TableOperationType.EDIT);
        }

        public Procedure.LockState acquireLock(Void env) {
            return MasterProcedureSchedulerPerformanceEvaluation.this.procedureScheduler.waitTableExclusiveLock((Procedure)this, this.getTableName()) ? Procedure.LockState.LOCK_EVENT_WAIT : Procedure.LockState.LOCK_ACQUIRED;
        }

        public void releaseLock(Void env) {
            MasterProcedureSchedulerPerformanceEvaluation.this.procedureScheduler.wakeTableExclusiveLock((Procedure)this, this.getTableName());
        }
    }

    private class RegionProcedureFactory
    implements ProcedureFactory {
        final RegionInfo hri;

        RegionProcedureFactory(RegionInfo hri) {
            this.hri = hri;
        }

        @Override
        public Procedure newProcedure(long procId) {
            return new RegionProcedure(procId, this.hri);
        }
    }

    private class RegionProcedure
    extends TestMasterProcedureScheduler.TestRegionProcedure {
        RegionProcedure(long procId, RegionInfo hri) {
            super(procId, hri.getTable(), TableProcedureInterface.TableOperationType.REGION_UNASSIGN, hri);
        }

        public Procedure.LockState acquireLock(Void env) {
            return MasterProcedureSchedulerPerformanceEvaluation.this.procedureScheduler.waitRegions((Procedure)this, this.getTableName(), this.getRegionInfo()) ? Procedure.LockState.LOCK_EVENT_WAIT : Procedure.LockState.LOCK_ACQUIRED;
        }

        public void releaseLock(Void env) {
            MasterProcedureSchedulerPerformanceEvaluation.this.procedureScheduler.wakeRegions((Procedure)this, this.getTableName(), this.getRegionInfo());
        }
    }

    private static interface ProcedureFactory {
        public Procedure newProcedure(long var1);
    }
}

