/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.ConcurrentTableModificationException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.NonceKey;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestModifyTableProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestModifyTableProcedure.class);
    @Rule
    public TestName name = new TestName();
    private static final String column_Family1 = "cf1";
    private static final String column_Family2 = "cf2";
    private static final String column_Family3 = "cf3";

    @Test
    public void testModifyTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf");
        UTIL.getAdmin().disableTable(tableName);
        TableDescriptor htd = UTIL.getAdmin().getDescriptor(tableName);
        long newMaxFileSize = htd.getMaxFileSize() * 2L;
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setMaxFileSize(newMaxFileSize).setRegionReplication(3).build();
        long procId1 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId1));
        TableDescriptor currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((long)newMaxFileSize, (long)currentHtd.getMaxFileSize());
        boolean newReadOnlyOption = !htd.isReadOnly();
        long newMemStoreFlushSize = htd.getMemStoreFlushSize() * 2L;
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setReadOnly(newReadOnlyOption).setMemStoreFlushSize(newMemStoreFlushSize).build();
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((Object)newReadOnlyOption, (Object)currentHtd.isReadOnly());
        Assert.assertEquals((long)newMemStoreFlushSize, (long)currentHtd.getMemStoreFlushSize());
    }

    @Test
    public void testModifyTableAddCF() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1);
        TableDescriptor currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((long)1L, (long)currentHtd.getColumnFamilyNames().size());
        String cf2 = column_Family2;
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)UTIL.getAdmin().getDescriptor(tableName));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)cf2)).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableDescriptorBuilder.build()));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((long)2L, (long)currentHtd.getColumnFamilyNames().size());
        Assert.assertTrue((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)cf2)));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        String cf3 = column_Family3;
        tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)UTIL.getAdmin().getDescriptor(tableName));
        columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)cf3)).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableDescriptorBuilder.build()));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertTrue((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)cf3)));
        Assert.assertEquals((long)3L, (long)currentHtd.getColumnFamilyNames().size());
    }

    @Test
    public void testModifyTableDeleteCF() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf1 = column_Family1;
        String cf2 = column_Family2;
        String cf3 = column_Family3;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1, column_Family2, column_Family3);
        TableDescriptor currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((long)3L, (long)currentHtd.getColumnFamilyNames().size());
        TableDescriptor htd = UTIL.getAdmin().getDescriptor(tableName);
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).removeColumnFamily(Bytes.toBytes((String)column_Family2)).build();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((long)2L, (long)currentHtd.getColumnFamilyNames().size());
        Assert.assertFalse((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family2)));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        TableDescriptor htd2 = UTIL.getAdmin().getDescriptor(tableName);
        htd2 = TableDescriptorBuilder.newBuilder((TableDescriptor)htd2).removeColumnFamily(Bytes.toBytes((String)column_Family3)).setValue("hbase.table.sanity.checks", Boolean.FALSE.toString()).build();
        long procId2 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd2));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId2));
        currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((long)1L, (long)currentHtd.getColumnFamilyNames().size());
        Assert.assertFalse((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family3)));
        TableDescriptor htd3 = UTIL.getAdmin().getDescriptor(tableName);
        htd3 = TableDescriptorBuilder.newBuilder((TableDescriptor)htd3).removeColumnFamily(Bytes.toBytes((String)column_Family1)).build();
        long procId3 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd3));
        Procedure result = procExec.getResult(procId3);
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        Throwable cause = ProcedureTestingUtility.getExceptionCause((Procedure)result);
        Assert.assertTrue((String)("expected DoNotRetryIOException, got " + cause), (boolean)(cause instanceof DoNotRetryIOException));
        Assert.assertEquals((long)1L, (long)currentHtd.getColumnFamilyNames().size());
        Assert.assertTrue((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family1)));
    }

    @Test
    public void testRecoveryAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf2 = column_Family2;
        String cf3 = column_Family3;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1, column_Family3);
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptor oldDescriptor = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor newDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)oldDescriptor).setCompactionEnabled(!oldDescriptor.isCompactionEnabled()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)column_Family2)).removeColumnFamily(Bytes.toBytes((String)column_Family3)).setRegionReplication(3).build();
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), newDescriptor));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        TableDescriptor currentDescriptor = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((Object)newDescriptor.isCompactionEnabled(), (Object)currentDescriptor.isCompactionEnabled());
        Assert.assertEquals((long)2L, (long)newDescriptor.getColumnFamilyNames().size());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, false, column_Family1, column_Family2);
    }

    @Test
    public void testRecoveryAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf2 = column_Family2;
        String cf3 = column_Family3;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1, column_Family3);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)UTIL.getAdmin().getDescriptor(tableName));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)column_Family2)).build();
        boolean newCompactionEnableOption = !tableDescriptorBuilder.build().isCompactionEnabled();
        tableDescriptorBuilder.setCompactionEnabled(newCompactionEnableOption);
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        tableDescriptorBuilder.removeColumnFamily(Bytes.toBytes((String)column_Family3));
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableDescriptorBuilder.build()));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        TableDescriptor currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((Object)newCompactionEnableOption, (Object)currentHtd.isCompactionEnabled());
        Assert.assertEquals((long)2L, (long)currentHtd.getColumnFamilyNames().size());
        Assert.assertTrue((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family2)));
        Assert.assertFalse((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family3)));
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, column_Family1, column_Family2);
    }

    @Test
    public void testColumnFamilyAdditionTwiceWithNonce() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String cf2 = column_Family2;
        String cf3 = column_Family3;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1, column_Family3);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptor td = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setCompactionEnabled(!td.isCompactionEnabled()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)column_Family2)).build();
        PerClientRandomNonceGenerator nonceGenerator = PerClientRandomNonceGenerator.get();
        final long nonceGroup = nonceGenerator.getNonceGroup();
        final long newNonce = nonceGenerator.newNonce();
        NonceKey nonceKey = new NonceKey(nonceGroup, newNonce);
        procExec.registerNonce(nonceKey);
        final long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), newTd), nonceKey);
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, new MasterProcedureTestingUtility.StepHook(){

            @Override
            public boolean execute(int step) throws IOException {
                if (step == 3) {
                    return procId == TestTableDDLProcedureBase.UTIL.getHBaseCluster().getMaster().addColumn(tableName, ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)TestModifyTableProcedure.column_Family2)).build(), nonceGroup, newNonce);
                }
                return true;
            }
        });
        try {
            UTIL.getHBaseCluster().getMaster().addColumn(tableName, ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)column_Family2)).build(), nonceGroup, nonceGenerator.newNonce());
            Assert.fail();
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
        TableDescriptor currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((Object)(!td.isCompactionEnabled() ? 1 : 0), (Object)currentHtd.isCompactionEnabled());
        Assert.assertEquals((long)3L, (long)currentHtd.getColumnFamilyCount());
        Assert.assertTrue((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family2)));
        Assert.assertTrue((boolean)currentHtd.hasColumnFamily(Bytes.toBytes((String)column_Family3)));
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, column_Family1, column_Family2, column_Family3);
    }

    @Test
    public void testRollbackAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String familyName = column_Family2;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptor td = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setCompactionEnabled(!td.isCompactionEnabled()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)column_Family2)).build();
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), newTd));
        int lastStep = 8;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, lastStep);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, column_Family1);
    }

    @Test
    public void testRollbackAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String familyName = column_Family2;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, column_Family1);
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        TableDescriptor td = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setCompactionEnabled(!td.isCompactionEnabled()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)column_Family2)).setRegionReplication(3).build();
        long procId = procExec.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), newTd));
        int lastStep = 8;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, lastStep);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, column_Family1);
    }

    @Test
    public void testConcurrentAddColumnFamily() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, column_Family1);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)column_Family2)).build();
        class ConcurrentAddColumnFamily
        extends Thread {
            TableName tableName = null;
            ColumnFamilyDescriptor columnFamilyDescriptor;
            boolean exception;

            public ConcurrentAddColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamilyDescriptor) {
                this.tableName = tableName;
                this.columnFamilyDescriptor = columnFamilyDescriptor;
                this.exception = false;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        TestTableDDLProcedureBase.UTIL.getAdmin().addColumnFamily(this.tableName, this.columnFamilyDescriptor);
                    }
                    catch (Exception e) {
                        if (!e.getClass().equals(ConcurrentTableModificationException.class)) break block2;
                        this.exception = true;
                    }
                }
            }
        }
        ConcurrentAddColumnFamily t1 = new ConcurrentAddColumnFamily(tableName, columnFamilyDescriptor);
        columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)column_Family3)).build();
        ConcurrentAddColumnFamily t2 = new ConcurrentAddColumnFamily(tableName, columnFamilyDescriptor);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        int noOfColumnFamilies = UTIL.getAdmin().getDescriptor(tableName).getColumnFamilies().length;
        Assert.assertTrue((String)"Expected ConcurrentTableModificationException.", ((t1.exception || t2.exception) && noOfColumnFamilies == 2 || noOfColumnFamilies == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentDeleteColumnFamily() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)column_Family1)).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)column_Family2)).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)column_Family3)).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        UTIL.getAdmin().createTable(tableDescriptorBuilder.build());
        class ConcurrentCreateDeleteTable
        extends Thread {
            TableName tableName = null;
            String columnFamily = null;
            boolean exception;

            public ConcurrentCreateDeleteTable(TableName tableName, String columnFamily) {
                this.tableName = tableName;
                this.columnFamily = columnFamily;
                this.exception = false;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        TestTableDDLProcedureBase.UTIL.getAdmin().deleteColumnFamily(this.tableName, this.columnFamily.getBytes());
                    }
                    catch (Exception e) {
                        if (!e.getClass().equals(ConcurrentTableModificationException.class)) break block2;
                        this.exception = true;
                    }
                }
            }
        }
        ConcurrentCreateDeleteTable t1 = new ConcurrentCreateDeleteTable(tableName, column_Family2);
        ConcurrentCreateDeleteTable t2 = new ConcurrentCreateDeleteTable(tableName, column_Family3);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        int noOfColumnFamilies = UTIL.getAdmin().getDescriptor(tableName).getColumnFamilies().length;
        Assert.assertTrue((String)"Expected ConcurrentTableModificationException.", ((t1.exception || t2.exception) && noOfColumnFamilies == 2 || noOfColumnFamilies == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentModifyColumnFamily() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, column_Family1);
        ColumnFamilyDescriptor modColumnFamily1 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])column_Family1.getBytes()).setMaxVersions(5).build();
        ColumnFamilyDescriptor modColumnFamily2 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])column_Family1.getBytes()).setMaxVersions(6).build();
        class ConcurrentModifyColumnFamily
        extends Thread {
            TableName tableName = null;
            ColumnFamilyDescriptor hcd = null;
            boolean exception;

            public ConcurrentModifyColumnFamily(TableName tableName, ColumnFamilyDescriptor hcd) {
                this.tableName = tableName;
                this.hcd = hcd;
                this.exception = false;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        TestTableDDLProcedureBase.UTIL.getAdmin().modifyColumnFamily(this.tableName, this.hcd);
                    }
                    catch (Exception e) {
                        if (!e.getClass().equals(ConcurrentTableModificationException.class)) break block2;
                        this.exception = true;
                    }
                }
            }
        }
        ConcurrentModifyColumnFamily t1 = new ConcurrentModifyColumnFamily(tableName, modColumnFamily1);
        ConcurrentModifyColumnFamily t2 = new ConcurrentModifyColumnFamily(tableName, modColumnFamily2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        int maxVersions = UTIL.getAdmin().getDescriptor(tableName).getColumnFamily(column_Family1.getBytes()).getMaxVersions();
        Assert.assertTrue((String)"Expected ConcurrentTableModificationException.", (t1.exception && maxVersions == 5 || t2.exception && maxVersions == 6 || !t1.exception || !t2.exception ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentModifyTable() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, column_Family1);
        TableDescriptor htd = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor modifiedDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setCompactionEnabled(false).build();
        class ConcurrentModifyTable
        extends Thread {
            TableName tableName = null;
            TableDescriptor htd = null;
            boolean exception;

            public ConcurrentModifyTable(TableName tableName, TableDescriptor htd) {
                this.tableName = tableName;
                this.htd = htd;
                this.exception = false;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        TestTableDDLProcedureBase.UTIL.getAdmin().modifyTable(this.htd);
                    }
                    catch (Exception e) {
                        if (!e.getClass().equals(ConcurrentTableModificationException.class)) break block2;
                        this.exception = true;
                    }
                }
            }
        }
        ConcurrentModifyTable t1 = new ConcurrentModifyTable(tableName, modifiedDescriptor);
        ConcurrentModifyTable t2 = new ConcurrentModifyTable(tableName, modifiedDescriptor);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertFalse((String)"Expected ConcurrentTableModificationException.", (t1.exception || t2.exception ? 1 : 0) != 0);
    }

    @Test
    public void testModifyWillNotReopenRegions() throws IOException {
        boolean reopenRegions = false;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf");
        TableDescriptor htd = UTIL.getAdmin().getDescriptor(tableName);
        TableDescriptor modifiedDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setValue("test.hbase.conf", "test.hbase.conf.value").build();
        long procId1 = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), modifiedDescriptor, null, htd, false, false));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId1));
        TableDescriptor currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((Object)"test.hbase.conf.value", (Object)currentHtd.getValue("test.hbase.conf"));
        for (HRegion r : UTIL.getHBaseCluster().getRegions(tableName)) {
            Assert.assertNull((Object)r.getTableDescriptor().getValue("test.hbase.conf"));
        }
        for (HRegion r : UTIL.getHBaseCluster().getRegions(tableName)) {
            this.getMaster().getAssignmentManager().move(r.getRegionInfo());
        }
        for (HRegion r : UTIL.getHBaseCluster().getRegions(tableName)) {
            Assert.assertEquals((Object)"test.hbase.conf.value", (Object)r.getTableDescriptor().getValue("test.hbase.conf"));
        }
        htd = UTIL.getAdmin().getDescriptor(tableName);
        long oldRegionReplication = htd.getRegionReplication();
        modifiedDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setRegionReplication(3).build();
        try {
            ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), modifiedDescriptor, null, htd, false, false));
            Assert.fail((String)"An exception should have been thrown while modifying region replication properties.");
        }
        catch (HBaseIOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Can not modify"));
        }
        currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((long)oldRegionReplication, (long)currentHtd.getRegionReplication());
        htd = UTIL.getAdmin().getDescriptor(tableName);
        modifiedDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])"NewCF".getBytes()).build()).build();
        try {
            ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), modifiedDescriptor, null, htd, false, false));
            Assert.fail((String)"Should have thrown an exception while modifying CF!");
        }
        catch (HBaseIOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot add or remove column families"));
        }
        currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertNull((Object)currentHtd.getColumnFamily("NewCF".getBytes()));
        htd = UTIL.getAdmin().getDescriptor(tableName);
        modifiedDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])"cf".getBytes()).setCompressionType(Compression.Algorithm.SNAPPY).build()).build();
        ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), modifiedDescriptor, null, htd, false, false));
        for (HRegion r : UTIL.getHBaseCluster().getRegions(tableName)) {
            Assert.assertEquals((Object)Compression.Algorithm.NONE, (Object)r.getTableDescriptor().getColumnFamily("cf".getBytes()).getCompressionType());
        }
        for (HRegion r : UTIL.getHBaseCluster().getRegions(tableName)) {
            this.getMaster().getAssignmentManager().move(r.getRegionInfo());
        }
        for (HRegion r : UTIL.getHBaseCluster().getRegions(tableName)) {
            Assert.assertEquals((Object)Compression.Algorithm.SNAPPY, (Object)r.getTableDescriptor().getColumnFamily("cf".getBytes()).getCompressionType());
        }
        htd = UTIL.getAdmin().getDescriptor(tableName);
        modifiedDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"any.coprocessor.name").setJarPath("fake/path").build()).build();
        try {
            ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), modifiedDescriptor, null, htd, false, false));
            Assert.fail((String)"Should have thrown an exception while modifying coprocessor!");
        }
        catch (HBaseIOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Can not modify Coprocessor"));
        }
        currentHtd = UTIL.getAdmin().getDescriptor(tableName);
        Assert.assertEquals((long)0L, (long)currentHtd.getCoprocessorDescriptors().size());
        htd = UTIL.getAdmin().getDescriptor(tableName);
        modifiedDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setRegionReplication(3).build();
        try {
            ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new ModifyTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), modifiedDescriptor, null, htd, false, false));
            Assert.fail((String)"Should have thrown an exception while modifying coprocessor!");
        }
        catch (HBaseIOException e) {
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Can not modify REGION_REPLICATION"));
        }
    }
}

