/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSuspendTRSPWhenHoldingRegionStateNodeLock {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSuspendTRSPWhenHoldingRegionStateNodeLock.class);
    private static final HBaseTestingUtil HBTU = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static byte[] FAMILY = Bytes.toBytes((String)"family");

    @BeforeClass
    public static void setUp() throws Exception {
        HBTU.startMiniCluster(2);
        HBTU.createTable(TABLE_NAME, FAMILY);
        HBTU.waitTableAvailable(TABLE_NAME);
        HBTU.getAdmin().balancerSwitch(false, true);
        HBTU.waitUntilNoRegionsInTransition();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        HBTU.shutdownMiniCluster();
    }

    private <T> Matcher<Procedure<T>> notChildOf(final long procId) {
        return new BaseMatcher<Procedure<T>>(){

            public boolean matches(Object item) {
                if (!(item instanceof Procedure)) {
                    return false;
                }
                Procedure proc = (Procedure)item;
                return !proc.hasParent() || proc.getRootProcId() != procId;
            }

            public void describeTo(Description description) {
                description.appendText("not a child of pid=").appendValue((Object)procId);
            }
        };
    }

    @Test
    public void testSuspend() throws Exception {
        HMaster master = HBTU.getMiniHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        RegionInfo ri = (RegionInfo)Iterables.getOnlyElement((Iterable)am.getTableRegions(TABLE_NAME, true));
        RegionStateNode rsn = am.getRegionStates().getRegionStateNode(ri);
        ServerName src = rsn.getRegionLocation();
        ServerName dst = HBTU.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).filter(sn -> !sn.equals((Object)src)).findFirst().get();
        TransitRegionStateProcedure proc = am.createMoveRegionProcedure(ri, dst);
        rsn.lock();
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)proc);
        Thread.sleep(2000L);
        HBTU.waitFor(30000L, () -> procExec.getActiveExecutorCount() == 0);
        Assert.assertFalse((boolean)proc.isFinished());
        MatcherAssert.assertThat((Object)procExec.getProcedures(), (Matcher)Matchers.everyItem(this.notChildOf(procId)));
        Assert.assertEquals((Object)src, (Object)HBTU.getRSForFirstRegionInTable(TABLE_NAME).getServerName());
        rsn.unlock();
        HBTU.waitFor(30000L, () -> proc.isFinished());
        Assert.assertEquals((Object)dst, (Object)HBTU.getRSForFirstRegionInTable(TABLE_NAME).getServerName());
    }
}

