/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.replication.MigrateReplicationQueueFromZkToTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMigrateReplicationQueue
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMigrateReplicationQueue.class);

    private int disableAndInsert() throws Exception {
        UTIL1.getAdmin().disableReplicationPeer("2");
        return UTIL1.loadTable(htable1, famName);
    }

    private String getQueuesZNode() throws IOException {
        Configuration conf = UTIL1.getConfiguration();
        ZKWatcher zk = UTIL1.getZooKeeperWatcher();
        String replicationZNode = ZNodePaths.joinZNode((String)zk.getZNodePaths().baseZNode, (String[])new String[]{conf.get("zookeeper.znode.replication", "replication")});
        return ZNodePaths.joinZNode((String)replicationZNode, (String[])new String[]{conf.get("zookeeper.znode.replication.rs", "rs")});
    }

    private void mockData() throws Exception {
        TableName replicationQueueTableName = TableName.valueOf((String)UTIL1.getConfiguration().get("hbase.replication.queue.table.name", ReplicationStorageFactory.REPLICATION_QUEUE_TABLE_NAME_DEFAULT.getNameAsString()));
        List queueDatas = UTIL1.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage().listAllQueues();
        Assert.assertEquals((long)UTIL1.getMiniHBaseCluster().getRegionServerThreads().size(), (long)queueDatas.size());
        UTIL1.getAdmin().disableTable(replicationQueueTableName);
        UTIL1.getAdmin().deleteTable(replicationQueueTableName);
        UTIL1.shutdownMiniHBaseCluster();
        ZKWatcher zk = UTIL1.getZooKeeperWatcher();
        String queuesZNode = this.getQueuesZNode();
        for (ReplicationQueueData queueData : queueDatas) {
            String replicatorZNode = ZNodePaths.joinZNode((String)queuesZNode, (String[])new String[]{queueData.getId().getServerName().toString()});
            String queueZNode = ZNodePaths.joinZNode((String)replicatorZNode, (String[])new String[]{queueData.getId().getPeerId()});
            Assert.assertEquals((long)1L, (long)queueData.getOffsets().size());
            ReplicationGroupOffset offset = (ReplicationGroupOffset)Iterables.getOnlyElement((Iterable)queueData.getOffsets().values());
            String walZNode = ZNodePaths.joinZNode((String)queueZNode, (String[])new String[]{offset.getWal()});
            ZKUtil.createSetData((ZKWatcher)zk, (String)walZNode, (byte[])ZKUtil.positionToByteArray((long)offset.getOffset()));
        }
    }

    @Test
    public void testMigrate() throws Exception {
        int count = this.disableAndInsert();
        this.mockData();
        TestMigrateReplicationQueue.restartSourceCluster(1);
        UTIL1.waitFor(60000L, () -> UTIL1.getMiniHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof MigrateReplicationQueueFromZkToTableProcedure).findAny().map(Procedure::isSuccess).orElse(false));
        TableName replicationQueueTableName = TableName.valueOf((String)UTIL1.getConfiguration().get("hbase.replication.queue.table.name", ReplicationStorageFactory.REPLICATION_QUEUE_TABLE_NAME_DEFAULT.getNameAsString()));
        Assert.assertTrue((boolean)UTIL1.getAdmin().tableExists(replicationQueueTableName));
        ZKWatcher zk = UTIL1.getZooKeeperWatcher();
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)zk, (String)this.getQueuesZNode()));
        UTIL1.waitFor(60000L, () -> UTIL1.getMiniHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).allMatch(Procedure::isSuccess));
        List queueDatas = UTIL1.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage().listAllQueues();
        Assert.assertEquals((long)1L, (long)queueDatas.size());
        Assert.assertTrue((boolean)((ReplicationQueueData)queueDatas.get(0)).getId().isRecovered());
        Assert.assertEquals((long)1L, (long)((ReplicationQueueData)queueDatas.get(0)).getOffsets().size());
        Assert.assertFalse((boolean)UTIL1.getAdmin().isReplicationPeerEnabled("2"));
        Assert.assertEquals((long)0L, (long)HBaseTestingUtil.countRows(htable2));
        UTIL1.getAdmin().enableReplicationPeer("2");
        TestMigrateReplicationQueue.waitForReplication(count, 100);
    }
}

