/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mob.TestMobUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class})
public class TestDefaultMobStoreFlusher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultMobStoreFlusher.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qf1 = Bytes.toBytes((String)"qf1");
    private static final byte[] qf2 = Bytes.toBytes((String)"qf2");
    private static final byte[] value1 = Bytes.toBytes((String)"value1");
    private static final byte[] value2 = Bytes.toBytes((String)"value2");
    @Rule
    public TestName name = new TestName();
    protected Boolean useFileBasedSFT;

    public TestDefaultMobStoreFlusher(Boolean useFileBasedSFT) {
        this.useFileBasedSFT = useFileBasedSFT;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> data() {
        Boolean[] data = new Boolean[]{false, true};
        return Arrays.asList(data);
    }

    @Before
    public void setUpBefore() throws Exception {
        if (this.useFileBasedSFT.booleanValue()) {
            TEST_UTIL.getConfiguration().set("hbase.store.file-tracker.impl", "org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker");
        }
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDownAfter() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFlushNonMobFile() throws Exception {
        TableName tableName = TableName.valueOf((String)TestMobUtils.getTableName(this.name));
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setMaxVersions(4).build()).build();
        this.testFlushFile(tableDescriptor);
    }

    @Test
    public void testFlushMobFile() throws Exception {
        TableName tableName = TableName.valueOf((String)TestMobUtils.getTableName(this.name));
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setMobEnabled(true).setMobThreshold(3L).setMaxVersions(4).build()).build();
        this.testFlushFile(tableDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFlushFile(TableDescriptor tableDescriptor) throws Exception {
        try (Table table = null;){
            table = TEST_UTIL.createTable(tableDescriptor, (byte[][])null);
            Put put0 = new Put(row1);
            put0.addColumn(family, qf1, 1L, value1);
            table.put(put0);
            Put put1 = new Put(row2);
            put1.addColumn(family, qf2, 1L, value2);
            table.put(put1);
            TEST_UTIL.flush(tableDescriptor.getTableName());
            Scan scan = new Scan();
            scan.addColumn(family, qf1);
            scan.readVersions(4);
            ResultScanner scanner = table.getScanner(scan);
            int size = 0;
            for (Result result : scanner) {
                ++size;
                List cells = result.getColumnCells(family, qf1);
                Assert.assertEquals((long)1L, (long)cells.size());
                Assert.assertArrayEquals((byte[])value1, (byte[])CellUtil.cloneValue((Cell)((Cell)cells.get(0))));
            }
            scanner.close();
            Assert.assertEquals((long)1L, (long)size);
        }
    }
}

