/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.OnlineLogRecord;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestTooLargeLog {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTooLargeLog.class);
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    protected static Admin ADMIN;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.slowlog.buffer.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.warn.response.size", 32768);
        TEST_UTIL.startMiniCluster(1);
        ADMIN = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testLogLargeBlockBytesScanned() throws IOException {
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        regionServer.getConfiguration().setBoolean("hbase.regionserver.slowlog.buffer.enabled", false);
        regionServer.updateConfiguration();
        byte[] family = Bytes.toBytes((String)"0");
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)"testLogLargeBlockBytesScanned"), family);
        TEST_UTIL.loadTable(table, family);
        TEST_UTIL.flush(table.getName());
        Set<ServerName> server = Collections.singleton(regionServer.getServerName());
        Admin admin = TEST_UTIL.getAdmin();
        regionServer.getConfiguration().setBoolean("hbase.regionserver.slowlog.buffer.enabled", true);
        regionServer.updateConfiguration();
        Scan scan = new Scan();
        scan.setCaching(1);
        try (ResultScanner scanner = table.getScanner(scan);){
            scanner.next();
        }
        List entries = admin.getLogEntries(server, "LARGE_LOG", ServerType.REGION_SERVER, 100, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)entries.size());
        OnlineLogRecord record = (OnlineLogRecord)entries.get(0);
        Assert.assertTrue((String)("expected " + record.getBlockBytesScanned() + " to be >= 100"), (record.getBlockBytesScanned() >= 100L ? 1 : 0) != 0);
        Assert.assertTrue((String)("expected " + record.getResponseSize() + " to be < 100"), (record.getResponseSize() < 100L ? 1 : 0) != 0);
    }
}

