/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestBloomFilterFaulty {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBloomFilterFaulty.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] QUAL = Bytes.toBytes((String)"qualifier");
    private static final TableDescriptor TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test")).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setBloomFilterType(BloomType.ROWPREFIX_FIXED_LENGTH).setConfiguration("RowPrefixBloomFilter.prefix_length", "2").build()).build();
    private static final RegionInfo RI = RegionInfoBuilder.newBuilder((TableName)TD.getTableName()).build();
    private HRegion region;
    @Rule
    public final TestName name = new TestName();

    @AfterClass
    public static void tearDownAfterClass() {
        UTIL.cleanupTestDir();
    }

    private void generateHFiles() throws IOException {
        for (int i = 0; i < 4; ++i) {
            byte[] row;
            int j;
            long ts = EnvironmentEdgeManager.currentTime();
            for (j = 0; j < 5; ++j) {
                row = Bytes.toBytes((int)j);
                this.region.put(new Put(row).addColumn(FAMILY, QUAL, ts, Bytes.toBytes((int)(i * 10 + j))));
                this.region.delete(new Delete(row).addFamilyVersion(FAMILY, ts));
            }
            for (j = 5; j < 10; ++j) {
                row = Bytes.toBytes((int)j);
                this.region.put(new Put(row).addColumn(FAMILY, QUAL, ts + 1L, Bytes.toBytes((int)(i * 10 + j))));
            }
            HRegion.FlushResult result = this.region.flush(true);
            if (result.getResult() != HRegion.FlushResult.Result.CANNOT_FLUSH && result.getResult() != HRegion.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY) continue;
            throw new IOException("Can not flush region, flush result: " + result);
        }
    }

    @Before
    public void setUp() throws IOException {
        Path rootDir = UTIL.getDataTestDir(this.name.getMethodName());
        this.region = HBaseTestingUtil.createRegionAndWAL(RI, rootDir, UTIL.getConfiguration(), TD);
        this.generateHFiles();
        HStore store = this.region.getStore(FAMILY);
        for (HStoreFile storefile : store.getStorefiles()) {
            storefile.initReader();
            StoreFileReader reader = storefile.getReader();
            Assert.assertNotNull((Object)reader.generalBloomFilter);
            Assert.assertNotNull((Object)reader.deleteFamilyBloomFilter);
        }
    }

    @After
    public void tearDown() throws IOException {
        if (this.region != null) {
            HBaseTestingUtil.closeRegionAndWAL(this.region);
        }
    }

    private void setFaulty(BlockType type) {
        HStore store = this.region.getStore(FAMILY);
        for (HStoreFile storefile : store.getStorefiles()) {
            storefile.getReader().setBloomFilterFaulty(type);
        }
    }

    private void testGet() throws IOException {
        int i;
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)this.region.get(new Get(Bytes.toBytes((int)i))).isEmpty());
        }
        for (i = 5; i < 10; ++i) {
            Assert.assertEquals((long)(30 + i), (long)Bytes.toInt((byte[])this.region.get(new Get(Bytes.toBytes((int)i))).getValue(FAMILY, QUAL)));
        }
    }

    private void testStreamScan() throws IOException {
        try (RegionAsTable table = new RegionAsTable((Region)this.region);
             ResultScanner scanner = table.getScanner(new Scan().setReadType(Scan.ReadType.STREAM));){
            for (int i = 5; i < 10; ++i) {
                Result result = scanner.next();
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
                Assert.assertEquals((long)(30 + i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, QUAL)));
            }
            Assert.assertNull((Object)scanner.next());
        }
    }

    private void testRegion() throws IOException {
        this.testGet();
        this.testStreamScan();
        this.region.compact(true);
        this.testGet();
        this.testStreamScan();
    }

    @Test
    public void testNoGeneralBloomFilter() throws IOException {
        this.setFaulty(BlockType.GENERAL_BLOOM_META);
        this.testRegion();
    }

    @Test
    public void testNoDeleteFamilyBloomFilter() throws IOException {
        this.setFaulty(BlockType.DELETE_FAMILY_BLOOM_META);
        this.testRegion();
    }

    @Test
    public void testNoAnyBloomFilter() throws IOException {
        this.setFaulty(BlockType.GENERAL_BLOOM_META);
        this.setFaulty(BlockType.DELETE_FAMILY_BLOOM_META);
        this.testRegion();
    }
}

