/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.regionserver.BootstrapNodeManager;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestBootstrapNodeManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBootstrapNodeManager.class);
    private Configuration conf;
    private AsyncClusterConnection conn;
    private MasterAddressTracker tracker;
    private BootstrapNodeManager manager;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.conf.setLong("hbase.server.bootstrap.request_master_interval.secs", 5L);
        this.conf.setLong("hbase.server.bootstrap.request_master_min_interval.secs", 1L);
        this.conf.setLong("hbase.server.bootstrap.request_regionserver_interval.secs", 1L);
        this.conf.setInt("hbase.client.bootstrap.node.limit", 2);
        this.conn = (AsyncClusterConnection)Mockito.mock(AsyncClusterConnection.class);
        Mockito.when((Object)this.conn.getConfiguration()).thenReturn((Object)this.conf);
        this.tracker = (MasterAddressTracker)Mockito.mock(MasterAddressTracker.class);
    }

    @After
    public void tearDown() {
        if (this.manager != null) {
            this.manager.stop();
        }
    }

    private void assertListEquals(List<ServerName> expected, List<ServerName> actual) {
        Assert.assertEquals((long)expected.size(), (long)expected.size());
        MatcherAssert.assertThat(actual, (Matcher)CoreMatchers.hasItems((Object[])expected.toArray(new ServerName[0])));
    }

    @Test
    public void testNormal() throws Exception {
        List<ServerName> regionServers = Arrays.asList(ServerName.valueOf((String)"server1", (int)12345, (long)EnvironmentEdgeManager.currentTime()), ServerName.valueOf((String)"server2", (int)12345, (long)EnvironmentEdgeManager.currentTime()), ServerName.valueOf((String)"server3", (int)12345, (long)EnvironmentEdgeManager.currentTime()), ServerName.valueOf((String)"server4", (int)12345, (long)EnvironmentEdgeManager.currentTime()));
        Mockito.when((Object)this.conn.getLiveRegionServers((MasterAddressTracker)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(CompletableFuture.completedFuture(regionServers));
        Mockito.when((Object)this.conn.getAllBootstrapNodes((ServerName)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(regionServers));
        this.manager = new BootstrapNodeManager(this.conn, this.tracker);
        Thread.sleep(3000L);
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).getLiveRegionServers((MasterAddressTracker)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.atLeastOnce())).getAllBootstrapNodes((ServerName)ArgumentMatchers.any());
        this.assertListEquals(regionServers, this.manager.getBootstrapNodes());
    }

    @Test
    public void testOnlyMaster() throws Exception {
        List<ServerName> regionServers = Arrays.asList(ServerName.valueOf((String)"server1", (int)12345, (long)EnvironmentEdgeManager.currentTime()));
        Mockito.when((Object)this.conn.getLiveRegionServers((MasterAddressTracker)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(CompletableFuture.completedFuture(regionServers));
        Mockito.when((Object)this.conn.getAllBootstrapNodes((ServerName)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(regionServers));
        this.manager = new BootstrapNodeManager(this.conn, this.tracker);
        Thread.sleep(3000L);
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.atLeast((int)2))).getLiveRegionServers((MasterAddressTracker)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).getAllBootstrapNodes((ServerName)ArgumentMatchers.any());
        this.assertListEquals(regionServers, this.manager.getBootstrapNodes());
    }

    @Test
    public void testRegionServerError() throws Exception {
        List<ServerName> regionServers = Arrays.asList(ServerName.valueOf((String)"server1", (int)12345, (long)EnvironmentEdgeManager.currentTime()), ServerName.valueOf((String)"server2", (int)12345, (long)EnvironmentEdgeManager.currentTime()), ServerName.valueOf((String)"server3", (int)12345, (long)EnvironmentEdgeManager.currentTime()), ServerName.valueOf((String)"server4", (int)12345, (long)EnvironmentEdgeManager.currentTime()));
        List<ServerName> newRegionServers = Arrays.asList(ServerName.valueOf((String)"server5", (int)12345, (long)EnvironmentEdgeManager.currentTime()), ServerName.valueOf((String)"server6", (int)12345, (long)EnvironmentEdgeManager.currentTime()));
        Mockito.when((Object)this.conn.getLiveRegionServers((MasterAddressTracker)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(CompletableFuture.completedFuture(regionServers));
        Mockito.when((Object)this.conn.getAllBootstrapNodes((ServerName)ArgumentMatchers.any())).thenAnswer(invocation -> {
            if (((ServerName)invocation.getArgument(0, ServerName.class)).getHostname().equals("server4")) {
                return FutureUtils.failedFuture((Throwable)new IOException("Inject error"));
            }
            return CompletableFuture.completedFuture(regionServers.subList(0, 3));
        });
        this.manager = new BootstrapNodeManager(this.conn, this.tracker);
        Waiter.waitFor((Configuration)this.conf, (long)30000L, () -> this.manager.getBootstrapNodes().size() == 3);
        this.assertListEquals(regionServers.subList(0, 3), this.manager.getBootstrapNodes());
        Mockito.when((Object)this.conn.getLiveRegionServers((MasterAddressTracker)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(CompletableFuture.completedFuture(newRegionServers));
        ((AsyncClusterConnection)Mockito.doAnswer(invocation -> {
            String hostname;
            switch (hostname = ((ServerName)invocation.getArgument(0, ServerName.class)).getHostname()) {
                case "server1": {
                    return CompletableFuture.completedFuture(regionServers.subList(0, 1));
                }
                case "server2": 
                case "server3": {
                    return FutureUtils.failedFuture((Throwable)new IOException("Inject error"));
                }
            }
            return CompletableFuture.completedFuture(newRegionServers);
        }).when((Object)this.conn)).getAllBootstrapNodes((ServerName)ArgumentMatchers.any());
        Waiter.waitFor((Configuration)this.conf, (long)30000L, () -> {
            List bootstrapNodes = this.manager.getBootstrapNodes();
            if (bootstrapNodes.size() != 2) {
                return false;
            }
            String hostname = ((ServerName)bootstrapNodes.get(0)).getHostname();
            return hostname.equals("server5") || hostname.equals("server6");
        });
        this.assertListEquals(newRegionServers, this.manager.getBootstrapNodes());
    }
}

