/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestCompactionState {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionState.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMajorCompactionStateFromAdmin() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 8, CompactionState.MAJOR, false, StateSource.ADMIN);
    }

    @Test
    public void testMinorCompactionStateFromAdmin() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 15, CompactionState.MINOR, false, StateSource.ADMIN);
    }

    @Test
    public void testMajorCompactionOnFamilyStateFromAdmin() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 8, CompactionState.MAJOR, true, StateSource.ADMIN);
    }

    @Test
    public void testMinorCompactionOnFamilyStateFromAdmin() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 15, CompactionState.MINOR, true, StateSource.ADMIN);
    }

    @Test
    public void testMajorCompactionStateFromMaster() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 8, CompactionState.MAJOR, false, StateSource.MASTER);
    }

    @Test
    public void testMinorCompactionStateFromMaster() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 15, CompactionState.MINOR, false, StateSource.MASTER);
    }

    @Test
    public void testMajorCompactionOnFamilyStateFromMaster() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 8, CompactionState.MAJOR, true, StateSource.MASTER);
    }

    @Test
    public void testMinorCompactionOnFamilyStateFromMaster() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 15, CompactionState.MINOR, true, StateSource.MASTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidColumnFamily() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] family = Bytes.toBytes((String)"family");
        byte[] fakecf = Bytes.toBytes((String)"fakecf");
        boolean caughtMinorCompact = false;
        boolean caughtMajorCompact = false;
        Table ht = null;
        try {
            ht = TEST_UTIL.createTable(tableName, family);
            Admin admin = TEST_UTIL.getAdmin();
            try {
                admin.compact(tableName, fakecf);
            }
            catch (IOException ioe) {
                caughtMinorCompact = true;
            }
            try {
                admin.majorCompact(tableName, fakecf);
            }
            catch (IOException ioe) {
                caughtMajorCompact = true;
            }
        }
        finally {
            if (ht != null) {
                TEST_UTIL.deleteTable(tableName);
            }
            Assert.assertTrue((boolean)caughtMinorCompact);
            Assert.assertTrue((boolean)caughtMajorCompact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compaction(String tableName, int flushes, CompactionState expectedState, boolean singleFamily, StateSource stateSource) throws IOException, InterruptedException {
        TableName table = TableName.valueOf((String)tableName);
        byte[] family = Bytes.toBytes((String)"family");
        byte[][] families = new byte[][]{family, Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"2")), Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"3"))};
        Table ht = null;
        try {
            ht = TEST_UTIL.createTable(table, (byte[][])families);
            TestCompactionState.loadData(ht, families, 3000, flushes);
            HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
            HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
            List regions = rs.getRegions(table);
            int countBefore = TestCompactionState.countStoreFilesInFamilies(regions, families);
            int countBeforeSingleFamily = TestCompactionState.countStoreFilesInFamily(regions, family);
            Assert.assertTrue((countBefore > 0 ? 1 : 0) != 0);
            Admin admin = TEST_UTIL.getAdmin();
            if (expectedState == CompactionState.MINOR) {
                if (singleFamily) {
                    admin.compact(table, family);
                } else {
                    admin.compact(table);
                }
            } else if (singleFamily) {
                admin.majorCompact(table, family);
            } else {
                admin.majorCompact(table);
            }
            long curt = EnvironmentEdgeManager.currentTime();
            long waitTime = 5000L;
            long endt = curt + waitTime;
            CompactionState state = TestCompactionState.getCompactionState(stateSource, master, admin, table);
            while (state == CompactionState.NONE && curt < endt) {
                Thread.sleep(10L);
                state = TestCompactionState.getCompactionState(stateSource, master, admin, table);
                curt = EnvironmentEdgeManager.currentTime();
            }
            if (expectedState != state) {
                for (Region region : regions) {
                    state = CompactionState.valueOf((String)region.getCompactionState().toString());
                    Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
                }
            } else {
                state = TestCompactionState.getCompactionState(stateSource, master, admin, table);
                while (state != CompactionState.NONE && curt < endt) {
                    Thread.sleep(10L);
                    state = TestCompactionState.getCompactionState(stateSource, master, admin, table);
                }
                Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
            }
            int countAfter = TestCompactionState.countStoreFilesInFamilies(regions, families);
            int countAfterSingleFamily = TestCompactionState.countStoreFilesInFamily(regions, family);
            Assert.assertTrue((countAfter < countBefore ? 1 : 0) != 0);
            if (!singleFamily) {
                if (expectedState == CompactionState.MAJOR) {
                    Assert.assertTrue((families.length == countAfter ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((families.length < countAfter ? 1 : 0) != 0);
                }
            } else {
                int singleFamDiff = countBeforeSingleFamily - countAfterSingleFamily;
                Assert.assertTrue((singleFamDiff == countBefore - countAfter ? 1 : 0) != 0);
                if (expectedState == CompactionState.MAJOR) {
                    Assert.assertTrue((1 == countAfterSingleFamily ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((1 < countAfterSingleFamily ? 1 : 0) != 0);
                }
            }
        }
        finally {
            if (ht != null) {
                TEST_UTIL.deleteTable(table);
            }
        }
    }

    private static CompactionState getCompactionState(StateSource stateSource, HMaster master, Admin admin, TableName table) throws IOException {
        CompactionState state = stateSource == StateSource.ADMIN ? admin.getCompactionState(table) : master.getCompactionState(table);
        return state;
    }

    private static int countStoreFilesInFamily(List<HRegion> regions, byte[] family) {
        return TestCompactionState.countStoreFilesInFamilies(regions, new byte[][]{family});
    }

    private static int countStoreFilesInFamilies(List<HRegion> regions, byte[][] families) {
        int count = 0;
        for (HRegion region : regions) {
            count += region.getStoreFileList(families).size();
        }
        return count;
    }

    private static void loadData(Table ht, byte[][] families, int rows, int flushes) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(rows);
        byte[] qualifier = Bytes.toBytes((String)"val");
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < flushes; ++i) {
            for (int k = 0; k < rows; ++k) {
                byte[] row = Bytes.toBytes((long)((Random)rand).nextLong());
                Put p = new Put(row);
                for (int j = 0; j < families.length; ++j) {
                    p.addColumn(families[j], qualifier, row);
                }
                puts.add(p);
            }
            ht.put(puts);
            TEST_UTIL.flush();
            puts.clear();
        }
    }

    static enum StateSource {
        ADMIN,
        MASTER;

    }
}

