/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestCompactionWithByteBuff {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionWithByteBuff.class);
    @Rule
    public TestName name = new TestName();
    private static HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Configuration conf = TEST_UTIL.getConfiguration();
    private static Admin admin = null;
    private static final byte[] COLUMN = Bytes.toBytes((String)"A");
    private static final int REGION_COUNT = 5;
    private static final long ROW_COUNT = 200L;
    private static final int ROW_LENGTH = 20;
    private static final int VALUE_LENGTH = 5000;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf.setBoolean("hbase.server.allocator.pool.enabled", true);
        conf.setInt("hbase.server.allocator.buffer.size", 5120);
        conf.setInt("hbase.regionserver.thread.compaction.small", 10);
        conf.setInt("hbase.regionserver.thread.compaction.large", 10);
        conf.set("hbase.bucketcache.ioengine", "offheap");
        conf.setInt("hbase.bucketcache.size", 512);
        TEST_UTIL.startMiniCluster();
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCompaction() throws Exception {
        TableName table = TableName.valueOf((String)"t1");
        admin.compactionSwitch(false, new ArrayList(0));
        try (Table t = this.createTable(TEST_UTIL, table);){
            for (int i = 0; i < 2; ++i) {
                this.put(t);
                admin.flush(table);
            }
            admin.compactionSwitch(true, new ArrayList(0));
            admin.majorCompact(table);
            List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
            TEST_UTIL.waitFor(120000L, () -> {
                boolean result = true;
                for (JVMClusterUtil.RegionServerThread regionServerThread : regionServerThreads) {
                    HRegionServer regionServer = regionServerThread.getRegionServer();
                    List regions = regionServer.getRegions(table);
                    for (HRegion region : regions) {
                        List storeFileList = region.getStoreFileList((byte[][])new byte[][]{COLUMN});
                        if (storeFileList.size() <= 1) continue;
                        result = false;
                    }
                }
                return result;
            });
        }
    }

    private Table createTable(HBaseTestingUtil util, TableName tableName) throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN).setBlocksize(4096).build()).build();
        byte[][] splits = new byte[4][];
        for (int i = 1; i < 5; ++i) {
            splits[i - 1] = Bytes.toBytes((String)this.buildRow((int)(40L * (long)i)));
        }
        return util.createTable(td, (byte[][])splits);
    }

    private void put(Table table) throws IOException {
        int i = 0;
        while ((long)i < 200L) {
            Put put = new Put(Bytes.toBytes((String)this.buildRow(i)));
            put.addColumn(COLUMN, Bytes.toBytes((String)"filed01"), this.buildValue(i, 1));
            put.addColumn(COLUMN, Bytes.toBytes((String)"filed02"), this.buildValue(i, 2));
            put.addColumn(COLUMN, Bytes.toBytes((String)"filed03"), this.buildValue(i, 3));
            put.addColumn(COLUMN, Bytes.toBytes((String)"filed04"), this.buildValue(i, 4));
            put.addColumn(COLUMN, Bytes.toBytes((String)"filed05"), this.buildValue(i, 5));
            table.put(put);
            ++i;
        }
    }

    private String buildRow(int index) {
        String value = Long.toString(index);
        String prefix = "user";
        for (int i = 0; i < 20 - value.length(); ++i) {
            prefix = prefix + '0';
        }
        return prefix + value;
    }

    private byte[] buildValue(int index, int qualifierId) {
        String row = this.buildRow(index) + "/f" + qualifierId + "-";
        StringBuffer result = new StringBuffer();
        while (result.length() < 5000) {
            result.append(row);
        }
        return Bytes.toBytes((String)result.toString().substring(0, 5000));
    }
}

