/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestEncryptionRandomKeying {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEncryptionRandomKeying.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Configuration conf = TEST_UTIL.getConfiguration();
    private static TableDescriptorBuilder tdb;

    private static List<Path> findStorefilePaths(TableName tableName) throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Region region : TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegions(tdb.build().getTableName())) {
            for (HStore store : ((HRegion)region).getStores()) {
                for (HStoreFile storefile : store.getStorefiles()) {
                    paths.add(storefile.getPath());
                }
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] extractHFileKey(Path path) throws Exception {
        try (HFile.Reader reader = HFile.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)path, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);){
            Encryption.Context cryptoContext = reader.getFileContext().getEncryptionContext();
            Assert.assertNotNull((String)"Reader has a null crypto context", (Object)cryptoContext);
            Key key = cryptoContext.getKey();
            if (key == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = key.getEncoded();
            return byArray;
        }
    }

    @BeforeClass
    public static void setUp() throws Exception {
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        tdb = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"default", (String)"TestEncryptionRandomKeying"));
        ColumnFamilyDescriptorBuilder columnFamilyDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf"));
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        columnFamilyDescriptorBuilder.setEncryptionType(algorithm);
        tdb.setColumnFamily(columnFamilyDescriptorBuilder.build());
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getAdmin().createTable(tdb.build());
        TEST_UTIL.waitTableAvailable(tdb.build().getTableName(), 5000L);
        try (Table table = TEST_UTIL.getConnection().getTable(tdb.build().getTableName());){
            table.put(new Put(Bytes.toBytes((String)"testrow")).addColumn(columnFamilyDescriptorBuilder.build().getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"value")));
        }
        TEST_UTIL.getAdmin().flush(tdb.build().getTableName());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRandomKeying() throws Exception {
        List<Path> initialPaths = TestEncryptionRandomKeying.findStorefilePaths(tdb.build().getTableName());
        Assert.assertTrue((initialPaths.size() > 0 ? 1 : 0) != 0);
        for (Path path : initialPaths) {
            Assert.assertNotNull((String)("Store file " + path + " is not encrypted"), (Object)TestEncryptionRandomKeying.extractHFileKey(path));
        }
    }
}

