/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestKeyValueScanFixture {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestKeyValueScanFixture.class);

    @Test
    public void testKeyValueScanFixture() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"RowA", (String)"family", (String)"qf1", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"value-1"), KeyValueTestUtil.create((String)"RowA", (String)"family", (String)"qf2", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"value-2"), KeyValueTestUtil.create((String)"RowB", (String)"family", (String)"qf1", (long)10L, (KeyValue.Type)KeyValue.Type.Put, (String)"value-10")};
        KeyValueScanFixture scan = new KeyValueScanFixture(CellComparator.getInstance(), (Cell[])kvs);
        KeyValue kv = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"RowA"));
        Assert.assertTrue((boolean)scan.seek((Cell)kv));
        Cell res = scan.peek();
        Assert.assertEquals((Object)kvs[0], (Object)res);
        kv = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"RowB"));
        Assert.assertTrue((boolean)scan.seek((Cell)kv));
        res = scan.peek();
        Assert.assertEquals((Object)kvs[2], (Object)res);
        kv = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"RowA"));
        Assert.assertTrue((boolean)scan.seek((Cell)kv));
        Assert.assertEquals((Object)kvs[0], (Object)scan.peek());
        Assert.assertEquals((Object)kvs[0], (Object)scan.next());
        Assert.assertEquals((Object)kvs[1], (Object)scan.peek());
        Assert.assertEquals((Object)kvs[1], (Object)scan.next());
        Assert.assertEquals((Object)kvs[2], (Object)scan.peek());
        Assert.assertEquals((Object)kvs[2], (Object)scan.next());
        Assert.assertEquals(null, (Object)scan.peek());
        Assert.assertEquals(null, (Object)scan.next());
    }
}

