/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionServerMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerMetrics.class);
    @Rule
    public TestName testName = new TestName();
    private static MetricsAssertHelper metricsHelper;
    private static SingleProcessHBaseCluster cluster;
    private static HRegionServer rs;
    private static Configuration conf;
    private static HBaseTestingUtil TEST_UTIL;
    private static Connection connection;
    private static MetricsRegionServer metricsRegionServer;
    private static MetricsRegionServerSource serverSource;
    private static final int NUM_SCAN_NEXT = 30;
    private static int numScanNext;
    private static byte[] cf;
    private static byte[] row;
    private static byte[] qualifier;
    private static byte[] val;
    private static Admin admin;
    TableName tableName;
    Table table;

    @BeforeClass
    public static void startCluster() throws Exception {
        metricsHelper = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
        TEST_UTIL = new HBaseTestingUtil();
        conf = TEST_UTIL.getConfiguration();
        conf.getLong("hbase.splitlog.max.resubmit", 0L);
        conf.setInt("zookeeper.recovery.retry", 0);
        conf.setInt("hbase.hstore.compactionThreshold", 100);
        conf.setInt("hbase.hstore.compaction.max", 100);
        conf.setInt("hbase.regionserver.periodicmemstoreflusher.rangeofdelayseconds", 240);
        conf.setInt("hbase.regionserver.info.port", -1);
        TEST_UTIL.startMiniCluster();
        cluster = TEST_UTIL.getHBaseCluster();
        cluster.waitForActiveAndReadyMaster();
        admin = TEST_UTIL.getAdmin();
        connection = TEST_UTIL.getConnection();
        while (cluster.getLiveRegionServerThreads().isEmpty() && cluster.getRegionServer(0) == null && rs.getMetrics() == null) {
            Threads.sleep((long)100L);
        }
        rs = cluster.getRegionServer(0);
        metricsRegionServer = rs.getMetrics();
        serverSource = metricsRegionServer.getMetricsSource();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Before
    public void beforeTestMethod() throws Exception {
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.tableName = TableName.valueOf((String)this.testName.getMethodName());
        this.table = TEST_UTIL.createTable(this.tableName, cf);
    }

    @After
    public void afterTestMethod() throws Exception {
        admin.disableTable(this.tableName);
        admin.deleteTable(this.tableName);
    }

    private void assertCounter(String metric, long expectedValue) {
        metricsHelper.assertCounter(metric, expectedValue, (BaseSource)serverSource);
    }

    private void assertGauge(String metric, long expectedValue) {
        metricsHelper.assertGauge(metric, expectedValue, (BaseSource)serverSource);
    }

    private void assertRegionMetrics(String metric, long expectedValue) throws Exception {
        try (RegionLocator locator = connection.getRegionLocator(this.tableName);){
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                RegionInfo hri = location.getRegion();
                MetricsRegionAggregateSource agg = rs.getRegion(hri.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + this.tableName.getNameAsString() + "_region_" + hri.getEncodedName() + "_metric_";
                metricsHelper.assertCounter(prefix + metric, expectedValue, (BaseSource)agg);
            }
        }
    }

    private void doNPuts(int n, boolean batch) throws Exception {
        if (batch) {
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = 0; i < n; ++i) {
                Put p = new Put(Bytes.toBytes((String)("" + i + "row"))).addColumn(cf, qualifier, val);
                puts.add(p);
            }
            this.table.put(puts);
        } else {
            for (int i = 0; i < n; ++i) {
                Put p = new Put(row).addColumn(cf, qualifier, val);
                this.table.put(p);
            }
        }
    }

    private void doNGets(int n, boolean batch) throws Exception {
        if (batch) {
            ArrayList<Get> gets = new ArrayList<Get>();
            for (int i = 0; i < n; ++i) {
                gets.add(new Get(row));
            }
            this.table.get(gets);
        } else {
            for (int i = 0; i < n; ++i) {
                this.table.get(new Get(row));
            }
        }
    }

    private void doScan(int n, boolean caching) throws IOException {
        Scan scan = new Scan();
        if (caching) {
            scan.setCaching(n);
        } else {
            scan.setCaching(1);
        }
        ResultScanner scanner = this.table.getScanner(scan);
        for (int i = 0; i < n; ++i) {
            Result res = scanner.next();
            LOG.debug("Result row: " + Bytes.toString((byte[])res.getRow()) + ", value: " + Bytes.toString((byte[])res.getValue(cf, qualifier)));
        }
    }

    @Test
    public void testRegionCount() throws Exception {
        metricsHelper.assertGauge("regionCount", 2L, (BaseSource)serverSource);
    }

    @Test
    public void testLocalFiles() throws Exception {
        this.assertGauge("percentFilesLocal", 0L);
        this.assertGauge("percentFilesLocalSecondaryRegions", 0L);
    }

    @Test
    public void testRequestCount() throws Exception {
        this.doNPuts(1, false);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long requests = metricsHelper.getCounter("totalRequestCount", (BaseSource)serverSource);
        long rowActionRequests = metricsHelper.getCounter("totalRowActionRequestCount", (BaseSource)serverSource);
        long readRequests = metricsHelper.getCounter("readRequestCount", (BaseSource)serverSource);
        long writeRequests = metricsHelper.getCounter("writeRequestCount", (BaseSource)serverSource);
        this.doNPuts(30, false);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("totalRequestCount", requests + 30L);
        this.assertCounter("totalRowActionRequestCount", rowActionRequests + 30L);
        this.assertCounter("readRequestCount", readRequests);
        this.assertCounter("writeRequestCount", writeRequests + 30L);
        this.doNGets(10, false);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("totalRequestCount", requests + 40L);
        this.assertCounter("totalRowActionRequestCount", rowActionRequests + 40L);
        this.assertCounter("readRequestCount", readRequests + 10L);
        this.assertCounter("writeRequestCount", writeRequests + 30L);
        this.assertRegionMetrics("getCount", 10L);
        this.assertRegionMetrics("putCount", 31L);
        this.doNGets(10, true);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("writeRequestCount", writeRequests + 30L);
        this.doNPuts(30, true);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("writeRequestCount", writeRequests + 60L);
        this.doScan(10, false);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("writeRequestCount", writeRequests + 60L);
        numScanNext += 10;
        this.doScan(10, true);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("writeRequestCount", writeRequests + 60L);
        ++numScanNext;
    }

    @Test
    public void testGet() throws Exception {
        this.doNPuts(1, false);
        this.doNGets(10, false);
        this.assertRegionMetrics("getCount", 10L);
        metricsHelper.assertCounterGt("Get_num_ops", 10L, (BaseSource)serverSource);
    }

    @Test
    public void testMutationsWithoutWal() throws Exception {
        Put p = new Put(row).addColumn(cf, qualifier, val).setDurability(Durability.SKIP_WAL);
        this.table.put(p);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertGauge("mutationsWithoutWALCount", 1L);
        long minLength = row.length + cf.length + qualifier.length + val.length;
        metricsHelper.assertGaugeGt("mutationsWithoutWALSize", minLength, (BaseSource)serverSource);
    }

    @Test
    public void testStoreCount() throws Exception {
        this.doNPuts(1, false);
        TEST_UTIL.getAdmin().flush(this.tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertGauge("storeCount", 5L);
        this.assertGauge("storeFileCount", 1L);
    }

    @Test
    public void testStoreFileAge() throws Exception {
        this.doNPuts(1, false);
        TEST_UTIL.getAdmin().flush(this.tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        Assert.assertTrue((metricsHelper.getGaugeLong("maxStoreFileAge", (BaseSource)serverSource) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((metricsHelper.getGaugeLong("minStoreFileAge", (BaseSource)serverSource) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((metricsHelper.getGaugeLong("avgStoreFileAge", (BaseSource)serverSource) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCheckAndPutCount() throws Exception {
        byte[] valOne = Bytes.toBytes((String)"Value");
        byte[] valTwo = Bytes.toBytes((String)"ValueTwo");
        byte[] valThree = Bytes.toBytes((String)"ValueThree");
        Put p = new Put(row);
        p.addColumn(cf, qualifier, valOne);
        this.table.put(p);
        Put pTwo = new Put(row);
        pTwo.addColumn(cf, qualifier, valTwo);
        this.table.checkAndMutate(row, cf).qualifier(qualifier).ifEquals(valOne).thenPut(pTwo);
        Put pThree = new Put(row);
        pThree.addColumn(cf, qualifier, valThree);
        this.table.checkAndMutate(row, cf).qualifier(qualifier).ifEquals(valOne).thenPut(pThree);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("checkMutateFailedCount", 1L);
        this.assertCounter("checkMutatePassedCount", 1L);
    }

    @Test
    public void testIncrement() throws Exception {
        Put p = new Put(row).addColumn(cf, qualifier, Bytes.toBytes((long)0L));
        this.table.put(p);
        for (int count = 0; count < 13; ++count) {
            Increment inc = new Increment(row);
            inc.addColumn(cf, qualifier, 100L);
            this.table.increment(inc);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("incrementNumOps", 13L);
    }

    @Test
    public void testAppend() throws Exception {
        this.doNPuts(1, false);
        for (int count = 0; count < 73; ++count) {
            Append append = new Append(row);
            append.addColumn(cf, qualifier, Bytes.toBytes((String)",Test"));
            this.table.append(append);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        this.assertCounter("appendNumOps", 73L);
    }

    @Test
    public void testScanSize() throws Exception {
        this.doNPuts(100, true);
        Scan s = new Scan();
        s.setBatch(1).setCaching(1).setLimit(30).setReadType(Scan.ReadType.STREAM);
        try (ResultScanner resultScanners = this.table.getScanner(s);){
            for (int nextCount = 0; nextCount < 30; ++nextCount) {
                Result result = resultScanners.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)1L, (long)result.size());
            }
            numScanNext += 30;
            this.assertRegionMetrics("scanCount", 30L);
        }
    }

    @Test
    public void testScanTime() throws Exception {
        this.doNPuts(100, true);
        Scan s = new Scan();
        s.setBatch(1).setCaching(1).setLimit(30);
        try (ResultScanner resultScanners = this.table.getScanner(s);){
            for (int nextCount = 0; nextCount < 30; ++nextCount) {
                Result result = resultScanners.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)1L, (long)result.size());
            }
        }
        numScanNext += 30;
        this.assertRegionMetrics("scanCount", 30L);
    }

    @Test
    public void testScanSizeForSmallScan() throws Exception {
        this.doNPuts(100, true);
        Scan s = new Scan();
        s.setCaching(1).setLimit(30).setReadType(Scan.ReadType.PREAD);
        try (ResultScanner resultScanners = this.table.getScanner(s);){
            for (int nextCount = 0; nextCount < 30; ++nextCount) {
                Result result = resultScanners.next();
                Assert.assertNotNull((Object)result);
            }
            Assert.assertNull((Object)resultScanners.next());
        }
        numScanNext += 30;
        this.assertRegionMetrics("scanCount", 30L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMobMetrics() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testMobMetricsLocal");
        int numHfiles = 5;
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])cf).setMobEnabled(true).setMobThreshold(0L).build()).build();
        byte[] val = Bytes.toBytes((String)"mobdata");
        try {
            Table table = TEST_UTIL.createTable(htd, new byte[0][0], conf);
            HRegion region = (HRegion)rs.getRegions(tableName).get(0);
            for (int insertCount = 0; insertCount < numHfiles; ++insertCount) {
                Put p = new Put(Bytes.toBytes((int)insertCount));
                p.addColumn(cf, qualifier, val);
                table.put(p);
                admin.flush(tableName);
            }
            metricsRegionServer.getRegionServerWrapper().forceRecompute();
            this.assertCounter("mobFlushCount", numHfiles);
            Scan scan = new Scan().withStartRow(Bytes.toBytes((int)0)).withStopRow(Bytes.toBytes((int)numHfiles));
            ResultScanner scanner = table.getScanner(scan);
            scanner.next(100);
            ++numScanNext;
            scanner.close();
            metricsRegionServer.getRegionServerWrapper().forceRecompute();
            this.assertCounter("mobScanCellsCount", numHfiles);
            TestRegionServerMetrics.setMobThreshold((Region)region, cf, 100L);
            region.initialize();
            List stores = region.getStores();
            for (HStore store : stores) {
                store.triggerMajorCompaction();
                Optional context = store.requestCompaction(1, CompactionLifeCycleTracker.DUMMY, User.getCurrent());
                if (!context.isPresent()) continue;
                region.compact((CompactionContext)context.get(), store, (ThroughputController)NoLimitThroughputController.INSTANCE, User.getCurrent());
            }
            metricsRegionServer.getRegionServerWrapper().forceRecompute();
            this.assertCounter("cellsCountCompactedFromMob", numHfiles);
            this.assertCounter("cellsCountCompactedToMob", 0L);
            scanner = table.getScanner(scan);
            scanner.next(100);
            ++numScanNext;
            metricsRegionServer.getRegionServerWrapper().forceRecompute();
            this.assertCounter("mobScanCellsCount", 0L);
            for (int insertCount = numHfiles; insertCount < 2 * numHfiles; ++insertCount) {
                Put p = new Put(Bytes.toBytes((int)insertCount));
                p.addColumn(cf, qualifier, val);
                table.put(p);
                admin.flush(tableName);
            }
            TestRegionServerMetrics.setMobThreshold((Region)region, cf, 0L);
            region.close();
            region.initialize();
            region.compact(true);
            metricsRegionServer.getRegionServerWrapper().forceRecompute();
            this.assertCounter("cellsCountCompactedFromMob", 0L);
            this.assertCounter("cellsCountCompactedToMob", 2 * numHfiles);
        }
        finally {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
    }

    private static Region setMobThreshold(Region region, byte[] cfName, long modThreshold) {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)region.getTableDescriptor().getColumnFamily(cfName)).setMobThreshold(modThreshold).build();
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableDescriptor)region.getTableDescriptor()).removeColumnFamily(cfName).setColumnFamily(cfd).build();
        ((HRegion)region).setTableDescriptor(td);
        return region;
    }

    @Test
    @Ignore
    public void testRangeCountMetrics() throws Exception {
        long count;
        String dynamicMetricName;
        long[] timeranges = new long[]{1L, 3L, 10L, 30L, 100L, 300L, 1000L, 3000L, 10000L, 30000L, 60000L, 120000L, 300000L, 600000L};
        String timeRangeType = "TimeRangeCount";
        String timeRangeMetricName = "Mutate";
        boolean timeRangeCountUpdated = false;
        Put p = new Put(row);
        p.addColumn(cf, qualifier, val);
        this.table.put(p);
        for (int i = 0; i < 10; ++i) {
            this.table.put(p);
        }
        Get g = new Get(row);
        for (int i = 0; i < 10; ++i) {
            this.table.get(g);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long prior = 0L;
        for (int i = 0; i < timeranges.length; ++i) {
            long count2;
            dynamicMetricName = "Mutate_TimeRangeCount_" + prior + "-" + timeranges[i];
            if (metricsHelper.checkCounterExists(dynamicMetricName, (BaseSource)serverSource) && (count2 = metricsHelper.getGaugeLong(dynamicMetricName, (BaseSource)serverSource)) > 0L) {
                timeRangeCountUpdated = true;
                break;
            }
            prior = timeranges[i];
        }
        if (metricsHelper.checkCounterExists(dynamicMetricName = "Mutate_TimeRangeCount_" + timeranges[timeranges.length - 1] + "-inf", (BaseSource)serverSource) && (count = metricsHelper.getCounter(dynamicMetricName, (BaseSource)serverSource)) > 0L) {
            timeRangeCountUpdated = true;
        }
        Assert.assertEquals((Object)true, (Object)timeRangeCountUpdated);
    }

    @Test
    public void testAverageRegionSize() throws Exception {
        this.doNPuts(1, false);
        TEST_UTIL.getAdmin().flush(this.tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        Assert.assertTrue((metricsHelper.getGaugeDouble("averageRegionSize", (BaseSource)serverSource) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadBytes() throws Exception {
        this.doNPuts(1, false);
        this.doNGets(10, false);
        TEST_UTIL.getAdmin().flush(this.tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        Assert.assertTrue((String)"Total read bytes should be larger than 0", (metricsRegionServer.getRegionServerWrapper().getTotalBytesRead() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Total local read bytes should be larger than 0", (metricsRegionServer.getRegionServerWrapper().getLocalBytesRead() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Total short circuit read bytes should be equal to 0", (long)0L, (long)metricsRegionServer.getRegionServerWrapper().getShortCircuitBytesRead());
        Assert.assertEquals((String)"Total zero-byte read bytes should be equal to 0", (long)0L, (long)metricsRegionServer.getRegionServerWrapper().getZeroCopyBytesRead());
    }

    static {
        numScanNext = 0;
        cf = Bytes.toBytes((String)"cf");
        row = Bytes.toBytes((String)"row");
        qualifier = Bytes.toBytes((String)"qual");
        val = Bytes.toBytes((String)"val");
    }
}

