/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RowTooBigException;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRowTooBig {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowTooBig.class);
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    private static Path rootRegionDir;
    private static final TableDescriptor TEST_TD;

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster();
        HTU.getConfiguration().setLong("hbase.table.max.rowsize", 0xA00000L);
        rootRegionDir = HTU.getDataTestDirOnTestFS("TestRowTooBig");
    }

    @AfterClass
    public static void after() throws Exception {
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RowTooBigException.class)
    public void testScannersSeekOnFewLargeCells() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)TEST_TD).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])fam1)).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableDescriptor.getTableName()).build();
        HRegion region = HBaseTestingUtil.createRegionAndWAL(hri, rootRegionDir, HTU.getConfiguration(), tableDescriptor);
        try {
            for (int i = 0; i < 5; ++i) {
                Put put = new Put(row1);
                byte[] value = new byte[0x500000];
                put.addColumn(fam1, Bytes.toBytes((String)("col_" + i)), value);
                region.put(put);
                region.flush(true);
            }
            Get get = new Get(row1);
            region.get(get);
        }
        finally {
            HBaseTestingUtil.closeRegionAndWAL(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RowTooBigException.class)
    public void testScanAcrossManySmallColumns() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)TEST_TD).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])fam1)).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableDescriptor.getTableName()).build();
        HRegion region = HBaseTestingUtil.createRegionAndWAL(hri, rootRegionDir, HTU.getConfiguration(), tableDescriptor);
        try {
            for (int i = 0; i < 10; ++i) {
                Put put = new Put(row1);
                for (int j = 0; j < 100000; ++j) {
                    byte[] value = new byte[10];
                    put.addColumn(fam1, Bytes.toBytes((String)("col_" + i + "_" + j)), value);
                }
                region.put(put);
                region.flush(true);
            }
            region.compact(true);
            Get get = new Get(row1);
            region.get(get);
        }
        finally {
            HBaseTestingUtil.closeRegionAndWAL(region);
        }
    }

    static {
        TEST_TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)TestRowTooBig.class.getSimpleName())).build();
    }
}

